PRO shadow_getifc,parent=iparent,source=source,trace=trace,$
   structure=structure
;

;+
; NAME:
;	SHADOW_GETIFC
; PURPOSE:
;	Scripting SHADOWVUI RUNS
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_getIfc [,parent,source=src,trace=trc]
; INPUTS:
;	parent: The id  of the main ShadowVui window. If undefined, it
;               takes the default one. 
; KEYWORD PARAMETERS (OUTPUT):
;	PARENT = The widget Id of the SHADOWVui window where the value
;		will be changed. If undefined, it takes the current
;		ShadowVui window.
;	SOURCE  = Set to a name variable to receive a "source" object with the 
;               source parameters currently defined in the ShadowVui
;               window. 
;	TRACE  = Set to a name variable to receive an array of "oe: objects
;               with the source parameters currently defined in the ShadowVui
;               window. 
;		array and INDEX is not set, then INDEX=0 is assumed.
;	STRUCTURE = Set this kwyword to receivethe output as structures
;               instead of objects.
;	
;
; COMMON BLOCKS:
;	COMMON shadow_ifc,parent1
;	(to allow working without defining PARENT)
;
; EXAMPLE: 
;       ; see shadow3_test.ws
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio
;       2011/09/20 srio@esrf.eu written.
;
;-

COMMON shadow_ifc,parent1

;IF N_Elements(index) EQ 0 THEN index=0

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_GETIFC: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF

IF Keyword_Set(iparent) THEN BEGIN
  widget_control,iparent,get_uvalue=state
ENDIF ELSE BEGIN
  widget_control,parent1,get_uvalue=state
ENDELSE


widget_control,state.wids.src,get_value=isrc
noe = state.ifc.oe_n
source_str = *state.ptrSrc(isrc)
source_obj=obj_new('source',source1)
oei_str = *state.ptrTrc(0)
oei_obj = obj_new('oe',oei_str)
trace_str=replicate(oei_str[0],noe)
trace_obj=replicate(oei_obj[0],noe)
IF noe GT 1 THEN BEGIN
  FOR i=0L,noe-1 DO BEGIN
    oei_str = *state.ptrTrc(i)
    trace_str[i]=oei_str[0]
    oei_obj = obj_new('oe',oei_str)
    trace_obj[i]=oei_obj
  ENDFOR
ENDIF
IF keyword_set(structure) THEN BEGIN
    source=source_str
    trace=trace_str
ENDIF ELSE BEGIN
    source=source_obj
    trace=trace_obj
ENDELSE
RETURN
END
