function reflagmulti, shadow_in, SLITCOL=slitcol, FROM=from, TO=to, $
 FLAGVAL=flagval,FILE=FILE,COMPLEMENTARY=complementary,_Extra=extra

;+
; NAME:
;	REFLAGMULTI
; PURPOSE:
;	MAKES A MULTIPLE REFLAG (SEE ALSO REFLAG FUNCTION)
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	 shadow_out=reflagmulti(shadow_in)
; INPUTS:
;	shadow_in   IDL structure with SHADOW data
;	shadow_out  IDL structure with the resulting SHADOW data after
;		changing the flag
; OPTIONAL INPUTS:
; KEYWORD PARAMETERS:
;       SLITCOL   = an array with the numbers of the column where flag 
;		has to be applied.
;       FROM  = The minimum values of the slits (array)
;       TO  = The maximum values of the slits (array)
;	COMPLEMENTARY = when this keyword is set, the bad values are
;		the complementary of those in the SLITRANGE interval,
;		i.e., bad rays are OUTSIDE the SLITRANGE
;	FLAGVAL = value of the flag to out in (default=-1)
;	FILE = shadow file or IDL-SHADOW structure where to apply the 
;		SLITCOL and SLITRANGE keywords (If this keyword is omitted
;		then use the same as shadow_in)
;	_EXTRA = Other keywords are passed to REFLAG
;	OUTPUTS:
;	shadow_out: the ne IDL-SHADOW structure
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	It makes iterative calls to REFLAG
;
; EXAMPLE:
;	; calculates the intensity of star.03 over on a 1mm wide slit 
;       ; placed in the image plane (x,z)
;	a= reflagmulti('star.03',slitcol=[1,3],from=[-.5,.5],to=[0.5,0.5],$
;          complementary=1)
;       intens,a,/noLost
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble March 2009
;
;-
on_error,2
;

tmp = shadow_in
IF N_Elements(slitcol) EQ 0 THEN slitcol=[1,3]
IF N_Elements(from) EQ 0 THEN from=[0,0]
IF N_Elements(to) EQ 0 THEN to=[0,0]


FOR i=0,N_Elements(slitcol)-1 DO BEGIN
   tmp = reflag(tmp,SLITCOL=slitcol[i],SLITRANGE=[from[i],to[i]], $
  FLAGVAL=flagval,FILE=FILE,COMPLEMENTARY=complementary,_Extra=extra)
ENDFOR

return,tmp
END
