;
; srio@esrf.fr 00/03/27 changed !d.n_colors -> !d.n_colors<255


pro color_histo,data,wei,position = position,nbins = nbins,$
    climits = climits

on_error,2
if not(keyword_set(nbins)) then nbins = 100
if not(keyword_set(position)) then position = [.1,.1,.9,.9]
if not(keyword_set(climits)) then begin
    off = 0.1*abs(max(data)-min(data))
    if off lt 1e-10 then off = 0.5*max(data)
    crange = [min(data)-off,max(data)+off]
endif else begin
    crange = float(climits)  ; MSR 94/10/10 introduces float()
end
binsize =( crange(1)-crange(0))/float(nbins)
ddist = histogramw(data,wei,binsize = binsize,min = crange(0),$
    max = crange(1))
abscissa = findgen(nbins)*(crange(1)-crange(0))/(nbins) + crange(0) +$
    binsize/2
plot,abscissa,ddist,position = position,/nodata,/noerase,xrange = crange,$
    xstyle = 1,yrange = [0,1.1*max(ddist)]
xdevwin = !d.x_vsize*(!x.s(0) + !x.s(1)*crange)
xline = fltarr(2)
for i = xdevwin(0), xdevwin(1) do begin
    x = (i/!d.x_vsize - !x.s(0))/!x.s(1)
    xline(*) = i 
    index = (x-crange(0))/(crange(1)-crange(0))*nbins
    index = (index > 0) < (n_elements(ddist)-1)
    yline= [0,ddist(index)]
    yline = !d.y_vsize*(!y.s(0) + !y.s(1)*yline)
    clr = (x-crange(0))/(crange(1)-crange(0))*(!d.n_colors<255) -1
    clr = (clr < ( (!d.n_colors<255) -1) ) > 0
    plots,xline,yline,/device,$
	color = clr
	;color = (x-crange(0))/(crange(1)-crange(0))*251 + 3
end
plot,abscissa,ddist,position = position,/noerase,/nodata,$
    xrange = crange,xstyle = 1,yrange = [0,1.1*max(ddist)]
end
