;+
; NAME:
;       COLOR_MODEL
;
; PURPOSE:
;       This procedure changes the the color of all the Polygone of a 
;		Graphic model.
;
; CATEGORY:
;       Graphic.
;
; CALLING SEQUENCE:
;       COLOR_MODEL, Model, Color
;
; INPUTS:
;       Model:    An IDLGrModel object.
;
;		Color:    An 3-element vector of type integer, the new color 
;			in RVB.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE
;		Color=[0,255,0] ;green
;		COLOR_MODEL, Model, Color
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
pro color_model, model, colors

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'color_model: error caught: '+!error_state.msg)
   RETURN
ENDIF


	n=model->count()
	for p=0, n-1 do begin
		obj=model->get(pos=p)
		if OBJ_ISA(obj, 'IDLgrModel') then color_model, obj, colors
		if OBJ_ISA(obj, 'IDLgrpolygon') then obj->setProperty, color=colors
		if OBJ_ISA(obj, 'IDLgrAxis') then obj->setProperty, color=colors
		if OBJ_ISA(obj, 'idlgrpolyline') then obj->setProperty, color=colors

	endfor
end

