
;		
;========================================================================
;
; accepts also an array of indices. If index is not defined, then it
; runs all macros
;
PRO Shadow_RunMacro, input, index,  Group=group

;+
; NAME:
;	SHADOW_RUNMACRO
; PURPOSE:
;	Runs an IDL macro
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_runmacro
; INPUTS:
; OPTIONAL INPUTS:
;	input: the macro parent widget ID or structure (usually from COMMON)
;	index: the macro index (in ShadowVui)
; KEYWORD PARAMETERS:
;       GROUP The parent id for the caller widget (used to positioning
;               error and information windows).
; OUTPUTS:
;	Runs the corresponding macro
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
;       COMMON shadow_ifc,parent1
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward
; MODOFICATION HISTORY:
;	srio@esrf.eu 20140627 stacted from shadow3. Documented.
;
;-
;
catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message(/Error,Dialog_Parent=group,$
	'SHADOW_RUNMACRO: Error caught: '+!err_string)
   return
endif



COMMON shadow_ifc,parent1

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_RUNMACRO: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF


CASE type(input) OF
  0: BEGIN ; undefined
     Widget_Control,parent1,Get_UValue=state
     END
  3: BEGIN ; widget_parent
     Widget_Control,input,Get_UValue=state
     END
  8: BEGIN ; state (structure)
     state=input
     END
  else: Message,'Bad input'
ENDCASE
ptrMacros = *state.ptrPtrMacros
IF N_Elements(index) EQ 0 THEN index = LIndGen(N_Elements(ptrMacros))

Widget_Control,/Hourglass
FOR i=0L,N_Elements(index)-1 DO BEGIN
  Message,/Info,'Running macro # '+StrCompress(index[i]+1)
  prog=*( ptrMacros[index[i]] )
  IF N_Elements(prog) EQ 1 AND prog[0] EQ '' THEN BEGIN  ; running nothing
  ENDIF ELSE BEGIN
    tmp = Xop_Macro_Compact(prog,Group=group,/Execute)
  ENDELSE
ENDFOR

END ; Shadow_RunMacro

