Function wave_findvalue, wave, x, y, z
    S = size(wave.w)
    ; this is for xop2.4 (IDL8.3)
    if float(!version.release) GT 8.2 then begin
        case (S[0]) of
          1:result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, /DOUBLE, /GRID)
          2:result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, (y-wave.yoffset)/wave.ydelta, /DOUBLE, /GRID)
          3: result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, (y-wave.yoffset)/wave.ydelta, (z-wave.zoffset)/wave.zdelta, /DOUBLE, /GRID)
          else: print, 'dimension above 3 are not supported'
        endcase
    endif else begin ; for xop2.3 (double kw not accepted)
        case (S[0]) of
          1:result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, /GRID)
          2:result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, (y-wave.yoffset)/wave.ydelta, /GRID)
          3: result=Interpolate(wave.w, (x-wave.xoffset)/wave.xdelta, (y-wave.yoffset)/wave.ydelta, (z-wave.zoffset)/wave.zdelta, /GRID)
          else: print, 'dimension above 3 are not supported'
        endcase
    endelse
    return,result
End

