FUNCTION div_grid_circle,cTheta,npoints,FILE=file, Group=group

;+
; NAME:
;	DIV_GRID_CIRCLE
;
; PURPOSE:
;       This function returns the director cosines (i.e, normalized velocity 
;	vectors) of a radial circinference (i.e., a cone with vertex in the 
;	source position).
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
;       v = Div_Grid_Circle(cTheta,nPoints)
;
; INPUTS:
;       
;	cTheta: The cone semi-aperture angle [rad]
;	nPoints: The number of points over the circle 
;
; KEYWORD PARAMETERS
;	File: a string cointaining a file name where to write
;		(optionally) the data. The file type is SHADOW binary.
;	Group: The widget ID of the caller. 
;
; OUTPUTS:
;       This function return the array v(3,npoints) with vx, vy and vz
;	in the columns 0,1 and 2, respectively.
;
; PROCEDURE:
;       
;       Easy.
;
; EXAMPLE:
;	v=Div_Grid_Circle(1.0D0,100) &  Plot,v[0,*],v[2,*]
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr), 99-12-23
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'DIV_GRID_CIRCLE: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

;
;
IF N_Elements(cTheta) EQ 0 THEN cTheta  = 0.1D0 ; rad
IF N_Elements(npoints) EQ 0 THEN npoints = 360L

theta = DIndGen(nPoints)/(nPoints-1)
theta = theta*2.0D0*!dpi
;r = 1.0D0
;vy = r*cos(cTheta)
;help,r*cos(cTheta),r*sin(cTheta)
;vx = (r*sin(cTheta))*cos(theta)
;vz = (r*sin(cTheta))*sin(theta)
;vy = Replicate(vy,nPoints)
vx = cTheta*cos(theta)
vz = cTheta*sin(theta)
vy = Sqrt( ((vx*vx+vz*vz)*(-1.0D0) + 1.0D0)>0 )
v = make_set(vx,vy,vz)
IF Keyword_Set(file) THEN WriteSh,file,v,[4,5,6]
RETURN,v
end

