FUNCTION coniclens,p,q,delta=delta1,type=itype,  $
  n0=n0,n1=n1, $
  cylindrical=cylindrical, cylangle=cylangle, $ ; in degrees
  convex=convex,txt=txt

;+
;
;       NAME:
;               CONICLENS
;       PURPOSE:
;               This function Calculates the 10 conic
;               coefficients from the focusing conditions
;               of a lens
;       CATEGORY:
;               SHADOW tools
;       CALLING SEQUENCE:
;               c = coniclens(p,q,delta=delta)
;
; 	INPUTS:
;		p: distance source-surface [cm]
;		q: distance surface-image [cm]
;	
; 	KEYWORD PARAMETERS
;		DELTA: The refraction index is n=1-delta
;		TYPE: 
;        	       '0'
;        	       'Spherical-1'
;        	       'Ellipsoidal-2'
;        	       'Toroidal-3'
;        	       'Paraboloid-4'
;        	       'Plane-5'
;        	       '6'
;        	       'Hyperboloid-7'
;        	       'Cone-8??'
;        	       'Polynomial-9??
;		n0: The object refraction index
;		n1: The image refraction index
;		CYLINDRICAL: set to 1 for cylindrical symmetry
;		CYLANGLE: if cylindrical is set, the angle between
;		  the cylinder axis and the X axis in deg.
;		CONVEX: set to 1 for invering convexity
;		TXT: set to a named variable to receive some 
;		     info on the calculations.
;
;	ALGORITHM: 
;		 Adapted from SHADOW/MSETUP 
;	
;		 Equation of the conic: 
;
;	         c[0]*X^2 + c[1]*Y^2 + c[2]*Z^2 +
;                c[3]*X*Y + c[4]*Y*Z + c[5]*X*Z  +
;                c[6]*X + c[7]*Y + c[8]*Z + c[9] = 0 

;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu, Sept. 29, 2009
;	
;	MODIFICATION HISTORY:
;               2010-01-26 srio@esrf.eu corrected parabola
;
;-
;C+++
;C
;C	SUBROUTINE	MSETUP
;C
;C	PURPOSE		To compute the parameters specifying a given
;C			mirror.
;C
;C	OUTPUT		a) to common block
;C			b) MSETxx, xx being the OE number
;C
;C---

IF N_Elements(iType) EQ 0 THEN iType=1
IF N_Elements(p) EQ 0 THEN p=3000000000D0
IF N_Elements(q) EQ 0 THEN q=1000D0
IF N_Elements(delta1) NE 0 THEN n1=1D0-delta1
IF N_Elements(cyl) EQ 0 THEN cyl=0
IF N_Elements(cylAngle) EQ 0 THEN cylAngle=0.0
IF N_Elements(convex) EQ 0 THEN convex=0
;
; refraction indices
;
IF N_Elements(n0) EQ 0 THEN n0=1D0
IF N_Elements(n1) EQ 0 THEN n1=0.95


SSOUR=Double(p)
SIMAG=Double(q)


oeType=['0', $
        'Spherical-1', $
        'Ellipsoidal-2', $
        'Toroidal-3', $
        'Paraboloid-4', $
        'Plane-5', $
        '6', $
        'Hyperboloid-7', $
        'Cone-8??', $
        'Polynomial-9??']



	  txt = ['************ coniclens *************',$
             'Computation of conic equation of the form: ',$
             '    c[0]*X^2 + c[1]*Y^2 + c[2]*Z^2 + ',$
             '    c[3]*X*Y + c[4]*Y*Z + c[5]*X*Z  + ',$
             '    c[6]*X + c[7]*Y + c[8]*Z + c[9] = 0  ',$
             '','Inputs: ',$
                String('p[cm]: ',p,Format='(A40,G20.15)'),$
                String('q[cm]: ',q,Format='(A40,G20.15)'),$
                String('refraction index n0: ',n0, Format='(A40,G20.15)'),$
                String('refraction index n1: ',n1, Format='(A40,G20.15)'),$
                String('Conic type: ', $
                       oeType[iType], $
                       Format='(2A40)'),$
                String('Invert convexity flag: ', $
                       convex, $
                       Format='(A40,I5)'),$
                String('Cylindrical symmetry flag: ', $
                       cyl, $
                       Format='(A40,I5)'),$
                String('Cylindrial axes to X [deg]: ', $
                       cylAngle, $
                       Format='(A40,G20.15)'), $
             '','','','Outputs: ']

ccc = DblArr(10)


CASE itype OF
        0:
	1: BEGIN ; Spherical
		;RMIRR = SSOUR*SIMAG*2/COSTHE/(SSOUR + SIMAG)
		;RMIRR = 1D0/(-n0/SSOUR+n1/SIMAG)
                RMIRR = 1D0/(n0/SSOUR+n1/SIMAG)
		RMIRR = RMIRR*(n1-n0)

		CCC(1-1) =  1.0D0	; X^2  # = 0 in cylinder case
		CCC(2-1) =  1.0D0	; Y^2
		CCC(3-1) =  1.0D0	; Z^2
		CCC(4-1) =   .0D0	; X*Y   # = 0 in cylinder case
		CCC(5-1) =   .0D0	; Y*Z
		CCC(6-1) =   .0D0	; X*Z   # = 0 in cylinder case
		CCC(7-1) =   .0D0	; X     # = 0 in cylinder case
		CCC(8-1) =   .0D0	; Y
		;CCC(9-1) = -2*RMIRR	; Z
		CCC(9-1) = 2*RMIRR	; Z
		CCC(10-1)  =   .0D0	; G
		txt = [txt, String('Spherical radius: ', $
                       RMIRR, Format='(A40,G20.15)'), $ 
                            String('Lens power: ', $
                       (n1-n0)/RMIRR, Format='(A40,G20.5)')]
	   END
	2: BEGIN ; Ellipsoidal
                ;;delta0 = 1D0-n0
                ;;delta1 = 1D0-n1
                ; approx...
		;AXMAJ 	=  SIMAG/(2D0-delta0)
		;AXMIN 	=  SIMAG*SQRT(delta0/(2D0-delta0))
		;;AXMAJ 	=  SIMAG/(2D0-delta0)
		AXMAJ 	=  SIMAG/(n0+n1)
                ee = n1/n0
                ; print,"ee: ",ee
                IF ee GT 1 THEN ee=1.0d0/ee
                ;AXMAJ 	=  SIMAG/(ee+1)
		;;AXMIN 	=  SIMAG*SQRT(abs(delta0)/(2D0-delta0))
		AXMIN 	=  SIMAG*SQRT(abs(n1-n0)/(n0+n1))
                ;;AXMIN 	=  AXMAJ*sqrt(1.0D0-ee*ee)

		AFOCI 	=  SQRT( AXMAJ^2-AXMIN^2 )
                ; print,"a,b,c: ",AXMAJ,AXMIN,AFOCI

		ECCENT 	=  AFOCI/AXMAJ
                ; print,"ECCENT, ee: ",ECCENT,ee
		;C
		;C The center is computed on the basis of the object and image positions
		;C
		;YCEN  = (SSOUR-SIMAG)*0.5D0/ECCENT
		;ZCEN  = -SQRT(1-YCEN^2/AXMAJ^2)*AXMIN
		YCEN  = -AXMAJ
		ZCEN  = 0D0
		;C
		;C Computes now the normal in the mirror center.
		;C
		rncen=DblArr(3)
		RNCEN(1-1)  =   .0D0
		;RNCEN(2-1)  = - 2*YCEN/AXMAJ^2
		;RNCEN(3-1)  = - 2*ZCEN/AXMIN^2
		RNCEN(2-1)  = -1D0
		RNCEN(3-1)  = 0.0D0
		;rncen = rncen/Sqrt(Total(rncen^2))
		;C
		;C Computes the tangent versor in the mirror center.
		;C
		rtcen=DblArr(3)
		RTCEN(1-1)  =  .0D0
		RTCEN(2-1)  =   RNCEN(3-1)
		RTCEN(3-1)  = - RNCEN(2-1)
		;C


		txt = [txt,  $
                       String('Rev Ellipsoid a: ', $
                       AXMAJ, Format='(A40,G20.15)'), $
                       String('Rev Ellipsoid b: ', $
                       AXMIN, Format='(A40,G20.15)'), $
                       String('Rev Ellipsoid c=sqrt(a^2-b^2): ', $
                       AFOCI, Format='(A40,G20.15)'), $
                       String('Rev Ellipsoid focal discance c^2: ', $
                       AFOCI^2, Format='(A40,G20.15)'), $
                       String('Rev Ellipsoid excentricity: ', $
                       ECCENT, Format='(A40,G20.15)'),$
                       'Mirror center at: '+vect2string([0,YCEN,ZCEN]), $
                       'Mirror normal: '+vect2string(RNCEN), $
                       'Mirror tangent: '+vect2string(RTCEN) ] 
		;C Computes now the quadric coefficient with the mirror center
		;C located at (0,0,0) and normal along (0,0,1)
		;C
		A 	=  1/AXMIN^2
		B 	=  1/AXMAJ^2
		C 	=  A
		CCC(1-1) 	=  A
		CCC(2-1) 	=  B*RTCEN(2-1)^2 + C*RTCEN(3-1)^2
		CCC(3-1) 	=  B*RNCEN(2-1)^2 + C*RNCEN(3-1)^2
		CCC(4-1) 	=  .0D0
		CCC(5-1) 	=  2*(B*RNCEN(2-1)*RTCEN(2-1)+C*RNCEN(3-1)*RTCEN(3-1))
		CCC(6-1) 	=  .0D0
		CCC(7-1) 	=  .0D0
		CCC(8-1) 	=  .0D0
		CCC(9-1) 	=  2*(B*YCEN*RNCEN(2-1)+C*ZCEN*RNCEN(3-1))
		CCC(10-1) =  .0D0
	   END
	3: BEGIN ; Toroidal ?????????????????
		R_MAJ	=   SSOUR*SIMAG*2/COSTHE/(SSOUR + SIMAG)
		R_MIN	=   SSOUR*SIMAG*2*COSTHE/(SSOUR + SIMAG)
		txt = [txt, 'Toroid is not a conic!', $
                       String('Major radius: ', $
                       R_MAJ, Format='(A40,G20.15)'), $
                       String('Minor radius: ', $
                       R_MIN, Format='(A40,G20.15)')]
		;C
		;C NOTE : The major radius is the in reality the radius of the torus
		;C max. circle. The true major radius is then
		;C
		R_MAJ	=   R_MAJ - R_MIN
	   END
	4: BEGIN ; Paraboloid
		;C
		;C Computes the parabola 
		;C
                RMIRR = 1D0/(n0/SSOUR+n1/SIMAG)
                RMIRR = RMIRR*(n1-n0)
		PARAM = -RMIRR
                COSTHE = 1.0D0
                SINTHE = 0.0D0
		IF SSOUR LT SIMAG THEN BEGIN
		  ;PARAM	=   2*SSOUR*COSTHE^2
     		  YCEN	= - SSOUR*SINTHE^2
     		  ZCEN	= - 2*SSOUR*SINTHE*COSTHE
		  fact = -1.0D0
		ENDIF ELSE BEGIN
		  ;PARAM	=   2*SIMAG*COSTHE^2
     		  YCEN	= - SIMAG*SINTHE^2
     		  ZCEN	= - 2*SIMAG*SINTHE*COSTHE
		  fact = 1.0D0
		ENDELSE
		txt = [txt, $
                       String('Paraboloid p (-R): ', $
                       PARAM, Format='(A40,G20.15)')]
		CCC(1-1)	=   1.0D0
		CCC(2-1)	=   COSTHE^2
		CCC(3-1)	=   SINTHE^2
		CCC(4-1)  =    .0D0
		CCC(5-1)	=   2*fact*COSTHE*SINTHE
		CCC(6-1)	=    .0D0
		CCC(7-1)	=    .0D0
		CCC(8-1)	=    .0D0
		CCC(9-1)	=   2*ZCEN*SINTHE - 2*PARAM*COSTHE
		CCC(10-1) =    .0D0
	   END
	5: BEGIN  ; Plane
		;C
		;C The sign of CCC(9) is < 0 to keep consistency with the other cases
		;C normal.
		;C
		CCC(9-1) = - 1.0D0
		txt = [txt, 'Plane is a degenerated conic']
	   END
        6:
	7: BEGIN  ; Hyperbolical
                delta0 = 1D0-n0
                delta1 = 1D0-n1
		;AXMAJ 	=  ( SSOUR + SIMAG )/2	
		;AXMIN 	=  SQRT(SIMAG*SSOUR)*COSTHE
                ; approx...
		;;AXMAJ 	=  SIMAG/(2D0-delta0)
		;;AXMIN 	=  SIMAG*SQRT(abs(delta0)/(2D0-delta0))

                EE = n0/n1
                IF ee LT 1 THEN ee=1.0D0/ee
                ; print, ">> EE: ",EE
                AXMAJ 	=  SIMAG/(1D0+EE)
                ;TMP = (1.0D0/(1.0D0/SIMAG+1.0D0/SSOUR))
                ;print,">> tmp: ",tmp
                ;AXMAJ 	=  tmp  /(1D0+EE)
                CC = AXMAJ*EE
                ; print,"a,c: ",AXMAJ,CC
                AXMIN 	=  sqrt(CC*CC-AXMAJ*AXMAJ)
                ; print,"b: ",AXMIN


		AFOCI 	=  SQRT( AXMAJ^2+AXMIN^2 )
		ECCENT 	=  AFOCI/AXMAJ
; print, ">> ECCENT: ",ECCENT

                BRANCH=1.0D0 ; branch=+1,-1

                YCEN  = -AXMAJ
		ZCEN  = 0.0D0
; 
		rncen = DblArr(3)
		RNCEN (1-1) = 0.0D0
		RNCEN (2-1) = -1.0
		RNCEN (3-1) = 0.0D0
	
		;C
		;C Computes the tangent in the same RF
		;C
		rtcen = DblArr(3)
		RTCEN (1-1) =   0.0D0
		RTCEN (2-1) = - RNCEN(3-1)   ; > 0 
		RTCEN (3-1) =   RNCEN(2-1)   ; > 0


		txt = [txt,  $
                       String('Rev Hyperboloid a: ', $
                       AXMAJ, Format='(A40,G20.15)'), $
                       String('Rev Hyperboloid b: ', $
                       AXMIN, Format='(A40,G20.15)'), $
                       String('Rev Hyperboloid c: ', $
                       AFOCI, Format='(A40,G20.15)'), $
                       String('Rev Hyperboloid focal discance c^2: ', $
                       AFOCI^2, Format='(A40,G20.15)'), $
                       String('Rev Hyperboloid excentricity: ', $
                       ECCENT, Format='(A40,G20.15)'), $
                       'Mirror BRANCH: '+String(branch), $
                       'Mirror center at: '+vect2string([0,YCEN,ZCEN]), $
                       'Mirror normal: '+vect2string(RNCEN), $
                       'Mirror tangent: '+vect2string(RTCEN) ] 
		;C
		;C Coefficients of the canonical form
		;C
		A	= - 1/AXMIN^2
		B	=   1/AXMAJ^2
		C	=   A
		;C
		;C Rotate now in the mirror RF. The equations are the same as for the
		;C ellipse case.
		;C
		CCC(1-1) 	=  A
		CCC(2-1) 	=  B*RTCEN(2-1)^2 + C*RTCEN(3-1)^2
		CCC(3-1) 	=  B*RNCEN(2-1)^2 + C*RNCEN(3-1)^2
		CCC(4-1) 	=  .0D0
		CCC(5-1) 	= 2*(B*RNCEN(2-1)*RTCEN(2-1)+C*RNCEN(3-1)*RTCEN(3-1))
		CCC(6-1) 	=  .0D0
		CCC(7-1) 	=  .0D0
		CCC(8-1) 	=  .0D0
		CCC(9-1) 	= 2*(B*YCEN*RNCEN(2-1)+C*ZCEN*RNCEN(3-1))
		CCC(10-1) =  .0D0
	   END
	8: BEGIN ; Ice-cream cone
		CCC(1-1)	=  1.0D0
		CCC(2-1)	=  1.0D0
		;CCC(3-1)	=  -(TAN (!dpi/180*CONE_A))^2
		CCC(3-1)	=  -(TAN (THETA))^2
		txt = [txt, 'Cone is an Ice-cream cone']
	   END
        9:
	else: BEGIN
           print,'Optical surface type not found: '+oeType[iType]
	   END
ENDCASE

;
; cylindrical case
;
;C
;C Set to zero the coeff. involving X for the cylinder case, after 
;C projecting the surface on the desired plane.
;C
	IF Keyword_Set(cylindrical) THEN BEGIN
	  IF N_Elements(cylangle) EQ 0 THEN CIL_ANG=0.0D0 ELSE CIL_ANG=cylAngle
     	  CIL_ANG = !dpi/180*CIL_ANG
     	  COS_CIL = COS(CIL_ANG)
     	  SIN_CIL = SIN(CIL_ANG)

     	  A_1	=   CCC(1-1)
     	  A_2	=   CCC(2-1)
     	  A_3	=   CCC(3-1)
     	  A_4	=   CCC(4-1)
     	  A_5	=   CCC(5-1)
     	  A_6	=   CCC(6-1)
     	  A_7	=   CCC(7-1)
     	  A_8	=   CCC(8-1)
     	  A_9	=   CCC(9-1)
     	  A_10	=   CCC(10-1)
     	  CCC(1-1) =  A_1*SIN_CIL^4 + A_2*COS_CIL^2*SIN_CIL^2 - $   ;X^2
     		    A_4*COS_CIL*SIN_CIL^3
     	  CCC(2-1) =  A_2*COS_CIL^4 + A_1*COS_CIL^2*SIN_CIL^2 - $ ;Y^2
                    A_4*COS_CIL^3*SIN_CIL
     	  CCC(3-1) =  A_3						 ;Z^2
     	  CCC(4-1) =  - 2*A_1*COS_CIL*   SIN_CIL^3 - $		      
		      2*A_2*COS_CIL^3*SIN_CIL + $
		      2*A_4*COS_CIL^2*SIN_CIL^2		 ;X Y
     	  CCC(5-1) =  A_5*COS_CIL^2 - A_6*COS_CIL*SIN_CIL	 ;Y Z
     	  CCC(6-1) =  A_6*SIN_CIL^2 - A_5*COS_CIL*SIN_CIL	 ;X Z
     	  CCC(7-1) =  A_7*SIN_CIL^2 - A_8*COS_CIL*SIN_CIL	 ;X
     	  CCC(8-1) =  A_8*COS_CIL^2 - A_7*COS_CIL*SIN_CIL	 ;Y
     	  CCC(9-1) =  A_9						 ;Z
     	  CCC(10-1)=  A_10
     	ENDIF
;C
;C Set the correct mirror convexity, i.e., Z->-Z
;C
     	IF CONVEX EQ 1 THEN BEGIN
     	  CCC(5-1)  = - CCC(5-1)
     	  CCC(6-1)  = - CCC(6-1)
     	  CCC(9-1)  = - CCC(9-1)
     	ENDIF

      txt=[txt,'','']
      FOR i=0,9 DO txt=[txt,String(' c['+StrCompress(i,/Rem)+']=',$
         ccc[i],Format='(A6,G20.10)')]

RETURN,CCC
END
