pro blv_read_config, pInfo, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_read_config: error caught: '+!error_state.msg)
   RETURN
ENDIF


IF float(!version.release) GE 5.4 THEN $
  test=file_test((*pInfo).data.config_file) ELSE $
  test = CheckFile((*pInfo).data.config_file)

CASE test OF
  1: BEGIN
     diag = DIALOG_MESSAGE(Dialog_Parent=group, /INFORMATION, $
	'Using configuration file: '+String((*pInfo).data.config_file))
     END
  else: BEGIN
     diag = DIALOG_MESSAGE(Dialog_Parent=group, /INFORMATION, $
       ['Configuration file: blviewer.config not found.','',$
       'A configuration file named blviewer.config containing a text line',$
       'with the name of the systemfile (e.g., systemfile.dat) can be defined'])
     RETURN
     END
ENDCASE


openR, lun, (*pInfo).data.config_file, /get_lun
line=''
readf, lun, line
line=STRTRIM(line, 2)
(*pInfo).data.last_file_name=line
close, lun
free_lun, lun
end
