; 
;===============================================================================
;
Pro xshoe_f_crystal,oestr,GROUP=group,ACTION=action, isLaue=isLaue

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_F_CRYSTAL: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')
if n_elements(isLaue) EQ 0 then isLaue=0

titles=[ 'File with crystal parameters [enter ? to create it]',$
  'Reflectivity mode',$
  'Auto setting',$
  'Units in use',$
  'Set photon energy [ eV ]',$
  'Set wavelength [ A ]',$
  'Asymmetric cut',$
  'Johansson Geometry',$
  'Mosaic crystal',$
  'Planes angle [ deg ]',$
  'Below[-1]/onto[1] bragg planes',$
  'Johansson Radius',$
  'Angle spread FWHM [ deg ]',$
  'Thickness [ cm ]',$
  'Seed for mosaic [ > 10^5 ]' ]

flags = ['1',$
  '0',$
  '1',$
  'w(2) EQ 1',$
  '(w(2) EQ 1) AND (w(3) EQ 0)',$
  '(w(2) EQ 1) AND (w(3) NE 0)',$   ; 5 angstroms
  'w(8) NE 1',$  ; asymmetric
  'w(8) NE 1',$  ; johansson
  '1',$  ; 8 mosaic
  '(w(8) NE 1) AND (w(6) EQ 1)',$ ; 9 asymmetry angle
  '(w(8) NE 1) AND (w(6) EQ 1)',$ ; below/onto bragg planes
  '(w(8) NE 1) AND (w(7) EQ 1)',$ ; Johansson Radius
  'w(8) EQ 1',$ ; Angle spread FWHM
  '(w(8) EQ 1) OR (w(6) EQ 1) ',$
  'w(8) EQ 1' ]
 
if isLaue EQ 1 then flags[13]='1'
if isLaue EQ 0 then flags[10]='0'

 
tmp =    { FILE_REFL:oestr.FILE_REFL, $
   F_REFLEC:[strcompress(oestr.F_REFLEC,/rem),'OFF','POLARIZED','SCALAR'],$
   F_CENTRAL:[strcompress(oestr.F_CENTRAL,/rem),'No','Yes'],$
   F_PHOT_CENT:[strcompress(oestr.F_PHOT_CENT,/rem),'eV','Angstroms'],$
   PHOT_CENT:oestr.PHOT_CENT, $
   R_LAMBDA:oestr.R_LAMBDA, $
   F_BRAGG_A:[strcompress(oestr.F_BRAGG_A,/rem),'No','Yes'], $
   F_JOHANSSON:[strcompress(oestr.F_JOHANSSON,/rem),'No','Yes'], $
   F_MOSAIC:[strcompress(oestr.F_MOSAIC,/rem),'No','Yes'], $
   A_BRAGG:oestr.A_BRAGG, $
   ORDER:oestr.ORDER, $
   R_JOHANSSON:oestr.R_JOHANSSON, $
   SPREAD_MOS:oestr.SPREAD_MOS, $
   THICKNESS:oestr.THICKNESS, $
   MOSAIC_SEED:oestr.MOSAIC_SEED }


action=0
; help,tmp.phot_cent
; help,/str,tmp
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Crystal Specifications',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=2

if action eq 'DONT' then return

IF  StrCompress(tmp.FILE_REFL,/Rem) EQ '?' THEN BEGIN
  XSH_BRAGG,outFile=file,/NoAsk,Action=action
  IF action NE 'DONT' THEN tmp.FILE_REFL=file
ENDIF

oestr.FILE_REFL = tmp.FILE_REFL
oestr.F_REFLEC = fix(tmp.F_REFLEC(0))
oestr.F_CENTRAL = fix(tmp.F_CENTRAL(0))
oestr.F_PHOT_CENT = fix(tmp.F_PHOT_CENT(0))
oestr.PHOT_CENT = tmp.PHOT_CENT
oestr.R_LAMBDA = tmp.R_LAMBDA
oestr.F_BRAGG_A = fix(tmp.F_BRAGG_A(0))
oestr.F_JOHANSSON = fix(tmp.F_JOHANSSON(0))
oestr.F_MOSAIC = fix(tmp.F_MOSAIC(0))
oestr.A_BRAGG = tmp.A_BRAGG
oestr.ORDER = tmp.ORDER
oestr.R_JOHANSSON = tmp.R_JOHANSSON
oestr.SPREAD_MOS = tmp.SPREAD_MOS
oestr.THICKNESS = tmp.THICKNESS
oestr.MOSAIC_SEED = tmp.MOSAIC_SEED

return
end

