;+
;
;   ===========================  XSh_MLayer   =========================
;
;   XSh_MLayer is a widget based graphical interface to use the code
;   mlayer. Mlayer is part of the ray tracing code SHADOW and calculates
;   the reflectivities and among other quantities of the multilayers.
;
;   The main window contains four buttons:
;
;	QUIT: to exit from the program
;
;	SET PARAMETERS: to define the parameters for the calculation
;		LAYER PERIODICITY: Multilayer may be periodic or
;		aperiodic. In the first case you may define the number
;		of layer pairs and the thickness of the two components 
;		of the pair. In the secon case you must prepare a file 
;		containing two columns and N rows, one row for each pair.
;		The first element of the column is the thickness in A of 
;		the odd element and the second column is the thickness
;		of the even element.
;		SCANNING VARIABLE: Grazing angle [deg] or Photon 
;		Energy [eV]
;		SUBSTRATE: Chamical symbol for the substrate.
;		ODD LAYER MATERIAL's chemical symbol for the odd layer
;		EVEN LAYER MATERIAL's chemical symbol for the even layer
;		PHOTON ENERGY: in eV
;		GRAZING ANGLE: in degrees
;		SCANNING VARIABLE STEP: the spep in either Photon energy
;		or grazing angle, depending on your choice.
;		NUMBER OF SCANNING POINTS: obvious.
;		THICKNESS FOR THE ODD MATERIAL in A, when periodic
;		Mlayers are considered.
;		THICKNESS FOR THE EVEN MATERIAL in A, when periodic
;		Mlayers are considered.
;		NUMBER OF LAYER PAIRS when periodic
;		Mlayers are considered.
;		FILE WITH LAYER THICKNESSES: file name with thicknesses
;		as explained before, valid only when Individual layers
;		are considered.
;
;		
;	SHOW: Produces a graphic of the selected option
;
;	HELP:   Shows this text
;
;
; ----------------------------------------------------------------------
;	Mlayer has been witten by J.H. Underwood at CXRO and is part 
;	of the SHADOW package. M. Sanchez del Rio has modified it to
;	directly call the SHADOW optics library, which gives correct
;	values of refraction indeces when the energy is scanned.
;	M. Sanchez del Rio (srio@esrf.fr) has writen this graphic 
;	interface.
;
;	MSR 94-03-02
;       Modification history:
;	  95-11-07 MSR adapts to xop 1.3b. Adds in/out input file.
;	  97-01-21 MSR adapts to Windows95. Cosmetics. Version 1.1.
;	  97-10-01 MSR renames read_ascii by rascii
;	  97-10-02 MSR uses sdep(), xop_wd and other cosmetics.
;	  97-10-06 MSR replaces xop_defaults() call by shadow_defaults()
;		call and places xsh_mlayer.pro in the exrtensions/shadow dir.
;	  97-12-05 MSR adapts for SHADOW-GUI. Version 1.2.
;
;-
;
;========================================================================
;
FUNCTION XSH_MLAYER_VERSION
return,'1.2'
end
;		
;========================================================================
;
PRO XSH_MLAYER_INP_WRITE,inp,NAME=name
;
; write the contents of the structure with parameters for running mlayer
;
IF NOT(KEYWORD_SET(name)) THEN name='xsh_mlayer_tmp.inp'
;
OPENW,unit,name,/GET_LUN
;
icase = 0
if ((strcompress(inp.scan(0),/rem) eq '0') $
	and (strcompress(inp.mode(0),/rem) eq '0')) then icase = 1
if ((strcompress(inp.scan(0),/rem) eq '1') $
	and (strcompress(inp.mode(0),/rem) eq '0')) then icase = 5
if ((strcompress(inp.scan(0),/rem) eq '0') $
	and (strcompress(inp.mode(0),/rem) eq '1')) then icase = 3
if ((strcompress(inp.scan(0),/rem) eq '1') $
	and (strcompress(inp.mode(0),/rem) eq '1')) then icase = 5
printf,unit,icase
printf,unit,'N'
printf,unit,p_table(inp.Substrate,/SHADOW)
printf,unit,p_table(inp.Substrate,/DENS)
printf,unit,p_table(inp.Odd_material,/SHADOW)
printf,unit,p_table(inp.Odd_material,/DENS)
printf,unit,p_table(inp.Even_material,/SHADOW)
printf,unit,p_table(inp.Even_material,/DENS)
;
printf,unit,12398.52/inp.energy
printf,unit,inp.theta
if (strcompress(inp.scan(0),/REM) eq '0') then printf,unit,inp.scan_step $
	else begin
          lambda0 = 12398.52/inp.energy
          lambda1 = 12398.52/(inp.energy+inp.scan_step)
	  scan_step = lambda1-lambda0
         printf,unit,scan_step
        endelse
printf,unit,inp.Npoints
if (strcompress(inp.mode(0),/rem) eq '0') then begin
  message,/info,'Periodic Layers selected'
  printf,unit,inp.Nlayers
  if (icase ne 5) then begin
    printf,unit,inp.odd_thickness,inp.even_thickness 
  endif else begin
    for i=1,inp.Nlayers do printf,unit,inp.odd_thickness,inp.even_thickness
  endelse
  printf,unit,'xsh_mlayer_tmp.par'
  printf,unit,'xsh_mlayer_tmp.out'
  printf,unit,'6'
  free_lun,unit
endif else begin
  message,/info,'Indivudual Layers selected'
  ; update inp.Nlayers
  if sdep() EQ 'WINDOWS' then begin
    a=0
    openr,unitTmp,inp.file,/GET_LUN
    stmp = ''
    while not eof(unitTmp) do begin
      readf,unitTmp,stmp
      a=a+1
    endwhile
    free_lun,unitTmp
    inp.Nlayers=a
  endif else begin
    message,/info,'Executing: '+'wc '+inp.file
    spawn,'wc '+inp.file,a
    a=fix(a)
    inp.Nlayers=a(0)
  endelse
  message,/info,'Number of layers in '+inp.file+' file is: '+$
    strcompress(inp.Nlayers,/REM)
  ;
  printf,unit,inp.Nlayers
    openr,UnitTmp,inp.file,/GET_LUN
    for i=0, inp.Nlayers-1 do begin
      readf,unitTmp,stmp
      printf,unit,stmp
    endfor
    Free_Lun,unitTmp
    printf,unit,'xsh_mlayer_tmp.par'
    printf,unit,'xsh_mlayer_tmp.out'
    printf,unit,'6'
    free_lun,unit
endelse
;
END
;
;=======================================================================
;
PRO XSH_MLAYER_EVENT,event

;
; register the events
;
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

WIDGET_CONTROL, event.id, GET_UVALUE=eventuval

;
; register the events
;
CASE eventuval OF
	'FILELOAD': BEGIN
		ffile = Dialog_PickFile(title=$
		'Select XSh_MLayer input file...',/NOCONF)
		if strcompress(ffile,/rem) EQ '' then return
		version = 0
		restore,ffile,/VERBOSE
		if version NE xsh_mlayer_version() then $
		  itmp = Dialog_Message(dialog_parent=event.top, $
		  'Input file and current XSh_MLayer have different versions.')
		state.str.parameters = str_par
		END
	'FILEWRITE': BEGIN
		ffile = Dialog_PickFile(/WRITE,file='xsh_mlayer.inp')
		if strcompress(ffile,/rem) EQ '' then return
		version = xsh_mlayer_version()
		str_par = state.str.parameters
		command = 'save,version,str_par,'+$
		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
		tmp = execute(command)
		itmp = Dialog_Message(dialog_parent=event.top, $
			/INFO,'File '+ffile+' written to disk.')
		END
	'QUIT': BEGIN
		case sdep() of
		  'WINDOWS': command = 'del xsh_mlayer_tmp.*'
		  'UNIX': command = '/bin/rm -f  xsh_mlayer_tmp.*'
		  else:
		endcase
		message,/info,'Executing: '+command
		SPAWN,command
		WIDGET_CONTROL,event.top,/DESTROY
		Return
		END
	'SETDEF': BEGIN
		itmp = Dialog_Message(dialog_parent=event.top, $
			/Question,['This option initializes the',$
		'xsh_mlayer parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Do you really want that?'],title='xsh_mlayer')
		if itmp eq 'No' then goto,out
		tmp = xsh_defaults_utils('XSh_MLayer')
		state.str.parameters = tmp.parameters
		END
	'SETPAR': BEGIN
		inp = state.str.parameters
		size_inp = SIZE(inp)
		IF (size_inp(0) ne 1) THEN BEGIN
		  inp = xsh_defaults_utils('XSh_MLayer')
		ENDIF


		sep = sdep(/ds)
                helpcmd = "xdisplayfile1,'"+getenv('XSH_HOME')+$
                  sep+'doc'+sep+'xsh_mlayer.par'+"',group=event.top"
		Xscrmenu,inp,GROUP=group,ACTION=action,$
		  TITLES=state.str.titles, FLAGS=state.str.flags, $
		  /NOTYPE,/INTERP,WTITLE='XSh_MLayer input parameters',Ncol=2,$
		  HELP=helpcmd
		IF (action EQ 'DONT') THEN GoTo,out
		widget_control,/hourglass
		XSH_MLAYER_INP_WRITE,inp
		print,'############## Starting running MLAYER #################'
		command = 'mlayer < xsh_mlayer_tmp.inp' 
		xsh_run,command
		print,'############### MLAYER run ended #################'
		state.str.parameters = inp
		END
        'HELP': Xhelp,'xsh_mlayer',GROUP=event.top
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		ffile = findfile('xsh_mlayer_tmp.out')
		IF (ffile(0) EQ '') THEN BEGIN
		  message,/info,'File not found. '
		  itmp = Dialog_Message(dialog_parent=event.top, $
			/ERROR,['MLAYER data not found...',$ 
			'Set Parameters before...  '])
		  Goto,out
		ENDIF
		inp = state.str.parameters
		title='ML '+strcompress(inp.odd_material,/REM)+'('+ $
			strcompress(inp.odd_thickness,/rem)+' A):'+ $ 
			strcompress(inp.even_material,/REM)+'('+ $
                        strcompress(inp.even_thickness,/rem)+' A) '+ $
			strcompress(inp.Nlayers,/rem)+' pairs; '
		if (strcompress(inp.scan(0),/rem) eq '0') then begin
			xtitle = 'grazing angle !4 h !3 [deg]'
			title = title+'E = '+strcompress(inp.energy,/rem)+' eV'
		endif else begin
			xtitle = 'Energy [eV]'
			title=title+'!4h!3 = '+strcompress(inp.theta,/re)+' deg'
		endelse
		tmp = rascii('xsh_mlayer_tmp.out')
		if (strcompress(inp.scan(0),/REM) eq '1') then $
			tmp(0,*) = 12398.52/tmp(0,*)

		titles = [xtitle,'s reflectivity',$
		  'p reflectivity','average reflectivity','s phase shift', $
		  'p phase shift','(s electric field)^2',$
		  '(p electric field)^2']
		XPLOT,tmp,YCOL=2,COLTITLES=titles,XTITLE='-1',$
		  ytitle='-1',TITLE=title,GROUP=event.top,/YLOG
		END
  ENDCASE
out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
END
;
;==============================================================================
;
PRO XSh_MLayer, GROUP=group

if xregistered('XSh_MLayer') GT 0 then begin
  message,/info,'Only one copy of XSh_MLayer is allowed.'
  return
endif
;
; create the base widget
;
base=WIDGET_BASE(/COLUMN,TITLE='XSh_MLayer '+xsh_mlayer_version(),MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)
  wtmp = widget_button(wFile,VALUE='Load XSh_MLayer input file...', $
		UVALUE='FILELOAD')
  wtmp = widget_button(wFile,VALUE='Write XSh_MLayer input file...', $
		UVALUE='FILEWRITE')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Show Results',UVALUE='SHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='xsh_mlayer', UVALUE='HELP')
;

wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

wtmp = WIDGET_LABEL( BASE, FONT=font,VALUE='MLayer')
wtmp = WIDGET_LABEL( BASE, FONT=font,VALUE='    Multilayer Reflectivity   ')
wtmp = WIDGET_LABEL( BASE, FONT=font,VALUE='    (SHADOW utilities)   ')


str = xsh_defaults_utils('XSh_MLayer')
wids = {dummy:0L}
state = {str:str, wids:wids}

Widget_control,Widget_Info(base,/CHILD),set_uvalue=state,/NO_COPY
Widget_control,base,/REALIZE
XMANAGER,'XSh_MLayer',base,GROUP_LEADER=group,/No_Block
end
;
