;+
;
; FUNCTION nrbsupport,surf, grid=grid,p=p,q=q, intsurf=intsurf, bzr=bzr, mm=mm
;          sort=sort
;
; 
; This function returns the bezier patches from a surface (in an array
; of structures)
;
; Inputs: 
;	surf: 
;	     A mesh file
;	     Eventually it may take a NURBS surface, like the ones
;	     created by nrbMake*()
; 	P nurbs degree along  U parametric direction (only for file input)
;	Q nurbs degree along  V parametric direction (only for file input)
;	mm: Set this keyword for converting units from cm to mm
;	sort: Set this keyword for returning the patches sorted with
;	  respect to the distance to origin, in order to accelerate the
;	  finding of the intersection point. It just applies bzrpatch_ordering()
;
; Outputs:
;	intSurf: NURBS surface (structure of the interpolating grid)
;	bzr: BEZIER surface (obtained from NURBS refinement)
;
;-
FUNCTION nrbsupport,surf, grid=grid,p=p,q=q, intsurf=intsurf, bzr=bzr, $
mm=mm, sort=sort1

temp=surf

IF keyword_set(p) EQ 0 THEN p=3
IF keyword_set(q) EQ 0 THEN q=3

IF size(temp,/type) EQ 7 THEN BEGIN
    grid=nrbconvsurf(temp)
    knots=nrbgetknots(grid,p=p,q=q,uu=uu,vv=vv)
    nrb=nrbstruct(grid, knots.uknots,knots.vknots)
    temp=nrbinterpcoefs(nrb,uu,vv)
ENDIF

;manolo=temp
intsurf=temp

IF keyword_set(mm) THEN BEGIN
  scale=vecscale([10d,10d,10d])
  temp=nrbtransform(temp,scale)
ENDIF

;intsurf=temp

bzr=nrb2bzr(temp)
bzrpatch=bzrpatch(bzr)

IF Keyword_Set(sort1) THEN BEGIN
  bzrpatch=bzrsort(bzrpatch)
ENDIF

return, bzrpatch

END
