;
;=====================================================================
;
PRO xop_idlhelp, input, group=group, path=path1

;+
;
;       NAME:
;               XOP_IDLHELP
;       PURPOSE:
;               Spawns a predefined browser/viewer to view the IDL documentation.
;
;       CATEGORY:
;               Tools
;
;       CALLING SEQUENCE:
;               xop_idlhelp, input
;
; 	INPUTS:
;		input: file name (without path)
;	
; 	KEYWORD PARAMETERS
;		path: the file path (with trailing directory separator)
;		if path is not set, use the default IDL documentation directory
;
;	SIDE EFFECTS
;		None
;       
;       COMMON BLOCKS
;		Used for repeated calls.
;       	common xop_idlhelp1,application_pdf,application_html,application_txt
;	
;	AUTHOR: 
;		Roger J. Dejus dejus@aps.anl.gov
;		based on the XOP_HELP routine writtend by M. Sanchez del Rio srio@esrf.eu
; 
;	MODIFICATION HISTORY:
;               dejus@aps.anl.gov 2014-02-13 first release
;
;-
common xop_idlhelp1,application_pdf,application_html,application_txt
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,'XOP_IDLHELP: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif
;print,'XOP_IDLHELP: Trying to open: '+input

Widget_Control,/HourGlass
ds = SDep(/ds)

if n_elements(application_pdf) eq 0 then application_pdf = 'acroread'
if n_elements(application_html) eq 0 then application_html = 'firefox'
if n_elements(application_txt) eq 0 then application_txt = 'nedit'

; parse on file extension
nn = strparse(input,'.',list)
if nn GE 1 then begin
  case strlowcase(list[1]) of 
    'pdf': begin
           file = input
           path = xop_getenv('IDL_DIR')+ds+'help'+ds+'pdf'+ds
           application = application_pdf
           end
    'htm': begin
           file = input
           path = xop_getenv('IDL_DIR')+ds+'help'+ds+'online_help'+ds+'IDL'+ds
           application = application_html
           end
    'htlm': begin
           file = input
           path = xop_getenv('IDL_DIR')+ds+'help'+ds+'online_help'+ds+'IDL'+ds
           application = application_html
           end
    'txt': begin
           file = input
           path = xop_getenv('IDL_DIR')+ds+'help'+ds
           application = application_txt
           end
     else: begin 
           file = input
           path = xop_getenv('XOP_HOME')+ds
           application = application_txt
           end
  endcase
endif

; if path1 is definded then use it
if n_elements(path1) GT 0 then path = path1

; redefine application for certain systems
if sdep() eq 'WINDOWS' then application = 'start'
if sdep(/os) eq 'DARWIN' then application = 'open'

if sdep() eq 'WINDOWS' then  begin
  command = application+' /D '+dospath(path)+' '+file
  ; remove double separator windows doesn't like
  command = strsubstitute(command,'//','/')
endif else begin
  command = application+' '+path+file
endelse

if sdep() eq 'UNIX' then command=command+' &'

xedit,command,infotext='Command to open file: ',action=action,$
  text = ' ',Title='Open file', XSize=100, Dialog_Parent=group
if action EQ 'CANCEL' then return

message,/Info,'Executing: '+command
if sdep() eq 'UNIX' then spawn,command,/sh else spawn,command

nn = strparse(command,' ',list2)
if nn GE 1 then begin
  case strlowcase(list[1]) of 
    'pdf': application_pdf = list2[0]+' '
    'htm': application_html = list2[0]+' '
    'html': application_html = list2[0]+' '
    'txt': application_txt = list2[0]+' '
     else: 
  endcase
endif

end ; xop_idlhelp
