;
;=====================================================================
;
PRO xop_help,input,group=group, path=path1, text=text,  $
      tutorial=tutorial ; not used

;+
;
;       NAME:
;               XOP_HELP
;       PURPOSE:
;               Spawns a reader (pdf, html or txt) with a file
;
;       CATEGORY:
;               Tools
;
;       CALLING SEQUENCE:
;               xop_help,input
;
; 	INPUTS:
;		input: file name (without path)
;	
; 	KEYWORD PARAMETERS
;		path: the file path (ended with separator)
;                      if path is not set, use the standard doc 
;                      directory in XOP
;               text: a text to be displayed (default "Command to open file: ")
;
;	SIDE EFFECTS
;       
;       COMMON BLOCKS
;       common xop_help1,application_pdf,application_html,application_txt
;	
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
; 
;	MODIFICATION HISTORY:
;               srio@esrf.fr 2003-08-26 added tutorial keyword.
;               srio@esrf.eu 2008-01-31 rewritten parsing online_help
;               srio@esrf.eu 2013-05-24 avoid using online_help, doc
;               srio@esrf.eu 2014-03-26 added text kw.
;
;-
common xop_help1,application_pdf,application_html,application_txt
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,'XOP_HELP: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif
print,'XOP_HELP: Trying to open: '+input

Widget_Control,/HourGlass
ds = SDep(/ds)
file = '"'+xop_getenv('XOP_HOME')+ds+'doc'+ds+input+'"'
nn = strparse(input,'.',list)
help,nn,input
if n_elements(application_pdf) eq 0 then application_pdf = 'acroread'
if n_elements(application_html) eq 0 then application_html = 'firefox'
if n_elements(application_txt) eq 0 then application_txt = 'nedit'

if nn GE 1 then begin
  case strlowcase(list[1]) of 
    'pdf': begin
           file = input
           path = xop_getenv('XOP_HOME')+ds+'doc'+ds
           application = application_pdf
           end
    'htm': begin
           file = input
           path = xop_getenv('XOP_HOME')+ds+'doc'+ds+'WebHelp'+ds
           application = application_html
           end
    'htlm': begin
           file = input
           path = xop_getenv('XOP_HOME')+ds+'doc'+ds+'WebHelp'+ds
           application = application_html
           end
    'txt': begin
           file = input
           path = xop_getenv('XOP_HOME')+ds+'doc'+ds+'txt'+ds
           application = application_txt
           end
     else: begin 
           file = input
           path = xop_getenv('XOP_HOME')+ds
           application = application_txt
           end
  endcase
endif

; if path kw is uses, take it
if n_elements(path1) GT 0 then path = path1

if sdep() eq 'WINDOWS' then application = 'start'
if !version.os eq 'darwin' then application = 'open'

if sdep() eq 'WINDOWS' then  begin
  command = application+' /D '+dospath(path)+' '+file
  ; rm doublw separator, windows doesn't like
  command = strsubstitute(command,'//','/')
endif else begin
  command = application+' '+path+file
endelse

if !version.os_family EQ 'unix' then command=command+' &'

infotext = 'Command to open file: '
if keyword_set(text) then  infotext = text
xedit,command,infotext=infotext,action=action,$
  text = ' ',Title='Open file', XSize=100, Dialog_Parent=group
if action EQ 'CANCEL' then return

message,/Info,'Executing: '+command
if sdep() eq "UNIX" then spawn,command,/sh else spawn,command

nn = strparse(command,' ',list2)
if nn GE 1 then begin
  case strlowcase(list[1]) of 
    'pdf': application_pdf = list2[0]+' '
    'htm': application_html = list2[0]+' '
    'html': application_html = list2[0]+' '
    'txt': application_txt = list2[0]+' '
     else: 
  endcase
endif

end ; xop_help
