; $Id: xsurface1.pro,v 1.7 2008/03/06 14:10:56 srio Exp $

; Copyright (c) 1991-1993, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	XSURFACE1
;
; PURPOSE:
;	This routine provides a graphical interface to the SURFACE and
;	SHADE_SURFACE commands.  Different controls are provided to change 
;	the viewing angle and other plot parameters.  The command used to 
;	generate the resulting surface plot is shown in a text window.
;
; CATEGORY:
;	Widgets.
;
; CALLING SEQUENCE:
;	XSURFACE1, Data
;
; INPUT PARAMETERS:
;	Data:	The two-dimensional array to display as a wire-mesh or
;		shaded surface.
; OPTIONAL INPUT:
;	x: array with x values.
;	y: array with y values.
;
; KEYWORD PARAMETERS:
;	GROUP:	The widget ID of the widget that calls XSURFACE.  When this
;		keyword is specified, the death of the caller results in the
;		death of XSURFACE.
;
;               WINDOW_SIZE = a 2-dim vector containing the width and
;               height of the graphical window (in pixels).
;               [XYZ]TITLE = graph titles.
;               WTITLE = title for the main window.
;	
;
; SIDE EFFECTS:
;	The XMANAGER is initiated if it is not already running.
;
; RESTRICTIONS:
;	XSURFACE does not accept any of the keywords that the IDL command 
;	SURFACE does.
;
; PROCEDURE:
;	Create and register the widget with the XMANAGER and then exit.
;
; MODIFICATION HISTORY:
;	Created from a template written by: Steve Richards, January, 1991.
;
;	Modified by M. Sanchez del Rio (ESRF) 95/01/16 to include print
;	and set_titles buttons, and allow X and Y arrays as input as
;	well as {xyz}title, wtitle (widget title), and window_size  keywords.
;
;	97-04-04 srio@esrf.fr fix a bug when printing in tha case that 
;		xsurface1 has been called with only a single argument.
;		Renames routines -> routines1 and common block to avoid
;		conflict when using both the original xsurface and this
;		xsurface1 on the same idl session.
;	98-12-03 srio@esrf.fr adds SHOW3 button.
;	2003  srio@esrf.fr changes for xop2.1: added export and read 
;		functions. Added character size control.
;	2008/01/15 srio@esrf.eu adapts EXPORT options to write
;               z[n,m] with also x[n,m] and y[n,m]
;	2008/03/06 srio@esrf.eu adds more EXPORT options.
;-

;------------------------------------------------------------------------------
;	procedure XSurface_Draw1
;------------------------------------------------------------------------------

PRO XSurface_Draw1

COMMON orientation1, zrot, thedata, xrot, skirt, shade, axes, thedraw, $
		xmargin, ymargin, upper, commandid, $
		titles, charsize

WSET, thedraw

if not(keyword_set(thedata.x)) then begin
  x = lindgen( n_elements(thedata.z(*,0)))
  y = lindgen(  n_elements(thedata.z(0,*)))
endif else begin
  x = thedata.x
  y = thedata.y
endelse
data = {z:thedata.z, x:x, y:y}

;IF(shade EQ 0) THEN BEGIN
;  IF(skirt EQ 0) THEN $
;    SURFACE, thedata.z, x, y, $
;		XSTYLE = axes, $
;		YSTYLE = axes, $
;		ZSTYLE = axes, $
;		UPPER_ONLY = upper, $
;		XMARGIN = xmargin, $
;		YMARGIN = ymargin, $
;		AZ = zrot, $
;		AX = xrot $
;  ELSE SURFACE, thedata.z, x, y, $
;		XSTYLE = axes, $
;		YSTYLE = axes, $
;		ZSTYLE = axes, $
;		UPPER_ONLY = upper, $
;		XMARGIN = xmargin, $
;		YMARGIN = ymargin, $
;		AZ = zrot, $
;		AX = xrot, $
;		SKIRT = MIN(thedata.z)
;ENDIF ELSE BEGIN
;  IF(skirt EQ 0) THEN $
;    SHADE_SURF, thedata.z, x, y, $
;		XSTYLE = axes, $
;		YSTYLE = axes, $
;		ZSTYLE = axes, $
;		UPPER_ONLY = upper, $
;		XMARGIN = xmargin, $
;		YMARGIN = ymargin, $
;		AZ = zrot, $
;		AX = xrot $
;    ELSE SHADE_SURF, thedata.z, x, y, $
;		XSTYLE = axes, $
;		YSTYLE = axes, $
;		ZSTYLE = axes, $
;		UPPER_ONLY = upper, $
;		XMARGIN = xmargin, $
;		YMARGIN = ymargin, $
;		AZ = zrot, $
;		AX = xrot, $
;		SKIRT = MIN(thedata.z)
;ENDELSE

IF(shade EQ 0) THEN command = "SURFACE, data.z, data.x, data.y" $
ELSE command = "SHADE_SURF, data.z, data.x, data.y"
IF(xrot NE 30.0) THEN command = command + STRING(xrot, $
					FORMAT = '(", AX = ",I3.3)')
IF(zrot NE 30.0) THEN command = command + STRING(zrot, $
					FORMAT = '(", AZ = ",I3.3)')
IF(skirt NE 0) THEN command = command + ", /SKIRT"
IF(xmargin(0) NE 10.0) THEN $
	command = command + STRING(xmargin, $
	FORMAT = '(", XMARGIN = [",F4.1,", ",F4.1,"]")')
IF(ymargin(0) NE 4.0) THEN $
	command = command + STRING(ymargin, $
	FORMAT = '(", YMARGIN = [",F4.1,", ",F4.1,"]")')
IF(upper NE 0) THEN command = command + ", /UPPER_ONLY"
IF(axes NE 0) THEN command = command + $
	", XSTYLE = 4, YSTYLE = 4, ZSTYLE = 4"

if  (titles.x NE '') then command = command + ", xtitle='"+titles.x+"'"
if  (titles.y NE '') then command = command + ", ytitle='"+titles.y+"'"
if  (titles.z NE '') then command = command + ", ztitle='"+titles.z+"'"

IF charsize NE 1.0 THEN $
  command = command + ", Charsize="+String(charsize,Format='(F5.2)')

WIDGET_CONTROL, commandid, SET_VALUE = command

tmp = execute(command)

END


;------------------------------------------------------------------------------
;	procedure XSurface_ev1
;------------------------------------------------------------------------------

PRO XSurface_ev1, event

COMMON orientation1, zrot, thedata, xrot, skirt, shade, axes, thedraw, $
		xmargin, ymargin, upper, commandid, $
		titles, charsize

catch, error_status
if error_status ne 0 then begin
   ; error is managed by the caller
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,$
       'XSURFACE1: error caught: '+!error_state.msg)
   catch, /cancel
   ;on_error,2
   RETURN
endif


WIDGET_CONTROL, event.id, GET_UVALUE = eventval		;find the user value
							;of the widget where
							;the event occured
CASE eventval OF

  "       0": BEGIN
		zrot = (zrot + 15) mod 360
		IF(zrot LT 0) THEN zrot = 360 + zrot
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "       1": BEGIN
		zrot = (zrot - 15) mod 360
		IF(zrot LT 0) THEN zrot = 360 + zrot
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "       2": BEGIN
		xrot = (xrot - 15) mod 360
		IF(xrot LT 0) THEN xrot = 360 + xrot
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "       3": BEGIN
		xrot = (xrot + 15) mod 360
		IF(xrot LT 0) THEN xrot = 360 + xrot
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "       4": BEGIN	;shrink
		xmargin = xmargin * 1.2
		ymargin = ymargin * 1.2
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "       5": BEGIN	;grow
		xmargin = xmargin * 0.8
		ymargin = ymargin * 0.8
		XSurface_Draw1
		WIDGET_CONTROL, event.id, SET_BUTTON = 0
	      END

  "SKIRTON": IF(event.select EQ 1) THEN BEGIN
		skirt = 1
		XSurface_Draw1
	     ENDIF

  "SKIRTOFF":  IF(event.select EQ 1) THEN BEGIN
		skirt = 0
		XSurface_Draw1
	      ENDIF

  "SHADEOFF":  IF(event.select EQ 1) THEN BEGIN
		shade = 0
		XSurface_Draw1
	      ENDIF

  "SHADEON":  IF(event.select EQ 1) THEN BEGIN
		shade = 1
		XSurface_Draw1
	      ENDIF

  "AXESOFF":  IF(event.select EQ 1) THEN BEGIN
		AXES = 4
		XSurface_Draw1
	      ENDIF

  "AXESON":  IF(event.select EQ 1) THEN BEGIN
		AXES = 0
		XSurface_Draw1
	      ENDIF

  "UPPERON": IF(event.select EQ 1) THEN BEGIN
		upper = 0
		XSurface_Draw1
	      ENDIF

  "UPPEROFF": IF(event.select EQ 1) THEN BEGIN
		upper = 1
		XSurface_Draw1
	      ENDIF

  "XLOADCT": XLoadct, GROUP = event.top

  "XPALETTE": XPalette, GROUP = event.top

  "XMANTOOL": XMTool, GROUP = event.top

  "EXIT": WIDGET_CONTROL, event.top, /DESTROY

  "PRINT": begin
	widget_control, commandid, get_value=command
	xprint,b=command,data=thedata,Group=event.top
	end

  "EXPORT": begin
        ni = n_elements(thedata.z[*,0])
        nj = n_elements(thedata.z[0,*])
	if not(keyword_set(thedata.x)) then begin
	  x = lindgen( ni )
	  y = lindgen( nj )
	endif else begin
          IF N_Elements(thedata.x) EQ N_Elements(thedata.z) THEN BEGIN
            sni = StrCompress(ni,/Rem)
            snj = StrCompress(ni,/Rem)
	    x = (thedata.x)[0:ni-1]
	    y = (thedata.y)[lindgen(nj)*ni]
          ENDIF ELSE BEGIN
	    x = (thedata.x)
	    y = (thedata.y)
          ENDELSE
	endelse
	data = {z:thedata.z, x:x, y:y}
        Widget_Control,event.id,Get_Value=vv,/Hourglass
        CASE StrUpCase(vv) OF
          'SHOW3': BEGIN
	      command = "Show3, data.z, data.x, data.y"
	      XWindow,Buffer=command,data=data,Group=event.top, $
	        WTitle='Show3 window', Edit=2
              END
          'ICONTOUR': iContour, data.z, data.x, data.y
          'ISURFACE': iSurface, data.z, data.x, data.y
          else:
        ENDCASE
	end
  "TITLES": begin
	tmptitles = titles
	Xscrmenu,tmptitles,/notype,titles=['x title','y title','z title'], $
	action=action
	if action EQ 'DO' then begin
	  titles = tmptitles
	  XSurface_Draw1
	endif
	end
  "CHARSIZE": begin
	Widget_Control,event.id, Get_Value=cs
	charsize=cs
	XSurface_Draw1
	end
  "XWINDOW": begin
	if not(keyword_set(thedata.x)) then begin
	  x = lindgen( n_elements(thedata.z(*,0)))
	  y = lindgen(  n_elements(thedata.z(0,*)))
	endif else begin
	  x = thedata.x
	  y = thedata.y
	endelse
	data = {z:thedata.z, x:x, y:y}

	;command = "Show3, data.z, data.x, data.y"
	WIDGET_CONTROL, commandid, GET_VALUE = command
	command=[';',command]
	XWindow,Buffer=command,data=data,Group=event.top, $
	  WTitle='Exported graph', Edit=2
	end

  "FILEXYZ": begin
;	if not(keyword_set(thedata.x)) then begin
;	  x = lindgen( n_elements(thedata.z(*,0)))
;	  y = lindgen(  n_elements(thedata.z(0,*)))
;	endif else begin
;	  x = thedata.x
;	  y = thedata.y
;	endelse

        ni = n_elements(thedata.z[*,0])
        nj = n_elements(thedata.z[0,*])
	if not(keyword_set(thedata.x)) then begin
	  x = lindgen( ni )
	  y = lindgen( nj )
	endif else begin
          IF N_Elements(thedata.x) EQ N_Elements(thedata.z) THEN BEGIN
            sni = StrCompress(ni,/Rem)
            snj = StrCompress(ni,/Rem)
            itmp = Dialog_Message(Dialog_Parent=event.top, $
              ['The number of elements in the x and y arrays',$
               'is the same as in z. ','',$
               'This file format cannot write the full x and y ',$
               'arrays, but only a part, which is supposed to be',$
               'replicated. i.e.:','',$
               'Original data: z['+sni+','+snj+'], x['+sni+','+snj+'], y['+sni+','+snj+']',$
               'Saved data: z['+sni+','+snj+'], x['+sni+'], y['+snj+']' ] ,/Cancel)
            IF itmp EQ 'Cancel' THEN RETURN
	    x = (thedata.x)[0:ni-1]
	    y = (thedata.y)[lindgen(nj)*ni]
          ENDIF ELSE BEGIN
	    x = (thedata.x)
	    y = (thedata.y)
          ENDELSE
	endelse
	data = {z:thedata.z, x:x, y:y}
	BACKFILE: 
	file = Dialog_PickFile(/Write,Dialog_Parent=event.top, $
	  File='xsurface1.dat')
	IF file EQ '' THEN RETURN
        if checkfile(file) EQ 1 then begin
          itmp = Dialog_Message(Dialog_Parent=event.top,$
            ['File exists: '+file,'Overwrite it?'], /Question,/Cancel)
          if itmp EQ 'Cancel' then RETURN
          if itmp EQ 'No' then GoTo,backfile
        endif
	Openw,unit,file,/Get_Lun
	printf,unit,';file written by xop/xsurface1 on '+SysTime()
	printf,unit,'; contains x,y,z'
        IF N_Elements(data.x) EQ N_Elements(data.z) THEN BEGIN
	  FOR j=0,N_Elements(data.z[0,*])-1 DO FOR i=0,N_Elements(data.z[*,0])-1 DO $
		printf,unit,data.x[i,j],data.y[i,j],data.z[i,j]
        ENDIF ELSE BEGIN
	  FOR j=0,N_Elements(y)-1 DO FOR i=0,N_Elements(x)-1 DO $
		printf,unit,data.x[i],data.y[j],data.z[i,j]
        ENDELSE
        itmp = Dialog_Message(/Info,Dialog_Parent=event.top,$
            ['File written to disk: '+file, $
	     'It can be opened with xsurface1 or alternatively ',$
	     'with xplot and viewed with MESH using label column 2'])
	free_lun,unit
	end


  "IFILEXYZ": begin
	file = Dialog_PickFile(/Read,Dialog_Parent=event.top)
	IF file EQ '' THEN RETURN
	tmp = rascii(file)
	coor2matr,tmp,z,x,y,/sort
	thedata = {z:z, x:x, y:y}
	XSurface_Draw1
	end

  "FILEZ": begin
        ni = n_elements(thedata.z[*,0])
        nj = n_elements(thedata.z[0,*])
	if not(keyword_set(thedata.x)) then begin
	  x = lindgen( ni )
	  y = lindgen( nj )
	endif else begin
          IF N_Elements(thedata.x) EQ N_Elements(thedata.z) THEN BEGIN
            sni = StrCompress(ni,/Rem)
            snj = StrCompress(ni,/Rem)
            itmp = Dialog_Message(Dialog_Parent=event.top, $
              ['The number of elements in the x and y arrays',$
               'is the same as in z. ','',$
               'This file format cannot write the full x and y ',$
               'arrays, but only a part, which is supposed to be',$
               'replicated. i.e.:','',$
               'Original data: z['+sni+','+snj+'], x['+sni+','+snj+'], y['+sni+','+snj+']',$
               'Saved data: z['+sni+','+snj+'], x['+sni+'], y['+snj+']' ] ,/Cancel)
            IF itmp EQ 'Cancel' THEN RETURN
	    x = (thedata.x)[0:ni-1]
	    y = (thedata.y)[lindgen(nj)*ni]
          ENDIF ELSE BEGIN
	    x = (thedata.x)
	    y = (thedata.y)
          ENDELSE
	endelse
	data = {z:thedata.z, x:x, y:y}
	BACKFILE2: 
	file = Dialog_PickFile(/Write,Dialog_Parent=event.top, $
	  File='xsurface1.dat')
	IF file EQ '' THEN RETURN
        if checkfile(file) EQ 1 then begin
          itmp = Dialog_Message(Dialog_Parent=event.top,$
            ['File exists: '+file,'Overwrite it?'], /Question,/Cancel)
          if itmp EQ 'Cancel' then RETURN
          if itmp EQ 'No' then GoTo,backfile2
        endif
	Openw,unit,file,/Get_Lun
	printf,unit,';file written by xop/xsurface1 on '+SysTime()
	printf,unit,'; contains: '
	printf,unit,'; contains Nx,Ny
	printf,unit,';          x[.]'
	printf,unit,';          y[.]'
	printf,unit,';          z[i,.] (i=1,Nx)'
	printf,unit,N_Elements(x),N_Elements(y)
	printf,unit,x
	printf,unit,y
	for i=0,N_Elements(x)-1 do printf,Unit,thedata.z(i,*)
	free_lun,unit
        itmp = Dialog_Message(/Info,Dialog_Parent=event.top,$
            ['File written to disk: '+file, $
	     'It can be opened with xsurface1 '])
	end


  "MESH": begin
        ni = n_elements(thedata.z[*,0])
        nj = n_elements(thedata.z[0,*])
	if not(keyword_set(thedata.x)) then begin
	  x = lindgen( ni )
	  y = lindgen( nj )
	endif else begin
          IF N_Elements(thedata.x) EQ N_Elements(thedata.z) THEN BEGIN
            sni = StrCompress(ni,/Rem)
            snj = StrCompress(ni,/Rem)
            itmp = Dialog_Message(Dialog_Parent=event.top, $
              ['The number of elements in the x and y arrays',$
               'is the same as in z. ','',$
               'This file format cannot write the full x and y ',$
               'arrays, but only a part, which is supposed to be',$
               'replicated. i.e.:','',$
               'Original data: z['+sni+','+snj+'], x['+sni+','+snj+'], y['+sni+','+snj+']',$
               'Saved data: z['+sni+','+snj+'], x['+sni+'], y['+snj+']' ] ,/Cancel)
            IF itmp EQ 'Cancel' THEN RETURN
	    x = (thedata.x)[0:ni-1]
	    y = (thedata.y)[lindgen(nj)*ni]
          ENDIF ELSE BEGIN
	    x = (thedata.x)
	    y = (thedata.y)
          ENDELSE
	endelse
	data = {z:thedata.z, x:x, y:y}
        data2 = FltArr(3,N_Elements(data.z))
        kk=0L
        FOR j=0,N_Elements(y)-1 DO BEGIN
          FOR i=0,N_Elements(x)-1 DO BEGIN
            data2[*,kk]=[x[i],y[j],(data.z)[i,j]]
            kk=kk+1
          ENDFOR
        ENDFOR
        xplot,parent=p,data2,wtitle='Exported mesh'
        xplot_mesh,p,Flag=1,Kind=0,Col=-2, Interactive=0
        xplot_refresh,p
	end

  "IFILEZ": begin
	file = Dialog_PickFile(/Read,Dialog_Parent=event.top)
	IF file EQ '' THEN RETURN
	stmp = ''
	OpenR,unit,file,/Get_Lun
	ncommentlines=0
	WHILE NOT(eof(unit)) DO BEGIN
	  readf,unit,stmp
	  IF StrMid(StrCompress(stmp,/Rem),0,1) EQ ';' THEN ncommentlines=ncommentlines+1 $
		ELSE GoTo,CONT3
	ENDWHILE
	CONT3:
	Free_Lun,unit
	OpenR,unit,file,/Get_Lun
	IF ncommentlines GT 0 THEN FOR i=0,ncommentlines-1 DO readf,unit,stmp

	readf,unit,nx,ny
	x = fltArr(nx)
	y = fltArr(ny)
	z = fltArr(nx,ny)
	readf,unit,x
	readf,unit,y
	for i=0,nx-1 do begin
	  tmp = fltarr(ny)
	  readf,Unit,tmp
	  z[i,*]=tmp
	endfor
	Free_Lun,unit
	thedata = {z:z, x:x, y:y}
	XSurface_Draw1
	end
  ELSE:; MESSAGE, "Event User Value Not Found"

ENDCASE

END ;============= end of XSurface event handling routine task =============



;------------------------------------------------------------------------------
;	procedure XSurface1
;------------------------------------------------------------------------------

PRO XSurface1, DATA, DATAX, DATAY, GROUP = GROUP, $
  wtitle=wtitle, xtitle=xtitle, ytitle=ytitle, ztitle=ztitle, $
  WINDOW_SIZE=w_size

COMMON orientation1, zrot, thedata, xrot, skirt, shade, axes, thedraw, $
		xmargin, ymargin, upper, commandid, $
		titles, charsize

IF(XRegistered("XSurface")) THEN RETURN			;only one instance of
							;the XSurface widget
							;is allowed.  If it is
							;already managed, do
							;nothing and return

if not(keyword_set(wtitle)) then wtitle='XSurface1'
if not(keyword_set(xtitle)) then xtitle=''
if not(keyword_set(ytitle)) then ytitle=''
if not(keyword_set(ztitle)) then ztitle=''
titles = { x:xtitle, y:ytitle, z:ztitle }
if n_elements(w_size) lt 2 then begin     ; default window size
  device, GET_SCREEN = w_size
  w_size = (w_size(0) * [5,4]) /9
endif


thesize = SIZE(DATA)
zrot = 30.
xrot = 30.
skirt = 0
shade = 0
axes = 0
xmargin = [10.0, 3.0]
ymargin = [4.0, 2.0]
upper = 0
commandid = 0L

XSurfacebase = WIDGET_BASE(TITLE = wtitle, $
		/COLUMN)

XPdMenu, [	'"Quit"				EXIT',		$
		'"Print"			PRINT',		$
		'"Set Titles"			TITLES',	$
		'"Import"	{',				$
				'"File XYZ"	IFILEXYZ',	$
				'"File X[i],Y[j],Z[i,j]" IFILEZ',	$
				'}',$				$
		'"Export"	{',				$
				'"SHOW3"	EXPORT',	$
				'"XWINDOW"	XWINDOW',	$
				'"icontour" EXPORT',	$
				'"isurface" EXPORT',	$
				'"xplot/mesh" MESH',	$
				'"File XYZ"	FILEXYZ',	$
				'"File X[i],Y[j],Z[i,j]" FILEZ',	$
				'}'],				$
	 XSurfacebase

thebase = WIDGET_BASE(XSurfacebase, /ROW)

;ver	= widget_info(/version)
;case ver.style OF
;'OPEN LOOK': BEGIN
;	  XSurfacepalette = WIDGET_BASE(thebase, $
;				/COLUMN, $
;				/FRAME, $
;				/EXCLUSIVE)
;	END
;ELSE:	    BEGIN
	  XSurfacepalette = WIDGET_BASE(thebase, $
				/COLUMN, $
				/FRAME)
;	END
;ENDCASE

controls = [							$
		[						$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 248B, 255B, 063B, 000B],			$
		[128B, 007B, 000B, 224B, 001B],			$
		[112B, 000B, 000B, 000B, 014B],			$
		[136B, 000B, 016B, 000B, 016B],			$
		[052B, 000B, 048B, 000B, 056B],			$
		[172B, 000B, 080B, 000B, 032B],			$
		[124B, 000B, 144B, 000B, 040B],			$
		[164B, 007B, 016B, 001B, 048B],			$
		[012B, 248B, 031B, 062B, 056B],			$
		[036B, 000B, 000B, 228B, 033B],			$
		[004B, 000B, 000B, 008B, 062B],			$
		[012B, 000B, 000B, 016B, 048B],			$
		[036B, 000B, 000B, 016B, 032B],			$
		[008B, 000B, 000B, 008B, 000B],			$
		[112B, 000B, 000B, 004B, 000B],			$
		[128B, 007B, 000B, 002B, 000B],			$
		[000B, 248B, 031B, 001B, 000B],			$
		[000B, 000B, 144B, 000B, 000B],			$
		[000B, 000B, 080B, 000B, 000B],			$
		[000B, 000B, 048B, 000B, 000B],			$
		[000B, 000B, 016B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B]			$
		],						$
;		dnz.bmdef
		[						$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 252B, 255B, 031B, 000B],			$
		[128B, 007B, 000B, 224B, 001B],			$
		[112B, 000B, 000B, 000B, 014B],			$
		[008B, 000B, 008B, 000B, 017B],			$
		[028B, 000B, 012B, 000B, 044B],			$
		[004B, 000B, 010B, 000B, 053B],			$
		[020B, 000B, 009B, 000B, 062B],			$
		[012B, 128B, 008B, 224B, 037B],			$
		[028B, 124B, 248B, 031B, 048B],			$
		[132B, 039B, 000B, 000B, 036B],			$
		[124B, 016B, 000B, 000B, 032B],			$
		[012B, 008B, 000B, 000B, 048B],			$
		[004B, 008B, 000B, 000B, 036B],			$
		[000B, 016B, 000B, 000B, 016B],			$
		[000B, 032B, 000B, 000B, 014B],			$
		[000B, 064B, 000B, 224B, 001B],			$
		[000B, 128B, 248B, 031B, 000B],			$
		[000B, 000B, 009B, 000B, 000B],			$
		[000B, 000B, 010B, 000B, 000B],			$
		[000B, 000B, 012B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B]			$
		],						$
		;upz.bm
		[						$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 128B, 255B, 001B, 000B],			$
		[000B, 064B, 169B, 002B, 000B],			$
		[000B, 160B, 254B, 007B, 000B],			$
		[000B, 160B, 068B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 008B, 016B, 000B, 000B],			$
		[000B, 008B, 016B, 000B, 000B],			$
		[000B, 008B, 144B, 001B, 000B],			$
		[000B, 008B, 112B, 006B, 000B],			$
		[000B, 008B, 016B, 008B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 006B, 096B, 000B],			$
		[000B, 008B, 001B, 128B, 000B],			$
		[000B, 136B, 000B, 000B, 001B],			$
		[000B, 200B, 015B, 240B, 003B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 016B, 004B, 008B, 000B],			$
		[000B, 016B, 004B, 008B, 000B],			$
		[000B, 016B, 005B, 008B, 000B],			$
		[000B, 080B, 004B, 008B, 000B],			$
		[000B, 032B, 147B, 004B, 000B],			$
		[000B, 160B, 042B, 005B, 000B],			$
		[000B, 064B, 149B, 002B, 000B],			$
		[000B, 128B, 255B, 001B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B]			$
		],						$
		;dnx.bm
		[						$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 128B, 255B, 001B, 000B],			$
		[000B, 064B, 149B, 002B, 000B],			$
		[000B, 160B, 042B, 005B, 000B],			$
		[000B, 032B, 147B, 004B, 000B],			$
		[000B, 080B, 004B, 008B, 000B],			$
		[000B, 016B, 005B, 008B, 000B],			$
		[000B, 016B, 004B, 008B, 000B],			$
		[000B, 016B, 004B, 008B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 200B, 015B, 240B, 003B],			$
		[000B, 136B, 000B, 000B, 001B],			$
		[000B, 008B, 001B, 128B, 000B],			$
		[000B, 008B, 006B, 096B, 000B],			$
		[000B, 008B, 008B, 016B, 000B],			$
		[000B, 008B, 016B, 008B, 000B],			$
		[000B, 008B, 112B, 006B, 000B],			$
		[000B, 008B, 144B, 001B, 000B],			$
		[000B, 008B, 016B, 000B, 000B],			$
		[000B, 008B, 016B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 016B, 032B, 000B, 000B],			$
		[000B, 160B, 068B, 000B, 000B],			$
		[000B, 160B, 254B, 007B, 000B],			$
		[000B, 064B, 169B, 002B, 000B],			$
		[000B, 128B, 255B, 001B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B]			$
		],						$
		;shrink.bm
		[						$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 073B, 000B, 000B],			$
		[000B, 000B, 042B, 000B, 000B],			$
		[000B, 000B, 028B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[128B, 255B, 255B, 255B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[132B, 000B, 000B, 000B, 033B],			$
		[136B, 000B, 000B, 000B, 017B],			$
		[144B, 000B, 000B, 000B, 009B],			$
		[191B, 000B, 000B, 000B, 253B],			$
		[144B, 000B, 000B, 000B, 009B],			$
		[136B, 000B, 000B, 000B, 017B],			$
		[132B, 000B, 000B, 000B, 033B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 000B, 000B, 000B, 001B],			$
		[128B, 255B, 255B, 255B, 001B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 028B, 000B, 000B],			$
		[000B, 000B, 042B, 000B, 000B],			$
		[000B, 000B, 073B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B],			$
		[000B, 000B, 008B, 000B, 000B]			$
		],						$
		;grow.bm
		[						$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[248B, 255B, 255B, 255B, 031B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 028B, 000B, 016B],			$
		[008B, 000B, 042B, 000B, 016B],			$
		[008B, 000B, 073B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 008B, 000B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 001B, 000B, 000B, 016B],			$
		[136B, 000B, 000B, 128B, 016B],			$
		[072B, 000B, 000B, 000B, 017B],			$
		[232B, 063B, 000B, 000B, 018B],			$
		[072B, 000B, 000B, 252B, 023B],			$
		[136B, 000B, 000B, 000B, 018B],			$
		[008B, 001B, 000B, 000B, 017B],			$
		[008B, 000B, 000B, 128B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[008B, 000B, 016B, 000B, 016B],			$
		[008B, 000B, 016B, 000B, 016B],			$
		[008B, 000B, 016B, 000B, 016B],			$
		[008B, 000B, 016B, 000B, 016B],			$
		[008B, 000B, 146B, 000B, 016B],			$
		[008B, 000B, 084B, 000B, 016B],			$
		[008B, 000B, 056B, 000B, 016B],			$
		[008B, 000B, 016B, 000B, 016B],			$
		[008B, 000B, 000B, 000B, 016B],			$
		[248B, 255B, 255B, 255B, 031B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B],			$
		[000B, 000B, 000B, 000B, 000B]			$
		]						$
	   ]

FOR i = 0,N_ELEMENTS(controls(0,0,*))-1 DO $
  toss = WIDGET_BUTTON(XSurfacepalette, $
		VALUE = controls(*,*,i), $
		UVALUE = STRING(i))

XSurfacedisplay = WIDGET_DRAW(thebase, $
		XSIZE = w_size(0), $ ;375, $
		YSIZE = w_size(1), $ ;300, $
		RETAIN = 2)

XSurfacecontrols = WIDGET_BASE(XSurfacebase, $
		/ROW)

skirtbase = WIDGET_BASE(XSurfacecontrols, $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME)

skirtoff = WIDGET_BUTTON(skirtbase, $
		VALUE = "No Skirt", $
		UVALUE = "SKIRTOFF")

skirton = WIDGET_BUTTON(skirtbase, $
		VALUE = "Skirt", $
		UVALUE = "SKIRTON")

shadebase = WIDGET_BASE(XSurfacecontrols, $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME)

shadeoff = WIDGET_BUTTON(shadebase, $
		VALUE = "Wire Frame", $
		UVALUE = "SHADEOFF")

shadeon = WIDGET_BUTTON(shadebase, $
		VALUE = "Shaded Surface", $
		UVALUE = "SHADEON")


axesbase = WIDGET_BASE(XSurfacecontrols, $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME)

axeson = WIDGET_BUTTON(axesbase, $
		VALUE = "Show Axes", $
		UVALUE = "AXESON")

axesoff = WIDGET_BUTTON(axesbase, $
		VALUE = "Hide Axes", $
		UVALUE = "AXESOFF")

upperbase = WIDGET_BASE(XSurfacecontrols, $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME)

upperon = WIDGET_BUTTON(upperbase, $
		VALUE = "Show Top and Bottom", $
		UVALUE = "UPPERON")

upperoff = WIDGET_BUTTON(upperbase, $
		VALUE = "Only Show Top", $
		UVALUE = "UPPEROFF")

wcharsizebase = WIDGET_BASE(XSurfacecontrols, $
		/COLUMN, $
		/FRAME)
charsize=1.0
wcharsize = CW_FSlider(wcharsizebase,Format='(F5.2)',Min=0.0, Max=5.0, $
  Value=charsize, Title='Character Size', UVALUE='CHARSIZE', /Edit)

commandbase = WIDGET_BASE(XSurfacebase, $
		/FRAME, $
		/COLUMN)

commandlabel = WIDGET_LABEL(commandbase, $
		VALUE = "IDL Commmand To Produce Above Output:")

;case ver.style of
;'OPEN LOOK':  commandid = WIDGET_LABEL(commandbase, VALUE = $
;	"SURFACE, data.z, data.x, data.y")
;ELSE:	      
wtmp = Widget_Base(commandbase,/Column)
commandid = WIDGET_TEXT(wtmp, $
				VALUE = "SURFACE, data.z, data.x, data.y", $
				xsize=100, /SCROLL, YSIZE = 1 )
;ENDCASE

WIDGET_CONTROL, XSurfacebase, /REALIZE			;create the widgets
							;that is defined

WIDGET_CONTROL, skirtoff, /SET_BUTTON
WIDGET_CONTROL, shadeoff, /SET_BUTTON
WIDGET_CONTROL, axeson, /SET_BUTTON
WIDGET_CONTROL, upperon, /SET_BUTTON
WIDGET_CONTROL, XSurfacedisplay, GET_VALUE = temp & thedraw = temp

IF(N_PARAMS() eq 3) THEN BEGIN
	thedata = {z:DATA, x:DATAx, y:DATAy}
	XSurface_Draw1
ENDIF ELSE IF(N_PARAMS() gt 0) THEN BEGIN
	thedata = { z:DATA, x:lindgen(n_elements(data(*,0))), $
		y:lindgen(n_elements(data(0,*)))}
	;thedata = DATA
	XSurface_Draw1
END

XManager, "XSurface1", XSurfacebase, $			;register the widgets
		EVENT_HANDLER = "XSurface_ev1", $	;with the XManager
		GROUP_LEADER = GROUP,/NO_BLOCK

END ;================ end of XSurface background task =====================



