;
;=========================================================================
;

;
; XPLOT_FINDPEAKS: interface for peak search application
;
; For internal use of XPLOT and XPLOT2D
;


FUNCTION xplot_findpeaks_getindices,id,Dialog_Parent=dialog_parent
;
FORWARD_FUNCTION xplot_text, xplot2d_getimage
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,$
    'XPLOT_FINDPEAKS_GETINDICES: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   RETURN,[-1]
endif
;
Widget_Control, id, get_UValue=state ;, /No_Copy
Widget_Control,state.wids.table,Get_Value=txt
nTxt=N_Elements(txt)

igood = LonArr(Ntxt)-100
Widget_Control,state.wids.xplot,Get_UValue=xplotstate
IF xplotstate.nd EQ 2 THEN BEGIN
  img = xplot2d_getimage(xplotstate.wids.main)
  ss = size(img)
ENDIF ELSE ss=[0]

FOR i=0L,Ntxt-1 DO BEGIN
 line = txt[i]
 bline = byte(strtrim(line,1))
 ;if Strparse(' .+-0123456789 ',string(bline(0))) eq 0 then begin
 IF Strparse(' .+-0123456789 ',string(bline(0))) EQ 1 THEN BEGIN
    tmp=StrParse(line,' ',list)
    CASE tmp OF 
      0: igood[i]=Long(list[0]) ; single number (edited 1D)
      1: BEGIN
         igood[i]=Long(list[0]) ; two pixels (edited 2D)
         IF ss[0] EQ 2 THEN igood[i]=ss[2]*Long(list[1])+Long(list[0])
         END
       else: igood[i]=Long(list[0]) ; unedired 1D+2D
    ENDCASE
 ENDIF
ENDFOR
itmp = where(igood NE -100)
IF itmp[0] EQ -1 THEN BEGIN
  ;tmp = Dialog_Message(/Error,'No peaks found',Dialog_Parent=dialog_parent)
  igood=[-1]
ENDIF ELSE BEGIN
  igood = igood[itmp]
ENDELSE
RETURN,igood
END
;
;=========================================================================
;
;
PRO xplot_findpeaks_rightclick,id,xcursor,ycursor
Widget_Control, id, get_UValue=state ;, /No_Copy
Widget_Control,state.wids.rightclick,Get_Value=val
IF Fix(val) EQ 0 THEN RETURN
widget_control, state.wids.xplot , GET_UVALUE = xplotstate ;,/No_copy
;
; get plotted data
;
CASE xplotstate.nd OF 
  1: BEGIN
       plotfile,xplotstate.dthcurrent,/nodata,tmpset_pre1
       tmpset1 = tmpset_pre1([xplotstate.xpdt.xcol-1,xplotstate.xpdt.ycol-1],*)
       x = Reform(tmpset1[0,*])
       y = Reform(tmpset1[1,*])
       iMin = Min(abs(x-xcursor),icloser)
       ;print,'XPLOT_FINDPEAKS_RIGHTCLICK: Closer point: ',icloser,x[icloser],y[icloser]
       igood = xplot_findpeaks_getindices(id)
       
       CASE Fix(val) OF
         1: BEGIN ; add peak
            if igood[0] eq -1 then i_peaks=icloser else i_peaks=[igood,icloser]
            i_peaks = i_peaks(sort(i_peaks))
            END
         2: BEGIN ; remove peak
            if igood[0] eq -1 then return
            i_peaks = igood[where(igood NE icloser)]
            END
         ELSE:
       ENDCASE

     END
  2: BEGIN

       img = xplot2d_getimage(xplotstate.wids.main)
       ss=size(img)
       igood = xplot_findpeaks_getindices(id)
       CASE Fix(val) OF
         1: BEGIN ; add peak
            iLong = Long(ycursor)*ss[1]+Long(xcursor)
            if igood[0] eq -1 then i_peaks=iLong else i_peaks=[igood,iLong]
            i_peaks = i_peaks(sort(i_peaks))
            END
         2: BEGIN ; remove peak
            if igood[0] eq -1 then return
            ; calculate [PixelX,PizelY]] array with all peaks
            peaks2=array_indices([ss[1],ss[2]],Reform(igood),/dim)
            ; calculate distance from previous array to clicked point
            dd = Reform(sqrt(  (peaks2[0,*]-xcursor)^2 + (peaks2[1,*]-ycursor)^2  ))
            ; obtain the minimum distance, and take that index (imin)
            tmp = min(dd,imin)
            ; forget everything if clicked point is farer than 5 pixels from the closest peak
            IF dd[imin] GT 5 THEN RETURN 
            ; calculate the 1D index of the clicked minimum
            itmp = peaks2[1,imin]*ss[1]+peaks2[0,imin]
            ; remove this point from list
            i_peaks = igood[where(igood NE itmp )]
            END
         ELSE:
       ENDCASE

     END
ENDCASE
xplot_findpeaks_updatetable,id,i_peaks
CASE xplotstate.nd OF
  1: xplot_plot,xplotstate
  2: xplot2d_refresh,xplotstate.wids.main
  else:
ENDCASE
END ; xplot_findpeaks_rightclick
;
;
;
;
;=========================================================================
;

PRO xplot_findpeaks_updatetable,id,i_peaks,xplot=xplot
;
; updates the text widget of FindPeaks window with the peak 
; indices in i_peaks. Sets the xplot necessary variables to
; consider these points as "marked" points. 
;
;
FORWARD_FUNCTION xplot_text, xplot2d_getimage
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,$
    'XPLOT_FINDPEAKS_UPDATETABLE: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   RETURN
endif

;
;
Widget_Control, id, get_UValue=state ; FindPeaks' state
IF N_Elements(i_peaks) EQ 0 THEN i_peaks=[-1]

widget_control, state.wids.xplot , GET_UVALUE = xplotstate
if i_peaks[0] EQ -1 then begin
    Widget_Control,state.wids.table,Set_Value=['  ']
    CASE xplotstate.nd OF
      1: BEGIN
         IF handle_info(xplotstate.mk.mkIndices) EQ 1 THEN $
           handle_value,xplotstate.mk.mkIndices,i_peaks,/Set
         xplot_plot,xplotstate
         END
      2: BEGIN
         IF handle_info(xplotstate.mk.mkIndices) EQ 1 THEN $
           handle_value,xplotstate.mk.mkIndices,i_peaks,/Set
         xplot2d_refresh,xplotstate.wids.main
         END
      else:
    ENDCASE
    RETURN
endif 

CASE xplotstate.nd OF
  1: BEGIN
       plotfile,xplotstate.dthcurrent,/nodata,tmpset_pre1
       tmpset1 = tmpset_pre1([xplotstate.xpdt.xcol-1,xplotstate.xpdt.ycol-1],*)
       x = Reform(tmpset1[0,*])
       y = Reform(tmpset1[1,*])
       peaks2 = Make_Set(x[i_peaks],y[i_peaks])
     END
  2: BEGIN
       img=XPLOT2D_GETIMAGE(xplotstate.wids.main)
       ss = size(img)

       IF i_peaks[0] NE -1 THEN peaks2 = array_indices(ss[1:2],i_peaks,/dim) ELSE $
            peaks2=[-1,-1]
       IF N_Elements(peaks2) EQ 2 THEN peaks2=reform(peaks2,2,1)
     END
     else:
ENDCASE

npeaks = N_Elements(i_peaks)
;tmpset = Make_Set(i_peaks,x[i_peaks],y[i_peaks],LIndGen(npeaks))
tmpset = Make_Set(i_peaks,Reform(peaks2[0,*]),Reform(peaks2[1,*]),LIndGen(npeaks))

Widget_Control,state.wids.table,Set_Value=['  Index         x         y      #', $
  String(tmpset,Format='(I7,2G10.5,I7)')]
IF handle_info(xplotstate.mk.mkIndices) EQ 1 THEN BEGIN
    handle_value,xplotstate.mk.mkIndices,i_peaks,/Set
ENDIF ELSE BEGIN
    h=handle_create(value=i_peaks)
    xplotstate.mk.mkIndices=h
    widget_control, state.wids.xplot , SET_UVALUE = xplotstate
ENDELSE

CASE xplotstate.nd OF
  1: xplot_plot,xplotstate
  2: xplot2d_refresh,xplotstate.wids.main
ENDCASE

IF Keyword_Set(xplot) THEN BEGIN
  CASE xplotstate.nd OF
    1: BEGIN
         xplot,/no_block,tmpset,parent=p,xcol=2,ycol=3,coltitles=$
           ['Index','x','y','#']
         xplot_controls_action,p,PSYMSIGN=1,PSymbol=11
       END
    2: BEGIN
       img2 = img*0
       img2[peaks2[0,*],peaks2[1,*]]=img[peaks2[0,*],peaks2[1,*]]
       xplot2d,img2
       END
  ENDCASE 
ENDIF

end  ; xplot_findpeaks_updatetable
;
;=========================================================================
;
PRO xplot_findpeaks_event,event
;
common xplot_findpeaks,str
FORWARD_FUNCTION xplot_text, xplot2d_getimage

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,$
    'XPLOT_FINDPEAKS_EVENT: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   RETURN
endif
;
;
Widget_Control, event.id, get_UValue=eventUValue
Widget_Control, event.id, get_Value=Value
;
if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = event.handler
Widget_Control, stateid, get_UValue=state 

iCalculate = 0
iDisplay = 0
iXplot=0
iRefineWriteFile=0
Case eventUValue OF
    'DISMISS': BEGIN
    Widget_Control,event.handler,/destroy
    END
    'COMPUTE': BEGIN
        Widget_Control,event.id,Get_Value=val
;        CASE val OF
;         'Compute peaks': BEGIN
            iCalculate = 1
            iDisplay = 1
;            END
;         ELSE: 
;        ENDCASE
    END
    'HELP': BEGIN
        XDisplayFile1,TEXT=xplot_text('FINDPEAKS'),GROUP=event.top,$
        TITLE='Help on xplot findpeaks'
    END
    'DISPLAY': BEGIN
        Widget_Control,event.id,Get_Value=val
        CASE val OF
         'Update plot from table': BEGIN
	    i_peaks = xplot_findpeaks_getindices(stateId,Dialog_Parent=event.top)
            iDisplay=1
            END
         'Clean peaks': BEGIN
            i_peaks = [-1]
            iDisplay=1
            iXplot=0
            END
         'Refine peaks': BEGIN
             tmp = str.refine
             text = ['This option replace each peak in the list by the ',$
               'local maximum closer to it in a given window']
             XscrMenu,tmp,GROUP=event.top,/NOTYPE,ACTION=action, $
               WTITLE='Refining peak window', Titles = $
                 ['Window half-width [number of points/pixels', $
                 'Write a file with changes [control points for warping]', $
                 'FileName (? for browser)'], Flags=['1','1','w(1) EQ 1'], $$
                 HELP=text,DIALOG_PARENT=event.top, /Interp, FieldLen=50
             if action eq 'DONT' then RETURN
             str.refine=tmp

             i_peaks = xplot_findpeaks_getindices(stateId,Dialog_Parent=event.top)
             IF i_peaks[0] EQ -1 THEN RETURN
             i_peaksNew = i_peaks
             i_peaksOld = i_peaks
             ; get data
             ; 
             Widget_Control,state.wids.xplot,Get_UValue=xplotstate
             ww = str.refine.halfWindow
             CASE xplotstate.nd OF
             1: BEGIN
              plotfile,xplotstate.dthcurrent,/nodata,tmpset_pre1
              tmpset1 = tmpset_pre1([xplotstate.xpdt.xcol-1,xplotstate.xpdt.ycol-1],*)
              x = Reform(tmpset1[0,*])
              y = Reform(tmpset1[1,*])
              ymin = y*0-min(y)
              FOR i=0L,N_Elements(i_peaks)-1 DO BEGIN
                ymin = y*0-min(y)
                pmin = i_peaks[i]-ww>0<(N_Elements(y)-1)
                pmax = i_peaks[i]+ww>0<(N_Elements(y)-1)
                ymin[pmin:pmax]=y[pmin:pmax]
                tmpmax = max(ymin,imin)
                i_peaks[i]=imin
              ENDFOR
             END
             2: BEGIN
                pData=XPLOT2D_GETIMAGE(xplotstate.wids.main,/Pointer)
              img=*pData
              ss = size(img)
              FOR i=0L,N_Elements(i_peaks)-1 DO BEGIN
                peaks2 = array_indices([ss[1],ss[2]],i_peaks[i],/dim)
                pxmin = peaks2[0]-ww>0<(ss[1]-1)
                pxmax = peaks2[0]+ww>0<(ss[1]-1)
                pymin = peaks2[1]-ww>0<(ss[2]-1)
                pymax = peaks2[1]+ww>0<(ss[2]-1)
  
                tmpmax = max( img[pxmin:pxmax,pymin:pymax],imin )
                imin2 =  array_indices([pxmax-pxmin+1,pymax-pymin+1],imin,/dim)
                i_peaksNew[i]=(pymin+imin2[1])*ss[1]+(pxmin+imin2[0])
              ENDFOR
              i_peaks = i_peaksNew
             END
             else:
             ENDCASE
             iDisplay=1
             iXplot=0
             iRefineWriteFile=1

             END
         'Export to XPlot/XPLot2D': BEGIN
            i_peaks = xplot_findpeaks_getindices(stateId,Dialog_Parent=event.top)
            iDisplay=1
	    iXplot=1
            END
         ELSE:
        ENDCASE
	END
    else:
endcase

xplotnd=0
widget_control,state.wids.xplot , GET_UVALUE = xplotstate ;,/No_copy
if iCalculate then begin
  widget_control,state.wids.z,get_value=z
  widget_control,state.wids.m,get_value=m
  widget_control,state.wids.t,get_value=t
  widget_control,state.wids.algorithm,get_value=iAlgorithm
  widget_control,state.wids.analysis,get_value=iAnalysis
  str.z=z
  str.m=m
  str.threshold=t
  

  algorithm=str.algorithm
  algorithm[0]=iAlgorithm
  str.algorithm=algorithm

  analysis=str.analysis
  analysis[0]=ianalysis
  str.analysis=analysis
  widget_control,/Hourglass

  CASE xplotstate.nd OF
  1: BEGIN
    plotfile,xplotstate.dthcurrent,/nodata,tmpset_pre1
    tmpset1 = tmpset_pre1([xplotstate.xpdt.xcol-1,xplotstate.xpdt.ycol-1],*)
    x = Reform(tmpset1[0,*])
    y = Reform(tmpset1[1,*])
    i_peaks = peakfinder(y,m=str.m,z=str.z,threshold=str.threshold, $
      algorithm=Fix( (str.algorithm)[0] ),anal=Fix( (str.analysis)[0] ))
  END
  2: BEGIN
   pData=XPLOT2D_GETIMAGE(xplotstate.wids.main,/Pointer)
   img=*pData
   tmp = peakfinder2d(img,m=str.m,z=str.z,threshold=str.threshold, $
      algorithm=Fix( (str.algorithm)[0] ),anal=Fix( (str.analysis)[0] ),indices1d=indices1d)
   i_peaks = indices1d
  END
  else:
  ENDCASE

  ;WIDGET_CONTROL,state.wids.xplot,Set_UValue=xplotstate
endif

if iDisplay EQ 1 then begin
   CASE xplotstate.nd OF
     1:xplot_findpeaks_updatetable,event.handler,i_peaks,xplot=iXplot
     2:xplot_findpeaks_updatetable,event.handler,i_peaks,xplot=iXplot
     else:
   ENDCASE
endif

IF iRefineWriteFile THEN BEGIN
   tmp = str.refine
   IF Fix( (tmp.WriteFile)[0] ) EQ 1 THEN BEGIN
      file = tmp.FileName
      IF StrCompress(file,/Rem) EQ '?' THEN BEGIN
        file = Dialog_PickFile(Dialog_Parent=event.top,/Write, $
         file='controlpoints.dat')
        IF file EQ '' THEN RETURN
      ENDIF
      IF checkFile(file) EQ 1 THEN BEGIn
        itmp = Dialog_Message(Dialog_Parent=event.top, $
          ['File exists: '+file,'','Overwrite? '],/Cancel)
        IF itmp EQ 'Cancel' THEN RETURN
      ENDIF
      str.refine.fileName=file 
      openw,unit,file,/get_Lun
      FOR i=0L,N_Elements(i_peaks)-1 DO BEGIN
          CASE xplotstate.nd OF
            1: print,i_peaksOld[i],i_peaks[i]
            2: BEGIN
               pp1 = array_indices([ss[1],ss[2]],i_peaksOld[i],/dim)
               pp2 = array_indices([ss[1],ss[2]],i_peaks[i],/dim)
               printf,unit,pp1[0],pp1[1],pp2[0],pp2[1]
               END
            else:
          ENDCASE
      ENDFOR 
      free_lun,unit
      itmp = Dialog_Message(Dialog_Parent=event.top,/Question, $
          ['File written to disk: '+file,'','Open it? (for checking)'])
      IF itmp EQ 'Yes' THEN xdisplayfile1,file
   ENDIF
ENDIF



end  ; xplot_findpeaks_event
;
;=========================================================================
;
PRO xplot_findpeaks, id, openwindow=openwindow

common xplot_findpeaks,str
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,$
    'XPLOT_FINDPEAKS: error caught: '+!error_state.msg)
   if n_elements(xplotstate) NE 0 then $
    widget_control, id , SET_UVALUE = xplotstate,/no_copy
   catch, /cancel
   on_error,2
   return
endif

;if not(keyword_set(openwindow)) then goto,out
if N_Elements(openwindow) EQ 0 THEN openwindow=1 

if xregistered('xplot_findpeaks') GE 1 then begin
  itmp = Dialog_Message(Dialog_Parent=id, 'A "findpeaks" window '+$
    'is already open. ',/Error)
  RETURN
endif

if type(str) NE 8 then begin
  str = xplot_defaults('findpeaks')
endif

IF N_Elements(id) EQ 0 THEN id=0L
IF Widget_Info(id,/Valid_Id) THEN BEGIN
  Widget_Control,id,Get_UValue=xplotstate
ENDIF 

;
; define widgets
;
wbase=widget_base(/col,title='find peaks')

;
; main buttons
;
wtmp0 = widget_base(wbase,/Row)
  wtmp = widget_button(wtmp0,Value='Dismiss',UValue='DISMISS')
  wtmp = widget_button(wtmp0,Value='Help',UValue='HELP')
wtmp0 = widget_base(wbase,/Column,/Frame)
  wtmp = Widget_Label(wtmp0,Value='Compute peaks')
  wtmp1 = widget_base(wtmp0,/Row)
  wAlgorithm = cw_droplist(wtmp1,Value=str.algorithm, $
      Title='Algorithm:',UValue='COMPUTE')
  wAnalysis = cw_droplist(wtmp1,Value=str.analysis, $
      Title='Analyse threshold:',UValue='COMPUTE')
  wtmp1 = widget_base(wtmp0,/Row)
    wm = cw_field(wtmp1,Title='m: ',Value=str.m,UValue='COMPUTE',$
    /Float,XSize=6,/Return_Event)
    wz = cw_field(wtmp1,Title='z: ',Value=str.z,UValue='COMPUTE',$
    /Float,XSize=6,/Return_Event)
    wt = cw_field(wtmp1,Title='Threshold: ',Value=str.threshold,UValue='COMPUTE',$
    /Float,XSize=6,/Return_Event)
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_button(wtmp1,Value='Compute peaks',UValue='COMPUTE')

wtmp0 = widget_base(wbase,/Column,/Frame)
  wtmp = widget_label(wtmp0, Value='Display  and Edit peaks')
  wtmp = widget_label(wtmp0, Value='(Peaks are "marked" points in XPlot)')
  wRightClick = cw_droplist(wtmp0,Value=str.rightClick, $
      Title='Right click to:',UValue='DISPLAY')
  wtmpB = widget_base(wtmp0, /Row)
    wtmp = widget_button(wtmpB,Value='Update plot from table',UValue='DISPLAY')
    wtmp = widget_button(wtmpB,Value='Clean peaks',UValue='DISPLAY')
    wtmp = widget_button(wtmpB,Value='Refine peaks',UValue='DISPLAY')
    wtmp = widget_button(wtmpB,Value='Export to XPlot/XPLot2D',UValue='DISPLAY')

  wtmp = widget_label(wtmp0, Value='Table of peaks: ')
  wTable = widget_text(wtmp0,/Editable,Scroll=1,XSize=60,YSize=25)

if n_elements(id) EQ 0 then id=0L
wids = {m:wm,  z:wz, t:wt, xplot:id, table:wTable, algorithm:wAlgorithm, $
        rightClick:wRightClick, analysis:wAnalysis}
state = {wids:wids}

xplotnd=0
;
; set variables in Parent XPlot
; 
IF N_Elements(xplotstate) NE 0 THEN BEGIN
  ;widget_control, id , GET_UVALUE = xplotstate ;,/no_copy
  xplotnd=xplotstate.nd

  i_peaks=[-1]
  IF handle_info(xplotstate.mk.mkIndices) EQ 1 THEN BEGIN
       handle_value,xplotstate.mk.mkIndices,i_peaks
       IF i_peaks[0] NE -1 THEN BEGIN
         itmp = Dialog_Message(['Your current XPLot/XPlot2D session uses "marked" points.',$
           'The PeakFinder utility can import these marks',$
           'Do you want to import marks in PeakFinder?'],/Cancel,/Question, $
           Dialog_Parent=id)
         if itmp EQ 'Cancel' THEN RETURN
         if itmp EQ 'No' THEN i_peaks=[-1]
       ENDIF
  ENDIF

  CASE xplotstate.nd OF
    1: BEGIN
      xplotstate.mk.mkPSYM=11
      xplotstate.mk.mkCOLOR=8
      xplotstate.wids.findPeaks=wBase
      no_block = xplotstate.no_block
    END
    2: BEGIN
      xplotstate.mk.mkPSYM=1
      xplotstate.mk.mkCOLOR=6
      xplotstate.wids.findPeaks=wBase
      no_block = 1
    END
  ENDCASE

  widget_control, id , SET_UVALUE = xplotstate ;,/no_copy
  xmanager,'xplot_findpeaks',wbase,GROUP=id, No_Block=no_block

ENDIF ELSE BEGIN 
  xmanager,'xplot_findpeaks',wbase, No_Block=1
ENDELSE

widget_control,wbase,set_uvalue=state
widget_control,wbase,/realize

IF xplotnd GT 0 THEN xplot_findpeaks_updatetable,wbase,i_peaks

end ; xplot_findpeaks



