pro xhelp,file,out,Group=Group,_Extra=extra

;+
; 
; NAME: 
;	XHELP
;
; PURPOSE:
;	Display the idl doc from a file name.
;
; CATEGORY:
;	Widgets.
;
; CALLING SEQUENCE:
;	XHELP, Filename [, text]
;
; INPUTS:
;     Filename:	A scalar string that contains the filename of the file
;		to display.  The filename can include a path to that file.
;
; OPTIONAL OUTPUTS:
;    Text: a named variable where to return the documentation text.
;
; KEYWORD PARAMETERS:
;	GROUP:	The widget ID of the group leader of the widget.  If this 
;		keyword is specified, the death of the group leader results in
;		the death of XHELP.
;	_Extra: other keywoords to be passed to XDisplayFile1
;
; OUTPUTS:
;	No explicit outputs.  A file viewing widget is created.
;
; SIDE EFFECTS:
;	Triggers the XMANAGER if it is not already in use. 
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Same as dl_unix, but sending the output to xdisplayfile1.
;	It calls $IDL_DIR/bin/doc_library shell script from the IDL
;	distribution.
;
; COMMON FILES: 
;	xhelp, docdir
;		(docdir is a string or an array of strings with a directory 
;		path, i.e.  $XOP_HOME/doc )
;		When docdir is defined, xhelp looks for the file Filename.txt
;		in the docdir directory. If it is found, then it displays
;		it, otherwise it looks for the standard procedure.
;		This is introduced  to be able to use the Help botton in
;		xop applications after the embedding, when the source will not 
;		be available.
;
; MODIFICATION HISTORY:
;	Written By Manuel Sanchez del Rio (srio@esrf.fr), August 1996
;	96-10-10 Bug corrected: it didn't consider the last directory in
;	         !path. Translate always name to lower case.
;	97-01-13 srio@esrf.fr introduces the common block and its
;		related action.
;	97-01-17 srio@esrf.fr ports to Windows95.
;	97-10-27 srio@esrf.fr sdep() used.
;	00-07-17 srio@esrf.fr allows docdir to be an array of strings.
;	03-01-10 srio@esrf.fr changed .doc by .txt
;	08-04-08 srio@esrf.eu adds dospath() for windows. 
;-
;
on_error,2
common xhelp, docdir

separator = sdep(/ds)
;if sdep() EQ 'WINDOWS' and strlen(file) GT 8 and $
;  sdep(/vs) EQ '4' then file=strmid(file,0,6)+'~1'

myfile = strlowcase(file)+'.pro'         ;make it always lower case
ifound = 0

case sdep() of
'UNIX': begin
  n = strparse(!path,':',list)
  fulllist =  './'+myfile
  for i=0,n do fulllist = fulllist+' '+list[i]+'/'+myfile
  command = !dir+'/bin/doc_library cat 0 '+fulllist
  ;message,/info,'Executing: '+command
  spawn,command,out,/sh
  IF N_Elements(out) GT 2 THEN BEGIN
    ifound = 1
    xdisplayfile1,text=out,title='xhelp: '+file,group=group, $
	  _Extra=extra
  ENDIF ELSE BEGIN
    ifound = 0
  ENDELSE
  end
'WINDOWS': begin
  n = strparse(!path,';',list)
  list = ['.',list]+'\'+myfile
  n=n+1
  ;openw, outunit, 'xhelp.txt',/GET_LUN
  ;printf, outunit,'xhelp search on '+systime()
  text = ''
  ifound = 0
  for i=0,n do begin
    if checkfile(list[i]) EQ 1 then begin
      ifound = ifound+1
      ;printf, outunit
      ;printf, outunit, '----- Documentation for ',list[i]
      ;printf, outunit
	text = [text,' ', '----- Documentation for '+list[i],' ']
      openr, unit, list[i], /GET_LUN
      line = ""
      outflag = 0
      readf, unit, line
      while not eof(unit) and strpos(line, ";-") ne 0 do begin
        ;if outflag then printf, outunit, strmid(line, 1, 132)
        if outflag then text = [text,strmid(line, 1, 132)]
        ;
        ; output lines after line which starts with ";+"
        ;
        if strpos(line, ";+") eq 0 then outflag = 1
        readf, unit, line
      endwhile
      free_lun,unit
      endif
  endfor
  IF ifound NE 0 THEN BEGIN
	xdisplayfile1,text=text, GROUP=group, _Extra=extra
  ENDIF
  ;free_lun,outunit
  end
  else: 
endcase

IF ifound EQ 0 THEN BEGIN
  IF keyword_set(docdir) THEN BEGIN
    IF docdir[0] NE '' THEN BEGIN
      FOR i=0L, N_Elements(docdir)-1 DO BEGIN
        ffile = dospath(docdir[i])+separator+file+'.txt'
        if checkfile(ffile) then begin
	 ifound=1
         text = read_textfile(ffile)
         XDisplayfile1,ffile,title='xhelp: '+ffile,group=group, $
	  _Extra=extra
           RETURN
        endif
      ENDFOR
    ENDIF 
  ENDIF
ENDIF

IF ifound EQ 0 THEN BEGIN
    cd,c=c
    itmp = widget_message(/INFO,['Entry '+myfile+' not found in path: ',$
	c ,!path])
ENDIF


end

