;+
; 
; NAME: 
;	XDISPLAYFILENATINE
;
; PURPOSE:
;	Displays a file in native form
;
; CATEGORY:
;	Tools.
;
; CALLING SEQUENCE:
;	XDISPLAYFILENATIVE Filename
;
; INPUTS:
;     Filename:	A scalar string that contains the filename of the file
;		to display.  The filename can include a path to that file.
;
; KEYWORD PARAMETERS:
;	COMMAND: The command to be spawned (using %F for the file name)
;		Default: Unix: nedit %F &
;			 Windows: start %F
;
; EXAMPLES:
;	xdisplayfilenative,'~/.login',command='xterm -exec view %F -title "file: %F" -sb -sl 1000 &'
;
; MODIFICATION HISTORY:
;	Manuel Sanchez del Rio (srio@esrf.fr) 2003-01-07
;-
PRO XDisplayFileNative,file,Command=command


IF N_Elements(file) EQ 0 THEN file=Dialog_PickFile()
IF file EQ '' THEN RETURN

IF N_Elements(command) EQ 0 THEN BEGIN
  CASE SDep() OF 
    'WINDOWS': command = 'start %F'
    else: command = 'nedit %F &'
  ENDCASE
ENDIF

command = StrSubstitute(command,'%F',' '+file+' ')
print,command
if sdep() EQ "UNIX" then spawn,command,/sh else spawn,command
END
