;+
;
;==============================  Xbfield   =====================================
;
;   Xbfield is an widget based graphical interface to calculate 
;   field of an tappered undulator insertion devices.
;
;************************* IMPORTANT NOTICE ************************************
;   This utility (coming with the YAUP distribution), in the tapered case, 
;   generates a B field assumed be an amplitude-modulated sinusoid, e.g.
;   Btot(z) = B(z)*sin(2*pi/period*z) and a linearly modulated gap is 
;   assumed.  DG is the degree of gap taper:
;   gap=gzmin*(1.0+z*dg/ulen)
;   r=gap/per
;   ampl=0.95*3.44*exp(-r*(5.08-1.54*r)) (for Nb-Fe-B magnets) or
;   ampl=0.95*3.33*exp(-r*(5.47-1.80*r)) (for Sm-Co magnets). This
;   approximation comes from "6 GeV Synchrotron X-ray Source, Conceptual
;   Design Report Supplement A", LS-52, Argonne National Laboratory,
;   (March 1986), and you can also find it in the ESRF Foundation Phase
;   Report (The red book), pag CIV-314
;   
;   If these parameters does not fit with the user's requirements, then
;   the user should either customize it or create another bfield 
;   program which writes the output magnetic field in the format 
;   accepted by yaup.
;*******************************************************************************
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    XBField input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main XBField window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, BFIELD starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;    Plot Results: Plots the BFIELD results.
;    Show Numerical Results: Displays the BFIELD result file.
;
;  Help:   Shows the BFIELD help and the XBFIELD help (this text).
;
;
; COPYRIGHT:
;	xyaup and xbfield belong to XOP package and are distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
;	In addition, published calculations using the YAUP package 
;	should also cite:
;
;	  B. I. Boyanov, G. Bunker, J. M. Lee, and T. I. Morrison
;	  "Numerical Modeling of Tapered Undulators"
;	  Nucl. Instr. Meth. A339,  596-603, 1994
;
; LAST MODIFICATION: msr/msr/99-03-16
;
;-
; -----------------------------------------------------------------------
;	Author: Francois Legrand (CEA Bruyeres-le-Chatel F-91680) Oct 94
;	from Xurgent.pro (M. Sanchez del Rio(srio@esrf.fr) ESRF Nov 1993)
;	Modification history:
;	
;	94/10/28 MSR(srio@esrf.fr) changes the spawn call, to integrate
;		in the xop(1.1) distribution. Some cosmetics. Remove 
;		common blocks. Call defaults through xop_defaults, and 
;		fix them. Add the IMPORTANT NOTICE to this help.
;	94/11/22 MSR(srio@esrf.fr) introduces the Sm-Co magnet. It uses
;		a system call to a program bfield2, which is similar
;		to bfield (from the yaup distribution), but with the 
;		already mentioned Sm-Co parameters.
;	96/01/18 MSR(srio@esrf.fr) changes xtext -> widget_message
;	97/01/23 MSR(srio@esrf.fr) ports to Windows95.
;	97/02/05 MSR(srio@esrf.fr) adds help button in par window.
;	97/10/05 MSR(srio@esrf.fr) uses sdep(), xop_wd and coltitles in
;		xplot; also uses dialog_parent in widget_message.
;	98/12/04 srio@esrf.fr adapts for XOP2.0 (Unix)
;	99/03/16 srio@esrf.fr updates doc.
;
;

;
;==============================================================================
;
FUNCTION xbfield_version
RETURN,'1.1'
END ; xbfield_version
;
;========================================================================
;
FUNCTION XBFIELD_FLAGS
;
; create the logical flags for driving the menu
;
flags = [ $
'1',	$			; periode (0)
'1',	$
'1',	$
'1',	$
'1',	$			; itype (3)
'w(4) EQ 0',$			; k (4)
'w(4) EQ 1',$			; gap (5)
'w(4) EQ 1',$			; gaptap (6)
'1']
return,flags
end
;
;=======================================================================
;
PRO XBFIELD_OUTPUT,FILETYPE=filetype,BINFILE=binfile,TXTFILE=txtfile
;
; convert BFIELD output file to ascii
;
;	write input file to call u2txt for transcription
;
name = 'u2txt.inp'
OPENW,unit,name,/GET_LUN
PRINTF,unit,STRCOMPRESS(filetype,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(binfile,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(txtfile,/REMOVE_ALL)
FREE_LUN,unit
;
;	call u2txt
;
command = 'u2txt <u2txt.inp'
Xop_Spawn,command,CleanFiles=['bfield.out']
if sdep() EQ 'WINDOWS' then command = 'del u2txt.inp' else $
  command = '/bin/rm -f u2txt.inp'
message,/info,'Executing: '+command 
if sdep() eq "UNIX" then spawn,command,/sh else spawn,command
;
END
;
;=======================================================================
;
FUNCTION XBFIELD_DESCRIPTION
;
; give description of the input structure
;
on_error,2
;
res = [  'PERIOD - magnet period (cm)'	$
,'N - number of periods'		$
,'NPTS - nb of point / period'		$
,'Undulator Magnet: ' 			$
,'Undulator type: ' 			$
,'K - K field parameter'		$
,'GAP - initial gap (cm)'		$
,'GAPTAP - Gap taper (%)'		$
,'FILE - Output file name'		$
]
;
return,res
end

; 
;=======================================================================
;
; FUNCTION  XBFIELD_INP_READ,file,struct
; ;
; ; read an Bfield input file, ans stores the result in struct
; ;
; ; the return value is the error flag: MUST BE DEFINED TO -1 BEFORE
; ;
; on_error,2
; i_out=-1
; PRINT,'*** Reading input parameters in file: '+file+' ***'
; openr,Unit,file,/get_lun
; ;
; readf,Unit, period
; readf,Unit, nper
; readf,Unit, npts
; readf,Unit, itype
; IF (itype EQ 2) THEN BEGIN
; 			readf,Unit, gap
; 			readf,Unit, gaptap
; 			k = 1  ;only to define a value
; 		ENDIF ELSE BEGIN
; 			readf,Unit, k
; 			gap = 1	;only to define a value
; 			gaptap = 10  ;only to define a value	
; 		ENDELSE
; readf,Unit, file
; free_lun,Unit
; ;
; struct = xop_defaults('xbfield')
; ;
; ; write the read values into the structure tags
; ;
; struct.PERIOD= period
; struct.NPER= nper
; struct.NPTS= npts
; struct.ITYPE= itype
; struct.K= k
; struct.GAP=gap
; struct.GAPTAP=gaptap
; struct.FILE= STRCOMPRESS(file,/REMOVE_ALL)
; ;PRINT,'successful completation of work'
; i_out = 0     ; successful completation of work
; return,i_out
; end 

;
;======================================================================
;
PRO XBFIELD_INP_WRITE,bfinpstr,NAME=name
;
; write the contents of the structure with parameters for running BFIELD
;
IF NOT(KEYWORD_SET(name)) THEN name='bfield.inp'
;
PRINT,'*** Writing input parameters into file: '+name+' ***'

OPENW,unit,name,/GET_LUN

PRINTF,unit,STRCOMPRESS(bfinpstr.PERIOD,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(bfinpstr.NPER,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(bfinpstr.NPTS,/REMOVE_ALL)
IF (STRCOMPRESS(bfinpstr.ITYPE(0),/REMOVE_ALL) EQ '1') THEN BEGIN
  PRINTF,unit,'2'
  PRINTF,unit,STRCOMPRESS(bfinpstr.GAP,/REMOVE_ALL)
  PRINTF,unit,STRCOMPRESS(bfinpstr.GAPTAP,/REMOVE_ALL)
ENDIF ELSE BEGIN
  PRINTF,unit,'1'
  PRINTF,unit,STRCOMPRESS(bfinpstr.K,/REMOVE_ALL)
ENDELSE
PRINTF,unit,STRCOMPRESS(bfinpstr.FILE,/REMOVE_ALL)

FREE_LUN,unit
;PRINT,'successful completation of work'
;
END

;
;==========================================================================
;
PRO XBFIELD_SET,inp,GROUP=group
;
; set the input parameters for BFIELD and run it
;
;
bfinpstr = inp.bfinpstr
filename = inp.filename
;


sep=sdep(/ds)
helpcmd = "xDisplayfile1,'"+$
  Xop_GetEnv('XOP_HOME')+sep+'doc'+sep+'txt'+sep+'xbfield_par.txt'+$
	"'" 
;helpcmd = "xdisplayfile1,'"+$
;  Xop_GetEnv('XOP_HOME')+sep+'doc'+sep+'xbfield_par.txt'+$
;	"',group=event.top,/NoMenuBar" 
XSCRMENU,bfinpstr,GROUP=xurbase,NCOL=2,ACTION=action, /INTERP, $
  FLAGS=XBFIELD_FLAGS(), TITLES=XBFIELD_DESCRIPTION(),/NOTYPE, $
  HELP=helpcmd, Wtitle='XBField input parameters'
IF (action EQ 'DO') THEN BEGIN
  XBFIELD_INP_WRITE,bfinpstr
  if sdep() EQ 'WINDOWS' then command = 'del bfield1.out' else $
    command = '/bin/rm -f bfield1.out'
  message,/info,'Executing: '+command  
  if sdep() eq "UNIX" then spawn,command,/sh else spawn,command
  if strcompress(bfinpstr.imagnet(0),/rem) eq '0' then begin
    print,'**** Nb-Fe-B selected'
    command = 'bfield < bfield.inp >bfield.out'
  endif else begin
    print,'**** Sm-Co selected'
    command = 'bfield2 < bfield.inp >bfield.out'
  endelse
  PRINT,'	--> BFIELD calculation in process.. please wait...'
  Xop_Spawn,command
  filename='bfield.out'
ENDIF
;
inp.bfinpstr = bfinpstr
inp.filename = filename

end
;
;==========================================================================
;
PRO xbfield_event,event
Forward_Function xop_defaults
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XBFIELD_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; register the events
;
WIDGET_CONTROL, event.id, GET_UVALUE=eventuval, HOURGLASS=1
widget_control, event.top, GET_UVALUE=inp
bfinpstr = inp.bfinpstr
filename = inp.filename

CASE eventuval OF
	'XBFQUIT': BEGIN
		 if sdep() EQ 'WINDOWS' then command = $
		   'del bfield.inp bfield.out undulbf.txt' else $
		   command = '/bin/rm -f bfield.inp bfield.out undul.bf.txt'
		 message,/info,'Executing: '+command 
                 if sdep() eq "UNIX" then spawn,command,/sh else spawn,command
		 WIDGET_CONTROL,event.top,/DESTROY
		 END


	'FILEINPUT': BEGIN
		action=''
		Widget_Control,event.id, Get_Value=action
		CASE action OF
		'Load from file...': BEGIN
		  ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
		  filter='*.xop'
		  str_par = Xop_Input_Load(Title=$
		    'Select XBField input file...',$
		    /NoConf,Filter=filter,Group=event.top)
		  IF Type(str_par) EQ 8 THEN BEGIN
		    tmp = inp.bfinpstr
		    Copy_Structure,str_par,tmp,Group=event.top,/OnlyFirstField
		    inp.bfinpstr = tmp
		  ENDIF
		  Widget_Control,event.top,Set_Uvalue=inp,/NO_COPY
		  END
		'Save to file...': BEGIN
		  str_par = inp.bfinpstr
		  Xop_Input_Save,str_par,File='xbfield.xop',$
		    /Write, Group=event.top, Comment='; xop/xbfield(v'+$
		    xbfield_version()+') input file on '+SysTime()
		  END
		'Save as default': BEGIN
		  str_par = inp.bfinpstr
		  Xop_Input_Save,str_par,Group=event.top, $
		    Default='xbfield.xop',Comment='; xop/xbfield(v'+$
		    xbfield_version()+') input file on '+SysTime()
		  END
		ENDCASE
		END

;	'XBFDATA': BEGIN
;		 WIDGET_CONTROL,event.id,GET_VALUE=eventval
;		  CASE eventval OF
;                  "LOAD Bfield input file": BEGIN
;			infile=PICKFILE(GROUP=event.top,FILTER='*.inp')
;			IF (infile EQ '') THEN RETURN
;			k_err = -1
;			k_err = XBFIELD_INP_READ(infile,tmp)
;			bfinpstr = tmp
;			IF k_err LT 0 THEN $
;			  ;xtext,text=['',' Error reading file...',$
;                          ;' This seems not an Bfield ', $
;                          ;' input file  '],size=[25,6],GROUP=event.top
;			  junk = widget_message(dialog_parent=event.top,$
;			    /error, $
;			    ['',' Error reading file...', $
;                            ' This seems not an Bfield ',' input file. '])
;			XBFIELD_SET,inp,GROUP=event.top
;			widget_control,event.top,set_uvalue=inp,/NO_COPY
;			END
;		   "SAVE Bfield input file as...": BEGIN
;                        file=pickfile(/WRITE,FILE='bfield.inp',GROUP=Event.Top)
;                        if file NE '' then XBFIELD_INP_WRITE,bfinpstr,name=file
;			;bfieldfile = { BFFileName, ffile:'bfield.inp' }
;			;XscrMenu,bfieldfile,TITLES=['Output file name:'], $
;			  ;/NOTYPE,WTITLE='Save as...',GROUP=event.top, $
;			  ;ACTION=action, /INTER
;			;if action eq 'DO' then begin
;		 	 ;XBFIELD_INP_WRITE,bfinpstr,name=bfieldfile.ffile
;		 	 ;endif
;		         END
;		  ENDCASE
;		END

	'XBFSETP':	BEGIN
			XBFIELD_SET,inp,GROUP=event.top
			widget_control,event.top,set_uvalue=inp,/NO_COPY
			END
	'XBFSETD':	BEGIN
			itmp = widget_message(dialog_parent=event.top, $
			  /Question,['This option initializes the',$
			  'xbfield parameters to their default values.',$
			  'Then you must click Set_parameters to run the'+$
			  ' program.','Please confirm'],$
			  title='xbfield: set defaults')
			IF itmp EQ 'No' THEN RETURN
			bfinpstr = xop_defaults('xbfield')
			inp.bfinpstr = bfinpstr
			widget_control,event.top,set_uvalue=inp,/NO_COPY
			END
	'XBFHELP':	BEGIN
                  WIDGET_CONTROL,event.id,GET_VALUE=eventval,HOURGLASS=1
                  CASE eventval OF
			"Xbfield": Xhelp,'xbfield',Group=event.top
			"Bfield":  BEGIN
				sep = sdep(/ds)
				hfile = Xop_GetEnv('XOP_HOME')+$
				  sep+'doc'+sep+'txt'+sep+'bfield.txt'
				XDISPLAYFILE1, hfile, GROUP=event.top
				   END
		  ENDCASE
		END
	'XBFSHOW':	BEGIN
		  WIDGET_CONTROL,event.id,GET_VALUE=eventval
                  IF filename EQ '' THEN BEGIN
                    print,'XBFIELD: Result data not found. '
		    junk = widget_message(dialog_parent=event.top,$
			 /ERROR,['','bfield data not found...',$
			'Click Set_Parameters and Run BFIELD...  '])
		    return
                  ENDIF 
		  textfilename=bfinpstr.FILE+'.txt'
		  XBFIELD_OUTPUT,FILETYPE=1,BINFILE=bfinpstr.FILE,$
			TXTFILE=textfilename
		  CASE eventval OF
		    "Show Data":     XDISPLAYFILE1,textfilename,GROUP=event.top
		    else: BEGIN
			titles=['Z coordinate [cm]',$
			'Amplitude field intensity [T]','Phase field',$
			'Total field intensity [T]']
			XPLOT,STRCOMPRESS(textfilename,/REMOVE_ALL),$
			  coltitles=titles,xtitle='-1',ytitle='-1',$
			  group=event.top,wtitle='xbfield results'
			END
		  ENDCASE
		END
ENDCASE
END
;
;==============================================================================
;
PRO XBFIELD, GROUP=group, InputFile=inputFile

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XBFIELD: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; create the base (xurbase) widget
;
;
if xregistered('xbfield') then return

; if not(keyword_set(group)) then xop_wd,/default

xurbase=WIDGET_BASE(/COLUMN,TITLE='XBField '+xbfield_version(),MBAR=wMenuBar)

;======================

wFile = widget_button(wMenuBar,VALUE='File',/MENU)
  wtmp0 = widget_button(wFile,VALUE='XBField input parameters', /Menu)
  wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
  wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
  wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='XBFQUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='XBFSETP')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='XBFSETD')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Plot Results',UVALUE='XBFSHOW')
  wtmp = widget_button(wResults,VALUE='Show Data',UVALUE='XBFSHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='Xbfield', UVALUE='XBFHELP')
  wtmp = widget_button(wHelp,VALUE='Bfield', UVALUE='XBFHELP')
;
;======================
;XPdMenu, ['"File" {', $
;                        '"LOAD Bfield input file" 	XBFDATA',$
;                        '"SAVE Bfield input file as..." XBFDATA',$
;                        '"Quit" 			XBFQUIT',$
;                        '}',$
; 	'"Set Parameters"				XBFSETP',$
; 	'"Show" {',$
;			'"Results"			XBFSHOW',$
;			'"Show Data"			XBFSHOW',$
;			'}',$
; 	'"Help" {',$
;			'"Xbfield"			XBFHELP',$
;			'"Bfield"			XBFHELP',$
;			'}'$
;          ], xurbase
wtmp = widget_button(xurBASE,VALUE='Set Parameters', UVALUE='XBFSETP')


if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

junk = WIDGET_LABEL( xurBASE, FONT=font, $
      VALUE='BFIELD: tapered undulator field')

junk = WIDGET_LABEL( xurBASE, FONT=font, VALUE='(Preprocessor of Yaup)')

;
; data structure to be passed 
;
bfinpstr = xop_defaults('xbfield')
IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = bfinpstr
    Copy_Structure,str_par, tmp, Group=group
    bfinpstr = tmp
  ENDIF
ENDIF

filename = ''
inp = { xbfield_data, bfinpstr:bfinpstr, filename:filename }

widget_control,xurbase,set_uvalue=inp,/NO_COPY
WIDGET_CONTROL,/REALIZE,xurbase
XMANAGER,'xbfield',xurbase,GROUP_LEADER=group

end

