function xpowder_defaults
;
;+ 
; function xpowder_defaults
;
; returns an structure with inputs for xpowder
;
;-

;
; DABAX precalc
;

list=dabax_ls()
filef1f2 = list[where(strpos(list,'f1f2_') NE -1)]
filef0 = list[where(strpos(list,'f0_') NE -1)]

; get crystal data from DABAX
dabax_crystals,list=crystalnames,/onlyList

;
; def
;

austr = {from:['0','Spage group number','Spage group name','ASCII file with list'],number:52,name:'Pncn',file:'?'}
	austr_titles=['Symmetry from: ','Space group number:','Hermann-Mauguin symbol','file ( ? for launching browser)']
austr_flags = ['1','w(0) EQ 0','w(0) EQ 1','w(0) EQ 2']



hklStr = {wavelength:1.0,limitFlg:['0','2Theta Max','dspacing min','HLK Max'], $
       limitValue:30.0,debyeW:'1',cutOff:1E-3,  $
        filef0:['0',filef0], $
        anomalousFlg:['0','No','Yes'], filef1f2:['0',filef1f2],$
        ucFrom:['0','Unit Cell TAB','File'],ucellFile:'?' }

hklstr_titles=['Wavelength [A]','Limit reflections by',$
		'Value: ','Temperature factor (see help)','CutOff', $
		'DABAX file for atom scat.','Use anomalous scattering',$
		'DABAX file for anom. scat.:','Unit Cell From', $
                '*.ucell file (? for browser)']	

hklstr_flags = Replicate('1',N_Elements(hklstr_titles))
hklstr_flags[9] = 'w(8) EQ 1'


broadStr = {func:['0','Gaussian','Pseudovoigt'],$
		                width:0.05, step:0.02, voigtFac:0.5}
broadStr_titles=['Function: ','FWHM [deg]:','Step in 2theta',$
		'Voigt factor (0=G, 1=L)']
broadStr_flags = ['1','1','1','w(0) EQ 1']


ucLoad = {from:['0','Dabax','File'], crystal:['0',crystalnames], file:'?'}
ucLoad_titles=['Crystal unit cell from','DABAX crystal','*.ucell file (?=Browser)']
ucLoad_flags=['1','w(0) EQ 0','w(0) EQ 1']

;
; TEXT 
;
auAtoms = ['8  1.0  0.0  0.0  0.0  O1',   $
           '8  1.0  0.0  0.0  0.0  O2']

auSym = ['x,y,z','-x,-y,z'] 

ucAtoms = ['8   1.0   0.0   0.0   0.0   O1', $
           '8   1.0   0.0   0.0   0.0   O2']

ucCell = ['5.   5.   5.   90   90   90']
hkl = ['0 0 0 0 0 0 0 0 0 0']


str = Create_Struct('auStr',auStr,'auStr_Titles',auStr_Titles,'auStr_Flags',auStr_Flags)

str = Create_Struct(str, 'hklStr',hklStr,'hklStr_Titles',hklStr_Titles,'hklStr_Flags',hklStr_Flags, 'hkl',hkl)


str = Create_Struct(str, 'broadStr',broadStr,'broadStr_Titles',broadStr_Titles,'broadStr_Flags',broadStr_Flags)

str = Create_Struct(str, 'ucLoad',ucLoad,'ucLoad_Titles',ucLoad_Titles,'ucLoad_Flags',ucLoad_Flags)

str = Create_Struct(str, 'auAtoms',auAtoms,'auSym',auSym,'ucAtoms',ucAtoms)
str = Create_Struct(str, 'ucCell',ucCell)

str = Create_Struct(str, 'auAux',['s=1./3'])
RETURN,str
END
