;
;========================================================================
;

PRO xaid_mu2chi_calc,parent, defaultParms=defaultParms, $
  set=set, str=str, $
  out=out, coltitles=coltitles   ; output

;+
;
; PRO xaid_mu2chi_calc,parent, defaultParms=defaultParms, $
;   set=set, str=str, $
;   out=out, coltitles=coltitles   ; output
;
; Inputs: use either:
;     parent
;     set and str
;
; Keywords:
;     defaultParms: set default input parameters (only works with parent)
;
; Output: out, coltitles, ready for xplot, etc.
;
; 2006-07-21 srio@esrf.fr fix a bug with jump
; 2009-05-15 srio@esrf.eu rewritten
;
;-

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message($
       /Error,'XAID_MU2CHI_CALC: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif

IF N_Elements(parent) EQ 1 THEN BEGIN
  IF Keyword_Set(defaultParms) THEN  xaid_mu2chi_defaultparms,parent
  Widget_Control,parent,Get_UValue=state
  set = *(state.ptr)
  str = xaid_mu2chi_getstr(parent)
ENDIF


x_e=Reform(set[0,*])
y_mu=Reform(set[1,*])

;
; calculate k
;
tmp = e2k(set,e0=str.e0)
x_e0=x_e-str.e0
x_k=Reform(tmp[0,*])


; 
; preedge
;
y_pre = y_mu*0
IF str.preMin NE str.preMax THEN BEGIN
     fitset,Make_Set(x_e,y_mu),fit1,method=0, $
     xrange=[str.preMin,str.preMax],/VERBOSE
     y_pre = Reform(fit1[1,*])
ENDIF 
y_mupre = y_mu - y_pre

;
; normalization
;
y_muNor=y_mupre
IF str.jump NE 0 THEN y_muNor=y_mupre/Abs(str.jump)     

;
; postedge
spl = postedge_evaluate(Make_Set(x_k,y_mupre),spl_n=str.npol,$
    spl_degree=str.degree, spl_knots=str.knots)

IF N_Elements(spl) LE 1 THEN y_pos = x_k*0 ELSE $
  y_pos = Reform(spl[1,*])


CASE  Fix((str.extraction)[0]) OF
   0: BEGIN; experimental
      IF str.jump EQ 0 THEN y_chi=x_k*0 ELSE $
        y_chi  = (y_mupre - y_pos) / str.jump
      END
   1: BEGIN ; constant
        y_chi  = (y_mupre - y_pos) / y_pos
      END
   2: BEGIN ; lengeler
      IF str.jump EQ 0 THEN y_chi=x_k*0 ELSE $
        y_chi  = (y_mupre - y_pos) / str.jump  $
		/( 1. - (8./3.)*(x_e-str.e0)/str.e0 )
      END
ENDCASE

out=Make_Set(x_e,x_e0,x_k,y_mu,y_mupre,y_munor,y_pre,y_pos,y_chi,$
   y_chi*x_k,y_chi*x_k*x_k,y_chi*x_k*x_k*x_k)
coltitles=['E [eV]','E-Eo [eV]','k [A^-1]','Mu','Mu-PreEdge',$
	'Mu Norm','PreEdge','PostEdge','Chi','Chi*k','Chi*k^2','Chi*k^3']

END ; xaid_mu2chi_calc

