FUNCTION postedge_evaluate,set1,spl_n=spl_n,spl_degree=spl_degree, $
	spl_knots=spl_knots, Dialog_Parent=dialog_parent, $
        weightkpower=weightkpower

;+
; FUNCTION postedge_evaluate,set1,spl_n=spl_n,spl_degree=spl_degree, $
;	spl_knots=spl_knots, Dialog_Parent=dialog_parent,$
;       weightkpower=weightkpower
;
; set1 the normalized mu versus k
; spl_n: number of splines (ex:spl_n=3)
; spl_degree:L spline degrees (ex: spl_degree=[2,2,2] or spl_degree='[2,2,2]')
; spl_knots:L spline knots (ex: spl_knots=[1,3,8,20] or spl_knots='[1,3,8,20]')
; weightkpower: the power of k for the fit weight in polspl (w=k^weightkpower)
;
; srio@esrf.fr 2006-03-07
; 2009-05-13 srio@esrf.eu adds weightkpower keyword.
;-

spl=0

IF N_Elements(set1) EQ 0 THEN Message,'No input.'
IF N_Elements(spl_n) EQ 0 THEN spl_n = 3
IF N_Elements(weightkpower) EQ 0 THEN weightkpower = 0
IF N_Elements(spl_degree) EQ 0 THEN spl_degress=Replicate(2,spl_n)
IF N_Elements(spl_knots) EQ 0 THEN spl_knots=MakeArray1(spl_n+1,$
	min(set1[0,*]),Max(set1[0,*]) )

IF Type(spl_degree) EQ 7 THEN BEGIN
  command = 'spl_degree = '+spl_degree
  itmp = Execute(command)
  IF itmp NE 1 THEN BEGIN
    itmp = Dialog_Message(/Error,'Error executing: '+command)
    Return,spl
  ENDIF
ENDIF

IF Type(spl_knots) EQ 7 THEN BEGIN
  command = 'spl_knots = '+spl_knots
  itmp = Execute(command)
  IF itmp NE 1 THEN BEGIN
    itmp = Dialog_Message(/Error,'Error executing: '+command)
    Return,spl
  ENDIF
ENDIF


IF N_Elements(spl_degree) NE spl_n THEN BEGIN
  itmp = Dialog_Message(/Error,Dialog_Parent=dialog_parent, $
	['The dimension of the array with degrees is wrong.',$
	 'It must be equal to: '+StrCompress(spl_n)])
  Return,spl
ENDIF

IF N_Elements(spl_knots) NE spl_n+1 THEN BEGIN
  itmp = Dialog_Message(/Error,Dialog_Parent=dialog_parent, $
	['The dimension of the array with knots is wrong.',$
	 'It must be equal to: '+StrCompress(spl_n+1)])
  Return,spl
ENDIF

kk = Reform(set1[0,*])
y = Reform(set1[1,*])

if max(spl_knots) GT max(kk)+1e-3 then begin
	  itmp = Dialog_Message(/Question,Dialog_Parent=dialog_parent, $
		['Knot value ('+strcompress(max(spl_knots),/rem)+$
		') > maximum wavenumber ('+strcompress(max(kk),/rem)+'). ',$
		 'Please check knot values: must be in k (wavenumber) scale!',$
		 'Abort? '])
	  if itmp EQ 'Yes' then Return,spl
endif


npts = N_Elements(kk) 
nspectra=1

IF weightkpower EQ 0 THEN BEGIN
  w=fltarr(npts+1)
  w=w*0.0+1.0 
ENDIF ELSE BEGIN 
  w=kk^weightkpower
ENDELSE

c = dblarr(36)
xl = 0.0D0
xh = dblarr(10)
;ioerr = execute('xl = '+Vect2String(spl_knots))
;xl = [0.0,xl]
xl=[0.0,spl_knots]
nc = [0.0D0,spl_degree]
;
for i=1,spl_n do begin
          xh[i] = xl[i+1]
          nc[i] = nc[i]+1
endfor
tmp = dblarr(10)
tmp[0:n_elements(xl)-2]=xl[0:n_elements(xl)-2]
xl=tmp
xx=[0.0,kk]
nr = fix(spl_n)
fit=0
;set1=Make_Set(kk,y)
out2=fltarr(nspectra,npts)
widget_control,/hourglass
xl_saved = xl
xh_saved=xh

yy = [0.0, y]
c=dblarr(36)
; this is necessary because polspl changes the xh and xl values!!
xl = xl_saved
xh = xh_saved
;
polspl,xx,yy,w,npts,xl,xh,nr,c,nc
polspl_evaluate,set1,xl,xh,c,nc,nr,fit

spl=fit
Return,spl
END
