pro polspl_evaluate,set2,xl,xh,c,nc,nr,fit
;+
; NAME:
;	POLSPL_EVAL
;
; PURPOSE:
;
;	evaluate the combined spline fitted from its coefficients.
;	To be used after calls to POSLPL
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	POLSPL_EVALUATE,set,xl,xh,c,nc,nr,fit
;
; INPUTS:
;	set: the fltarr(2,npoints) set with the original data
;	XL,XH arrays contain NR adjacent ranges over which to fit 
;              individual polynomials.  
;       C array containing the polynomial coefficients resulting from the fit
;       NC array that specifies how many poly coeffs to use in each range 
;       NR the number of adjacent ranges
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	fit: a named variable to receive a set with the same abscissas of 
;            the input one and the coordinates evaluated from the fit 
;            parameters
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward. Input data is obtained from the output of polspl
;
; EXAMPLE:
;
;	POLSPL_EVALUATE,SET,XL,XH,C,NC,NR,C,FIT
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF,  February, 1993	
;	2009-05-13 srio@esrf.eu updated doc
;-
on_error,2
;
fit = set2*0.0
;
;change xl(1) and xh(nr) to extrapolate the fit
xl(1) = min(set2(0,*))
xh(nr) = max(set2(0,*))
;
; calculatest the first point
;
xval=set2(0,0)
yval=0.0
for k=1,nc(1) do yval =  yval+ c(k) * xval^(k-1)
fit(0,0) = xval
fit(1,0) = yval
;
; now the rest of the points
;
for i=0,n_elements(set2(0,*))-1 do begin       ; loop over all the points
  for j=1,nr do begin                  ; loop over the # of intervals
    if ((set2(0,i) gt xl(j)) and (set2(0,i) le xh(j))) then begin
      cstart=total(nc(0:j-1))
      xval = set2(0,i)
      yval = 0.0
      for k=1,nc(j) do yval =  yval+ c(cstart+k) * xval^(k-1)
      fit(0,i) = xval
      fit(1,i) = yval
    endif
  endfor
endfor
;
return
end
