FUNCTION nrbmaketoroid, p=p,q=q,angle=theta,ll=ll,ww=ww,rs=rs,rt=rt


;+
;
; FUNCTION nrbmaketoroid, p=p,q=q,angle=theta,ll=ll,ww=ww,rs=rs,rt=rt
;
; ARGUMENTS
;
;   LL = longitudinal aperture (chord, default = 10)
;   WW = transversal aperture (chord, default = 5)
;
;   Define either: 
;   ANGLE  = Grazing incident angle [rad]
;   P  = distance source-mirror
;   Q  = distance mirror-image
;   or: 
;   RS: Sagittal radius 
;   RT: Tangential radius (optical)
;
; OUTPUT
;
;   MIRR = a NURBS structure of a toroid
;
;-

IF n_elements(p) EQ 0 THEN p = 3000d
IF n_elements(q) EQ 0 THEN q = 1000d
IF n_elements(theta) EQ 0 THEN theta=5D-3



IF n_elements(rs) EQ 0 THEN BEGIN
    rs=2*p*q*sin(theta)/(p+q)  ;sagittal
ENDIF
IF n_elements(rt) EQ 0 THEN BEGIN
    rt=2*p*q/(p+q)/sin(theta)   ;tangential
ENDIF

IF n_elements(ll) EQ 0 THEN ll = 10d
IF n_elements(ww) EQ 0 THEN ww = 2d

p=double(p)
q=double(q)
theta=double(theta)
ll=double(ll)
ww=double(ww)
rs=double(rs)
rt=double(rt)

toro=__nrbtoroid(rs,rt,ll=ll,ww=ww)

return, toro

END
