PRO presurface_oper,input1,input2,file=file,oper=oper,result=result, $
    noInfo=noInfo, group=group

;+
; NAME:
;	PRESURFACE_OPER
;
; PURPOSE:
;	Perform simple operations with SHADOW surface files
;
; CATEGORY:
;	SHADOW's utilities.
;
; CALLING SEQUENCE:
;	presurface_oper,input1 [,input2, result]
;
; INPUTS:
;	input1: Name of a file containing the first surface 
;               (it may also be a structure as created by presurface.pro)
;
; OPTIONAL INPUTS:
;	input2: Name of a file containing the second surface 
;               (it may also be a structure as created by presurface.pro)
;               If undefined, a copy of input1 iis used.
;
; KEYWORD PARAMETERS:
;       OPER = A string with opeartion to perform, like: 
;              's=s1+s2' (this is the default)
;              's=s1-s2' 
;	FILE  = file name for output (default: presurface_oper.dat)
;	GROUP  = The parent widget id to center dialogs
;
; OUTPUT KEYWORD PARAMETERS:
;       RESULT = a named variable to receive the output data (a structure)
;
; PROCEDURE:
;	Straightforward. It uses Execute().
;
; MODOFICATION HISTORY:
;       2009/12/15 srio@esrf.eu written. 
;       2010/09/27 srio@esrf.eu added noInfo keyword. 
;
;-
;
on_error,2
; 
; 
IF N_Elements(input1) EQ 0 THEN Message,'Undefined inputs.'

presurface,input1,str1,/NoPlot
s1 = str1.z

IF N_Elements(noInfo) EQ 0 THEN noInfo=0

IF N_Elements(input2) NE 0 THEN BEGIN
  presurface,input2,str2,/NoPlot
ENDIF ELSE BEGIN
  str2 = str1
ENDELSE

s2 = str2.z
IF ( (N_Elements(str1.x) NE N_Elements(str2.x)) OR $
     (N_Elements(str1.y) NE N_Elements(str2.y)) ) THEN BEGIN
  itmp = Dialog_Message('PRESURFACE_OPER: Inconsistet array dimensions for both input surfaces',/Error)
  RETURN
ENDIF

s=0
IF N_Elements(oper) EQ 0 THEN oper='s=s1+s2'
print,'PRESURFACE_OPER: Executing: '+oper
itmp = execute(oper)
result = str2
result.z=s

IF N_Elements(file) EQ 0 THEN file='presurface_oper.dat'
write_shadowsurface,result.z,result.x,result.y,file=file

IF checkfile(file) THEN BEGIN
   if noInfo then begin
     itmp = 'Yes'
   endif else begin
     itmp = Dialog_Message(/Question,['PRESURFACE_OPER','', $
          'File writen to disk: '+file,'',$
          'Do you want to run SHADOWs presurface (.dat->.sha)?'],$
          Dialog_Parent=group)
   endelse
  IF itmp EQ 'Yes' THEN xsh_run_presurface,fileDat=file,group=group,noInfo=noInfo
ENDIF ELSE BEGIN
   itmp = Dialog_Message(/Error,$
         ['PRESURFACE_OPER: Failed to write file: ',file],Dialog_Parent=group)
ENDELSE

END ; presurface_oper
