function READ_TCSPC_SPE, filename,plot=plot,fluo_plot=fluo_plot,oplot=oplot,color=color,xrange=xrange,yrange=yrange,title=title,smooth_factor=smooth_factor,read_time=read_time,read_temperature=read_temperature
;+
; NAME:
;	READ_TCSPC_SPE
;
; PURPOSE:
;
; 	Read in an (ASCII) file from Ocean Optics Spectrometer.
;
; CATEGORY:
;	File managing
;
; CALLING SEQUENCE:
;	ref = READ_TCSPC_SPE(filename,[plot=plot],[oplot=oplot],[color=color],[xrange=xrange],[yrange=yrange],[title=title],[smooth_factor=smooth_factor],[read_time=read_time],[read_temperature=read_temperature])
;
; INPUTS:
;	filename : the path name of the file to process (with extension)
;	plot : [optional] to plot the spectrum
;	oplot : [optional] to overplot the spectrum
;	color : the color for the plot
;
; OUTPUTS:
;	data : the structure array containing infos
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April 2000
;-

;on_error,2                              ;Return to caller if an error occurs

IF N_ELEMENTS(filename) NE 0 THEN BEGIN
 file=FINDFILE(filename,count=count)
 IF count EQ 0 THEN BEGIN
  PRINT,'Sorry, filename: ',filename,' not existing !'
  RETURN,0
 ENDIF
ENDIF ELSE file=DIALOG_PICKFILE()


IF KEYWORD_SET(read_time) THEN BEGIN
 OPENR,lun,file(0),/GET_LUN

 header=STRARR(8)
 READF,lun,header
 w_h=STRPOS(header(1),':')
 hour=FIX(STRMID(header(1),w_h-2,2))
 minute=FIX(STRMID(header(1),w_h+1,2))
 read_time=[hour,minute,0]
 w_t1=STRPOS(header(2),':')
 w_t2=STRPOS(header(2),'K')
 read_temperature=FLOAT(STRMID(header(2),w_t1+1,w_t2-w_t1-1))
 FREE_LUN,lun
ENDIF


n_line_to_skip=8

data = READ_ASCII(file(0),SKIP=n_line_to_skip)

IF N_ELEMENTS(color) EQ 0 THEN color=!d.n_colors
IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[MIN(data(0,*)),MAX(data(0,*))]
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[MIN(data(1,*)),MAX(data(1,*))]
IF N_ELEMENTS(title) EQ 0 THEN title=''
IF N_ELEMENTS(smooth_factor) EQ 0 THEN smooth_factor=0

xtitle='Wavelength [nm]'
ytitle='Absorption [OD]'

linestyle=0
thick=1.5
charthick=1.5
charsize=1.5
xstyle=1
ystyle=1

IF smooth_factor GT 0 THEN data(1,*)=SMOOTH(data(1,*),smooth_factor)

IF KEYWORD_SET(plot) THEN BEGIN
 PLOT,data(0,*),data(1,*),xtitle=xtitle,ytitle=ytitle,title=title,linestyle=linestyle,thick=thick,charthick=charthick,charsize=charsize,xstyle=xstyle, ystyle=ystyle,xrange=xrange,yrange=yrange
ENDIF

IF KEYWORD_SET(fluo_plot) THEN BEGIN
ytitle='Fluorescence'
 PLOT,data(0,*),data(1,*),xtitle=xtitle,ytitle=ytitle,title=title,linestyle=linestyle,thick=thick,charthick=charthick,charsize=charsize,xstyle=xstyle, ystyle=ystyle,xrange=xrange,yrange=yrange
ENDIF


IF KEYWORD_SET(oplot) THEN BEGIN
 OPLOT,data(0,*),data(1,*),linestyle=linestyle,thick=thick,color=color
ENDIF

RETURN,data
END





