function FIND_REFSPOTS, image,reb,ref,par, $
		max_ref_spots = max_ref_spots, $
		min_ref_spots = min_ref_spots, $
		other_spots=other_spots, $
		number_ref_spots=number_ref_spots, $
		number_other_spots=number_other_spots, $
		min_sob = min_sob, $
		show_image = show_image, $
		show_ref_peaks = show_ref_peaks, $
		use_partials = use_partials, $
		sym_rad = sym_rad, $
		study_win = study_win, $
		main_win = main_win
;+
; NAME:
;	FIND_REFSPOTS
;
; PURPOSE:
;	Master program to handle Laue integration. A library of refernce peaks
;	is obtained with the
;	GET_XREF_PROF1.PRO routine. These peaks are box integrated. 
;	The other weak
;	peaks are profile fitted with the INTEGRATE_PF3.PRO routine. 
;	There is now spatial overlap deconvolution routine.
;	No correction for mosaicity, but simply averaging of the reference
;	profile, according to spot position
;
; CATEGORY:
;	Laue processing.
;
; CALLING SEQUENCE:
;	Integ = FIND_REFSPOTS(image,reb,ref,par,
;		max_ref_spots = max_ref_spots,min_sob = min_sob, 
;		show_ref_peaks = show_ref_peaks,
;		use_partials = use_partials,
;		study_win=study_win,
;		main_win=main_win )
;
;
; INPUTS:
;	image : the original image
;	reb : the rebinning factor
;	ref : the reflexion list, corrected for positions, produced by the 
;			MATCHLAUE2.PRO routine.
;	par : the parameters of the experiment
;	max_ref_spots : the maximum number of peaks to select in each sector
;	min_sob : the minimum signal to background ratio to select a peak
;							 -180 and +180)
;	show_ref_peaks = keyword set if the reference peaks are to be shown
;	use_partials : keyword set if partials are to be used for the
;		evaluation of reference spots.
;	study_win : window id of the window displaying surface plots, contour ... in debug modes
;	main_win : window id of the main window displaying the image
;
; OUTPUTS:
;	integ : a structure now similar to "ref": with in addition : 	
;						integrated intensities
;						tth angle
;						resolution (Angtroms)
;						wavelength
;						goodness of fit
;		
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Here is a sum up of how things are going :
;	1/ The reference profiles are calculated with the
;		GET_XREF_PROF1 routine. This routine selects the strongest 
;		spots in the image
;	2/ The reference profiles are box integrated with the routine 
;		INTEGRATE_BOX.PRO
;	3/ With these reference profiles, the routine INTEGRATE_PF3 is run for
;	  each remaining or overlapped spot. 
;	  The reference profile is computed with the 
;	  weighted average method. Spots can be rejected upon : a/ a bad 
;	  background subtraction, b/ a bad chi_square test, provided they are
;	  not overlapped
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 1997.
;-

IF NOT N_ELEMENTS(main_win) THEN main_win=-1
IF NOT N_ELEMENTS(study_win) THEN study_win=-1

;1/ get the reference spots on non overlapped non saturated  peaks :
PRINT,'Searching reference spots ...'
IF KEYWORD_SET(show_ref_peaks) THEN $
ref_spots = GET_XREF_PROF1(image,reb,ref(WHERE((ref.ovlp2 EQ 0) AND $
	(ref.close EQ 0))),par,max_ref_spots,min_sob,$
	min_ref_spots,use_partials=use_partials,$
	all_ref=ref,$
	bad_shift_count=bad_shift_count,$
	bad_fwhm_count=bad_fwhm_count,$
	spots_bad_fwhm=spots_bad_fwhm,$
	spots_bad_shift=spots_bad_shift,$
	/show,study_win=study_win,main_win=main_win) ELSE $
ref_spots = GET_XREF_PROF1(image,reb,ref(WHERE((ref.ovlp2 EQ 0) AND $
	(ref.close EQ 0))),par,max_ref_spots,min_sob,$
	min_ref_spots,use_partials=use_partials,$
	all_ref=ref,$
	bad_shift_count=bad_shift_count,$
	bad_fwhm_count=bad_fwhm_count,$
	spots_bad_fwhm=spots_bad_fwhm,$
	spots_bad_shift=spots_bad_shift $
	)

number_other_spots = bad_shift_count+bad_fwhm_count
IF number_other_spots GT 0 THEN BEGIN
 other_spots=REPLICATE(ref_spots(0),number_other_spots)
 IF bad_shift_count GT 0 THEN other_spots(0:bad_shift_count-1)=spots_bad_shift
 IF bad_fwhm_count GT 0 THEN other_spots(bad_shift_count:bad_shift_count+bad_fwhm_count-1)=spots_bad_fwhm
ENDIF ELSE other_spots=0
number_ref_spots = (SIZE(ref_spots))(1)

;plot all the reference peaks
IF ((NOT KEYWORD_SET(show_ref_peaks)) and (show_image eq 1)) THEN $
	dum=PIXLAUE2(ref_spots,reb,image,par,draw=10,color=3)


RETURN,ref_spots
END