pro FIND_OVLP2,spot_list,par,dist,min_dist
;+
; NAME:
;	FIND_OVLP2
;
; PURPOSE:
;	Finds the connections between overlapped spots in spot_list
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	FIND_OVLP2,spot_list,par,dist,min_dist
;
; INPUTS:
;	spot_list : a list of spots obtained by the program READ_GEASC2.PRO
;	par : the parameter from the reflist.pro routine
;	dist : the distance below which two neighbouring spots are considered
;		overlapped [mm]
;	min_dist : the distance below which two neighbouring spots are 
;		considered too closed to be deconvoluted [unit of par.boxsize]
;		If this is the case, the flag .ovlp is set to -1 for those 
;		spots.
; OUTPUTS:
;	spots : the part of struc matching the defined region of interest
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, November 1994.
;-

!ERR = 0

;reset any old attribution
spot_list(*).connect(*) = -1
spot_list(*).ovlp = 0

size_list=(SIZE(spot_list))(1)

cr = STRING("15b)

;separate into columns of no more than 500 spots but at least 1 columns !
n_columns = FIX(size_list/500.)>1
min_x = MIN(spot_list.x) & max_x = MAX(spot_list.x)
col_width = (max_x - min_x)/FLOAT(n_columns)

FOR col=0,n_columns-1 DO BEGIN

PRINT,FORMAT="($,'Number of scanned image columns : ', I3,' ie : ',F3.0,'%',A)",col,100.*col/FLOAT(n_columns),cr

;consider a restricted column with overlap = 2*dist
loc_min_x = min_x + col*col_width - dist
loc_max_x = loc_min_x + col_width + 2*dist
w_list = WHERE(spot_list.x GE loc_min_x AND spot_list.x LE loc_max_x,ct_list)
IF ct_list GT 0 THEN BEGIN
list = spot_list(w_list)


;compute the autocorrelation matrix of list for the distance :
x = list.x & y = list.y
dist_correl = ((x # REPLICATE(1,N_ELEMENTS(x))) - (REPLICATE(1,N_ELEMENTS(x)) # x))^2 + ((y # REPLICATE(1,N_ELEMENTS(y))) - (REPLICATE(1,N_ELEMENTS(y)) # y))^2

;where are the overlaps
w_ovlp = WHERE((dist_correl GT 0) AND (dist_correl LE dist^2), c_ovlp)

IF c_ovlp GT 0 THEN BEGIN

i_ovlp = FLOAT(WHERESUB(w_ovlp,dist_correl))
j_ovlp = IMAGINARY(WHERESUB(w_ovlp,dist_correl))


;we now go through all overlapped spots
FOR k=0L,c_ovlp-1 DO BEGIN
;indices in spot_list
sl_i = w_list(i_ovlp(k))
sl_j = w_list(j_ovlp(k))

;take into account the new overlap if it does not already exist
w_connect = WHERE(spot_list(sl_j).connect NE -1,c_connect)
IF c_connect GE 24 THEN BEGIN
 MESSAGE,'Too many overlap, check boxsize ...'
ENDIF ; c_connect gt 24
;are we not too close ?
IF dist_correl(w_ovlp(k)) LE min_dist^2 THEN spot_list(sl_j).close = 2

IF c_connect EQ 0 THEN BEGIN
;ok ! first connection
spot_list(sl_j).ovlp = 1
spot_list(sl_j).connect(0) = spot_list(sl_i).id
ENDIF ELSE BEGIN

;There exist already a connection
;We should make sure that the new connection does not exist already
IF MIN(ABS(spot_list(sl_j).connect - spot_list(sl_i).id)) NE 0 THEN BEGIN
;ok ! New connection
spot_list(sl_j).ovlp = spot_list(sl_j).ovlp + 1
spot_list(sl_j).connect(c_connect) = spot_list(sl_i).id
;ok=''
;read,'Ok?',ok

ENDIF
ENDELSE ;c_connect eq 0


ENDFOR ; k

ENDIF ; c_ovlp gt 0
ENDIF ; ct_list gt 0
ENDFOR ; col 

dum = WHERE(spot_list.close EQ 2,c_tooclose)
PRINT,'Number of reflexion too close to integrate :', c_tooclose,' ie :',c_tooclose/FLOAT(size_list)*100,' %'
dum = WHERE(spot_list.ovlp GE 1,n_ovlp)
PRINT,STRCOMPRESS('Number of reflexion overlapped :'+ STRING(n_ovlp)+' ie :'+STRING(n_ovlp/FLOAT(size_list)*100)+' %')

mistake:
END








