function DISP_RED, image,red_factor,new=new,log=log
;+
; NAME:
;	DISP_RED
;
; PURPOSE:
;	Calculates a rebinned version of image, by the factor red_factor,
;	and display it
;
; CATEGORY:
;	Signal, image processing.
;
; CALLING SEQUENCE:
;	Red = DISP_RED(image,red_factor,/new,/log) ;
;
; INPUTS:
;	image : the image to be rebinned
;	red_factor : the reduction factor
;	new : keyword set if a new window is wanted
;	log : keyword set if the log version of image is displayed
;
; OUTPUTS:
;	red : the rebinned version of image
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1995.
;-

ON_ERROR,2

IF (SIZE(image))(0) NE 2 THEN MESSAGE,'Not a 2D image !' ELSE BEGIN
x_size = (SIZE(image))(1)
y_size = (SIZE(image))(2)

red_x_size = x_size/LONG(red_factor)
red_y_size = y_size/LONG(red_factor)

IF (red_x_size NE x_size/FLOAT(red_factor)) OR (red_y_size NE y_size/FLOAT(red_factor)) THEN MESSAGE,'Non integer division !'

IF KEYWORD_SET(new) THEN WIN,red_x_size,red_y_size
red = REBIN(image,red_x_size,red_y_size)
PRINT,'Reduced image size [x,y]:',red_x_size,red_y_size

IF KEYWORD_SET(log) THEN BEGIN
 PRINT,'Displaying log of reduced image ... '
 TVSCL,ALOG(red>1) 
ENDIF ELSE BEGIN
 PRINT,'Displaying reduced image ... '
 TVSCL,red
ENDELSE
RETURN,red
ENDELSE

END
