function CHECK_POS,struc,image,par,SHOW=SHOW,miller=miller
;+
; NAME:
;	CHECK_POS
;
; PURPOSE:
;
;	Check the positionnal accuracy of the peaks inside the selected box,
;	by plotting histograms.	
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	pos = CHECK_POS(struc,image,par,/show)
;
; INPUTS:
;	struc : the reflection list (a structure produced with the
;	        program REFLIST to read the content of the CCP4 file
;		"*.geasc". 
;	image : the original data image (usually part of the full data)
;
;	par : the parameters (from reflist.pro)
;	show : keyword set if the histograms are to be displayed
;
; OUTPUTS:
;	pos : the position (x,y) of the maximum in the selected box
;
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
; PROCEDURE:
;	See above
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994.
;-

;position of the beam center on the original Laue image [pixels] 
centerX = par.cenx-1
centerY = par.ceny-1

;pixel size [mm]
  scaleY = par.yscale
;rebinning factor (if a compressed version of the image is used)
  reb = 1; <---- HERE
;original pixel size [micrometers]
 pix_size = par.raster
 pix_sizeX = 0.001*reb*pix_size
 pix_sizeY = 0.001*reb*pix_size/scaleY

;position of the lower left coner of "image" (usually a small portion of the
;	whole data set, relative to the whole data set [pixels]
relX = 0*2; <---- HERE
relY = 0*2; <---- HERE

;box for background
bigbox_size  = {box, x:FIX(par.boxsize.x/2.), y:FIX(par.boxsize.y/2.)}

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;position of the studied area relative to the center of the beam [mm]
minX = pix_sizeX*(relX-centerX+bigbox_size.x+2)
minY = pix_sizeY*(relY-centerY+bigbox_size.y+2)
maxX = pix_sizeX*(relX-centerX+imageX-1-bigbox_size.x-2)
maxY = pix_sizeY*(relY-centerY+imageY-1-bigbox_size.y-2)

;create a reduced structure array which contains only the spots of interest
;  The criteria of selection is that the position of the spot be inside
;  the box defined by minX, maxX, minY and maxY
spots = struc(WHERE((struc(*).x GE minX) AND $
		    (struc(*).x LE maxX) AND $
		    (struc(*).y GE minY) AND $
		    (struc(*).y LE maxY)))

PRINT,'Number of input spots : ',(SIZE(struc))(1)
PRINT,'Number of spots selected : ',(SIZE(spots))(1)

;sort the reflections in "spots" according to resolution sphere
PRINT,'Sorting the spots according to resolution'
spots = spots(REVERSE(SORT(spots.res)))

pos=INTARR(2,(SIZE(spots))(1))

cr = STRING("15b)

;tottime=SYSTIME(1)
FOR i=LONG(0),(SIZE(spots))(1)-1 DO BEGIN

IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)",i,100.*i/FLOAT((SIZE(spots))(1)),cr

 ;get the position in pixels
 ;in denzo we have to use FIX, not ROUND, but this has no justification, it's just experimental
 ;by plotting an histogram of the position of the maximum in the box with round or fix.

 ;xpos = ROUND(spots(i).x/pix_sizeX+centerX-relX)
 ;ypos = ROUND(spots(i).y/pix_sizeY+centerY-relY)

  xpos = FIX(spots(i).x/pix_sizeX+centerX-relX)
  ypos = FIX(spots(i).y/pix_sizeY+centerY-relY)

;get the big box around the pixel
 bigbox = image(xpos-FIX(par.boxsize.x/2.):xpos+FIX(par.boxsize.x/2.),ypos-FIX(par.boxsize.y/2.):ypos+FIX(par.boxsize.y/2.))

 w=WHERE(bigbox EQ MAX(bigbox))
 p=WHERESUB(w,bigbox)
 pos(0,i)=FLOAT(p(0))
 pos(1,i)=IMAGINARY(p(0))


IF N_ELEMENTS(miller) GT 0 THEN BEGIN
m0=miller(0)
m1=miller(1)
m2=miller(2)
IF ((spots(i).m(0) EQ m0) AND (spots(i).m(1) EQ m1) AND (spots(i).m(2) EQ m2)) THEN BEGIN
 background =  BACK2D_POLY4(bigbox,par.noise_percentage,par.bg_gain,par.dark_current,flag,coeff,bc_mean,n_back,chi_square,max_cycle=10)
 spot=bigbox-background
 SURFACE,spot
 PRINT,'Total in spot is : ', TOTAL(spot)
 RETURN,spot
ENDIF
ENDIF


ENDFOR

IF KEYWORD_SET(show) THEN BEGIN
 !P.MULTI = [0,1,2,0,0]
 PLOT,HISTOGRAM(pos(0,*))
 PLOT,HISTOGRAM(pos(1,*))
 !P.MULTI = [0,1,1,0,0]
ENDIF
RETURN,pos
END
