function STR_REPLACE,s1,s2,s3,NO_COMPRESS=no_compress
;+
; NAME:
;	STR_REPLACE
;
; PURPOSE:
;	In s1, replaces string s2 by s3
;
; CATEGORY:
;	String processing
;
; CALLING SEQUENCE:
;	s4=STR_REPLACE(s1,s2,s3,[/NO_COMPRESS])
;
; INPUTS:
;	s1,s2,s3 are strings
;	no_compress : use if no string compression to remove blanks.
;
; OUTPUTS:
;	s4 : the string s1 where s2 has been replaced by s3. If
;	     s2 is not present in s1, the null string is returned
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;search s2 in s1
p2=STRPOS(s1,s2)
IF p2 EQ -1 THEN RETURN,''
start=STRMID(s1,0,p2)
last=STRMID(s1,p2+STRLEN(s2),STRLEN(s1))
IF NOT KEYWORD_SET(no_compress) THEN $
 RETURN,STRCOMPRESS(start+s3+last,/REMOVE_ALL) $
ELSE $
 RETURN,start+s3+last
END










