PRO PROW_MAR18_EVENT,event


CATCH,error
;error=0
IF error NE 0 THEN BEGIN

 IF NOT N_ELEMENTS(state) THEN WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY 
 draw_image=state.draw_image
 WIDGET_CONTROL,state.info,SET_VALUE='Error ! You can continue working ...'
 ;resensitize PROW widgets 
 print,'Error from MAIN PROGRAM !'
 ok = WIDGET_MESSAGE(['Screw up ! Sorry, something wrong happened (Main menu).','Follows the error message : ',!Err_String],/ERROR)

 WIDGET_CONTROL,state.info,SET_VALUE='Info ...'
 WIDGET_CONTROL,state.prow_base,SENSITIVE=1
 WIDGET_CONTROL,state.draw_image,SENSITIVE=1
 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY 

 IF N_ELEMENTS(image_state) THEN $
  WIDGET_CONTROL, WIDGET_INFO(draw_image,/CHILD), SET_UVALUE=image_state
  event.id=0

ENDIF

parent=event.handler
child=WIDGET_INFO(parent,/CHILD)

;get the state
WIDGET_CONTROL,child,GET_UVALUE=state ,/NO_COPY
;get the state from PROW_DRAW
WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY

CASE event.id OF
	state.but_done: $
	     WIDGET_CONTROL,event.top,/DESTROY
   	
	state.but_load: $
	     BEGIN
		DRAW_LOAD,state,image_state,/PICK
	     END

	state.but_next: $
		BEGIN
		 DRAW_NEXT_IMAGE,state,image_state
		END	

	state.but_prev: $
		BEGIN
		 DRAW_NEXT_IMAGE,state,image_state,/PREV
		END	

	state.but_color: $
	     XLOADCT,GROUP=event.top

	state.but_det: $
		BEGIN
		field={gain:state.det_par.gain,offset:state.det_par.offset,dark_current:state.det_par.dark_current}
		field_title=['Gain [at 1.54 A] : ','Offset [ADU] : ','Dark current [ADU] : ']
		XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action
		IF action EQ 'DO' THEN BEGIN
		 state.det_par.gain=field.gain
		 state.det_par.offset=field.offset
		 state.det_par.dark_current=field.dark_current
		ENDIF
		END	

	state.but_print: BEGIN
		 DRAW_PRINT,state,image_state
			 END

	state.pull_diff: $
	     BEGIN
		DRAW_PULL_DIFF,state,image_state,event
	     END

	state.pull_integ: $
	     BEGIN
		DRAW_PULL_INTEG,state,image_state,event
	     END

	state.field_dir: $
	     BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=working_dir
		state.working_dir=working_dir(0)
	     END

	ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : '
	   
ENDCASE


IF (event.id NE state.but_done) THEN BEGIN
 ;swallow the image_state
 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
 ;swallow the state
 WIDGET_CONTROL,child,SET_UVALUE=state ,/NO_COPY
ENDIF

END

PRO PROW_MAR18,file=file
;
;+
; NAME:
;	PROW_MAR18
;
; PURPOSE:
;	Widget application to study MAR 18 cm images.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	PROW_MAR18,[file=file]
;
; INPUTS:
;	file :[optional][keyword] the filename of a MAR 18 cm image
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;define the SIZE
xsize=1200
ysize=1200
bin_fac=2
x_scroll=500
y_scroll=500

;A main base is defined
prow_base=WIDGET_BASE(/COLUMN,TITLE='PROW (MAR 18 cm)')

;A sub-base1 is defined
prow_subbase1=WIDGET_BASE(prow_base,/ROW)

;A button is defined to load images
but_load=WIDGET_BUTTON(prow_subbase1,value='LOAD FILE')

;A button is defined to load next image
but_next=WIDGET_BUTTON(prow_subbase1,value='NEXT')

;A button is defined to load previous image
but_prev=WIDGET_BUTTON(prow_subbase1,value='PREVIOUS')

;A button is defined to adjust colors
but_color=WIDGET_BUTTON(prow_subbase1,value='COLORS')

;A pull down menu is defined to adjust diffraction parameters
junk={CW_PDMENU_S,flags:0,name:''}
diff_items = [	{CW_PDMENU_S,1,'DIFFRACTION'}, $
		{CW_PDMENU_S,0,'Enter/View diffraction parameters'}, $
		{CW_PDMENU_S,0,'Define beam center with mouse'}, $
		{CW_PDMENU_S,0,'Define beam center from circle'}, $
		{CW_PDMENU_S,0,'Resolution circles On/Off'}, $
		{CW_PDMENU_S,0,'Estimate cell parameters'}, $
		{CW_PDMENU_S,2,'Superimpose several images'} $
        ]
pull_diff = CW_PDMENU(prow_subbase1,diff_items,/RETURN_INDEX)

;A button is defined to define detector parameters
but_det=WIDGET_BUTTON(prow_subbase1,value='DETECTOR PARAMETERS')

;A button is defined to print images
but_print=WIDGET_BUTTON(prow_subbase1,value='PRINT')

;A pull down menu is defined to launch integration
junk={CW_PDMENU_S,flags:0,name:''}
integ_items = [	{CW_PDMENU_S,1,'INTEGRATION'}, $
		{CW_PDMENU_S,1,'Integration parameters'}, $
		{CW_PDMENU_S,0,'Enter/View parameters'}, $
		{CW_PDMENU_S,0,'Save parameters'}, $
		{CW_PDMENU_S,2,'Load parameters'}, $
		{CW_PDMENU_S,1,'Convertion parameters'}, $
		{CW_PDMENU_S,0,'Enter/View parameters'}, $
		{CW_PDMENU_S,0,'Save parameters'}, $
		{CW_PDMENU_S,2,'Load parameters'}, $
		{CW_PDMENU_S,0,'Local refinement'}, $
		{CW_PDMENU_S,0,'Find reference spots'}, $
		{CW_PDMENU_S,0,'Integrate'}, $
		{CW_PDMENU_S,2,'Convert'} $
        ]
pull_integ = CW_PDMENU(prow_subbase1,integ_items,/RETURN_INDEX)

;A button is defined to terminate the program
but_done=WIDGET_BUTTON(prow_subbase1,value='DONE')

;A sub-base2 is defined
prow_subbase2=WIDGET_BASE(prow_base,/ROW)

;A field is defined containing the directory where the images are located
field_dir=CW_FIELD(prow_subbase2,/STRING,VALUE=GETENV('DATA'),TITLE='Data directory',/RETURN_EVENTS)

;A label is defined containing the filename of the current image
field_file=WIDGET_LABEL(prow_subbase2,/ALIGN_LEFT,SCR_YSIZE=35,SCR_XSIZE=350,VALUE='Current image : ')

;A label is defined containing some information
label_info = WIDGET_LABEL(prow_base, VALUE = 'Info : ',/ALIGN_LEFT,YSIZE=20,XSIZE=600)

;A draw CW is defined where the image is displayed and analysed.
draw_image = PROW_DRAW(prow_base,xsize=xsize/bin_fac,ysize=ysize/bin_fac,bin_fac=bin_fac,x_scroll_size=x_scroll,y_scroll_size=y_scroll)

;Visualize the application
WIDGET_CONTROL,prow_base,/REALIZE      

;Define the state
state=	{	but_done:but_done,$
		but_load:but_load,$
		but_next:but_next,$
		but_prev:but_prev,$
		but_print:but_print,$
		but_color:but_color,$
		pull_diff:pull_diff,$
		pull_integ:pull_integ,$
		but_det:but_det,$
		image_type:'denzo_mar',$
		diff_par:{distance:100.,cenx:xsize/2.,ceny:xsize/2.,raster:150.,lambda:1.54},$
		diff_integ:{	$
			logdir		: GETENV('DATA'), $
			logfile		: 'test.log', $
			denzo_format	: 'york', $
			xdir		: GETENV('DATA'), $
			xfile		: 'test_###.x', $
			loc_refine	: 1, $
			prowdir		: GETENV('DATA'), $
			prowfile	: 'test_###.prow', $	
			reffile		: 'test_###.ref', $	
			datadir		:  GETENV('DATA'), $
			datafile	: 'test_###.image', $
			first		: 1 , $
			last		: 1 , $
			skip		: 0 , $
			data_skipped	: [1] , $
			detector	: 'small_mar', $
			res_lim		: '30 2',  $
			xsize		: 2000 , $
			ysize		: 2000 , $
			raster		: 150  , $
			set_bsmask	: 0, $
			bs_maskfile	: STRTRIM(GETENV('DATA')+'bs_mask.idl'), $
			set_mask	: 0, $
			maskfile	: STRTRIM(GETENV('DATA')+'mask.idl'), $
			boxsize		: {x:17,y:17}, $
			set_region	: 0, $
			regionfile	: STRTRIM(GETENV('DATA')+'region.idl'), $
			use_old_ref	: 0 , $
			second_interp	: 0 , $
			ovlp_dist	: 1.0  , $
			ovlp_min_dist	: 0.25 , $
			ovlp_ref_dist	: 1.2  , $
			satvalue	: 65534L , $
			det_offset	: 0 , $
			det_gain	: 1.2 , $
			bg_percentage	: 25 , $
			max_ref_spots	: 200 , $
			min_ref_spots	: 50 , $
			min_isigi	: 3.0 , $
			use_partials	: 1 , $
			max_osc_distance: 0 , $	
			rad_distance	: 50 , $
			ang_width	: 30 , $
			sym_search	: 1 , $
			show_image	: 1 , $
			show_ref	: 0 , $
			show_strong	: 0 , $
			show_weak	: 0 , $
			show_ovlp	: 0 , $
			show_m		: 0 , $
			miller		: '1 1 1'  $
			   },	$
		diff_denzox:{	$
			logdir		: GETENV('PRED'), $
			logfile		: 'denzox.log', $
			xdir		: GETENV('PRED'), $
			xfile		: 'test_###.x', $
			outxdir		: GETENV('PRED'), $
			outxfile	: 'test_prow_###.x', $
			denzo_format	: 'york', $
			prowdir		: GETENV('PRED'), $
			prowfile	: 'test_###.prow', $	
			first		: 1 , $
			last		: 1 , $
			skip		: 0 , $
			data_skipped	: [1] , $
			combine		: 1, $
			rm_ovlp		: 0, $
			rm_largerms	: 0, $
			rm_outliers	: 0, $
			keep_lowres	: 3., $
			scaledown	: 0., $
			set_zero	: 0, $
			set_neg_thres	: -5000, $
			save_limited	: 0, $
			rmin		: 0., $
			rmax		: 10000. $
			   },	$
		integ:{file:GETENV('PRED')},$
		denzox:{file:GETENV('PRED')},$
		det_par:{gain:2.,offset:0,dark_current:0},$
		info:label_info,$
		prow_base:prow_base,$
		field_dir:field_dir,$
		field_file:field_file,$
		res_circles:0,$  ;0 is off
		draw_image:draw_image,$
		print:{file:STRCOMPRESS(GETENV('HOME')+'/tmp/tmp.ps',/REMOVE_ALL)},$
		file:{current:'',generic:'###',first:0,last:0},$
		working_dir:GETENV('DATA') $
	}

;An image file can be entered directly
IF KEYWORD_SET(file) THEN BEGIN
	dummy=FINDFILE(file,COUNT=ct_file)
	IF ct_file EQ 0 THEN  WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...' ELSE $
	  BEGIN
		WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
		state.file.current=file
		DRAW_LOAD,state,image_state
		WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
	  ENDELSE
ENDIF

;Put the state in the user value of the first child
WIDGET_CONTROL, WIDGET_INFO(prow_base, /CHILD), SET_UVALUE=state, /NO_COPY

;And start Xmanager.
XMANAGER,'prow_mar18',prow_base

END


