; $Id: prow_draw.pro,v 1.5 1994/11/23 20:37:25 alan Exp $

; Copyright (c) 1992-1993, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PROW_DRAW
;
; PURPOSE:
;	This compound widget displays two images: an original image
;	in one window and a portion of the original image in another.
;	The user may select the center of the zoom region, the zoom scale,
;	the interpolation style, and the method of indicating the zoom center.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;	Widget = PROW_DRAW(Parent)
;
; INPUTS:
;       Parent:	 The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	FRAME:	 If set, a frame will be drawn around the widget. The
;		 default is FRAME=0 (no frame).
;	MAX:	 The maximum zoom scale, which must be greater than
;		 or equal to 1. The default = 20.
;	MIN:	 The minimum zoom scale, which must be greater than
;		 or equal to 1. The default = 1.
;	RETAIN:	 Controls the setting for backing store for both windows.
;		 If backing store is provided, a window which was obscured
;		 will be redrawn when it becomes exposed. Set RETAIN=0 for
;		 no backing store. Set RETAIN=1 to "request backing store
;		 from server" (this is the default). Set RETAIN=2 for IDL
;		 to provide backing store.
;	SAMPLE:	 Set to zero for bilinear interpolation, or to a non-zero
;		 value for nearest neighbor interpolation. Bilinear
;		 interpolation gives higher quality results, but requires
;		 more time. The default is SAMPLE=0 (bilinear interpolation).
;	SCALE:	 The initial integer scale factor to use for the zoomed image.
;		 The default is SCALE=1. The scale must be greater than or
;		 equal to 1.
;	TRACK:	 Set to zero if the zoom window should be updated only when
;		 the mouse button is pressed. Set to a non-zero value if the
;		 zoom window should be updated continuously as the cursor
;		 is moved across the original image. Note: On slow systems,
;		 /TRACK performance can be inadequate. The default is TRACK=0.
;	UVALUE:	 The user value for the widget.
;	XSIZE:	 The width of the window (in pixels) for the original image.
;		 The default is 500.
;	YSIZE:	 The height of the window (in pixels) for the original image.
;		 The default is 500.
;	X_SCROLL_SIZE: The width of the visible part of the original image.
;		       This may be smaller than the actual width controlled
;		       by the XSIZE keyword. The default is 0, for no
;		       scroll bar.
;	Y_SCROLL_SIZE: The height of the visible part of the original image.
;		       This may be smaller than the actual height controlled
;		       by the YSIZE keyword. The default is 0, for no
;		       scroll bar.
;	X_ZSIZE: The width of the window for the zoomed image.
;		 The default is 250.
;	Y_ZSIZE: The height of the window for the zoomed image.
;		 The default is 250.
;	X_STSIZE: The width of the window for the study window.
;		 The default is 250.
;	Y_STSIZE: The height of the window for the study window.
;		 The default is 250.
;
; OUTPUTS:
;       The ID of the created widget is returned.
;
; SIDE EFFECTS:
;
;
; PROCEDURE:
;	WIDGET_CONTROL, id, SET_VALUE=value can be used to change the
;		original, unzoomed image displayed by the widget.
;		The value may not be set until the widget has been
;		realized.
;
;	WIDGET_CONTROL, id, GET_VALUE=var can be used to obtain the current
;		zoomed image displayed by the widget.
;
; MODIFICATION HISTORY:
;	June 30, 1992, ACY
;       7 April 1993, AB, Removed state caching.
;	13 June, 1994, ACY, Save window and set to zoom prior to erase
;			    Add byte conversion in set_value
;	23 November, 1994, ACY, add code to handle cases in which the
;			set_value image is larger or smaller than the
;			original image.  Also remove scaling on display
;			operation (only scale the image when it is set.)
;-

;-----------------------------------------------------------------------------

PRO zoom_set_value, id ,value

  COMMON SHARE_PROW,pred,sel_pred,par
;  ON_ERROR, 2						;return to caller
  ; Retrieve the state

  grand_parent = WIDGET_INFO(id,/PARENT)
  child = WIDGET_INFO(id, /CHILD)
  WIDGET_CONTROL, WIDGET_INFO(grand_parent, /CHILD), GET_UVALUE=main_state
  WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
  state.info=main_state.info

  ; Get the window number from the draw widget.  This can only be done
  ; after the widget has been realized.
  WIDGET_CONTROL, state.draw, GET_VALUE=win_temp
  state.draw_win = win_temp(0)
  ;make pixmap windows to keep information
  WSET,state.draw_win
  WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
  state.draw_back_win1 = !D.WINDOW
  WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
  state.draw_back_win2 = !D.WINDOW

  WIDGET_CONTROL, state.study, GET_VALUE=win_temp
  state.study_win = win_temp(0)
  WIDGET_CONTROL, state.zoom, GET_VALUE=win_temp
  state.zoom_win = win_temp(0)
  ;make pixmap windows to keep information
  WSET,state.zoom_win
  WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
  state.zoom_back_win1 = !D.WINDOW
  WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
  state.zoom_back_win2 = !D.WINDOW



  ;remove resolution circles if present
  IF main_state.res_circles THEN BEGIN
   DRAW_RES_CIRCLES,main_state,state ;erase
   main_state.res_circles=1
  ENDIF

  ; Use TVSCL to display an image in the draw widget.  Set the window for
  ; the TVSCL command since there may be other draw windows.
  ;Save window number
  save_win = !D.WINDOW
  WSET, state.draw_win

  ;get min and max values
  tmp_max=MAX(*state.orig_image,MIN=tmp_min)
  state.min=tmp_min & state.max=tmp_max

  IF state.log_status THEN $
   TVSCL, ALOG(REBIN((*state.orig_image)<main_state.det_par.satvalue,state.x_im_sz/state.bin_fac,state.y_im_sz/state.bin_fac)>1),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue)) $
  ELSE TVSCL, REBIN((*state.orig_image)<main_state.det_par.satvalue,state.x_im_sz/state.bin_fac,state.y_im_sz/state.bin_fac),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue))

  ;remove old rectangle on draw_win
  t1=LONARR(1,2) & t2=LONARR(1,2) & t3=LONARR(1,2) & t4=LONARR(1,2)
  DEVICE, SET_GRAPHICS=6  
  col = 1
  WHILE col lt !d.table_size do col = col + col
  t1(0,*) = LONG([state.x0,state.y0]/FLOAT(state.bin_fac))
  t2(0,*) = LONG([state.x0,state.y1]/FLOAT(state.bin_fac))
  t3(0,*) = LONG([state.x1,state.y1]/FLOAT(state.bin_fac))
  t4(0,*) = LONG([state.x1,state.y0]/FLOAT(state.bin_fac))
  WSET,state.draw_win
  PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
  DEVICE, SET_GRAPHICS=3

  WSET,state.draw_back_win1
  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]  ; Put Original image in draw_win1
  ;Restore window
  IF (save_win NE -1) THEN WSET, save_win

 ;Handle preds if present
 IF state.pred.loaded THEN BEGIN ; if preds loaded
  WSET,state.draw_back_win2
  ;make a copy in draw_back_win2
  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]
  ;redraw the preds
  dummy=DRAW_PRED(sel_pred,state.x_im_sz,state.y_im_sz,state.bin_fac,par,0,0,main_state,DRAW=state.boxinteg.boxsize)  ;redraw it 
  IF state.pred.status THEN BEGIN
   WSET,state.draw_win
   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win2]
  ENDIF
 ENDIF ; preds are loaded

  ;redraw resolution circles if present
  IF main_state.res_circles THEN BEGIN
   DRAW_RES_CIRCLES,main_state,state ;erase
   main_state.res_circles=1
  ENDIF


  IF state.draw_win NE -1 THEN DRAW_ZOOM, state, state.oldx, state.oldy,main_state

  WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY

END

;-----------------------------------------------------------------------------

FUNCTION zoom_get_value, id

  ON_ERROR, 2                                           ;return to caller

  ; Retrieve the state
  child = WIDGET_INFO(id, /CHILD)
  WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY

  ; Get the value from the state structure
  ret = *state.zoom_image

  WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
  RETURN, ret
END

;-----------------------------------------------------------------------------

PRO draw_zoom, state, newx, newy, main_state
  COMMON SHARE_PROW,pred,sel_pred,par

  ; remove old rectangle on draw_win
    t1=LONARR(1,2) & t2=LONARR(1,2) & t3=LONARR(1,2) & t4=LONARR(1,2)
    DEVICE, SET_GRAPHICS=6  
    col = 1
    WHILE col lt !d.table_size do col = col + col
    t1(0,*) = LONG([state.x0,state.y0]/FLOAT(state.bin_fac))
    t2(0,*) = LONG([state.x0,state.y1]/FLOAT(state.bin_fac))
    t3(0,*) = LONG([state.x1,state.y1]/FLOAT(state.bin_fac))
    t4(0,*) = LONG([state.x1,state.y0]/FLOAT(state.bin_fac))
    WSET,state.draw_win
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win1
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win2
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    DEVICE, SET_GRAPHICS=3

  ; compute size of rectangle in original image
  ; round up to make sure image fills zoom window

  rect_x = long(state.x_zm_sz / float(state.scale) + 0.999)
  rect_y = long(state.y_zm_sz / float(state.scale) + 0.999)

  ; compute location of origin of rect (user specified center)
  x0 = newx - rect_x/2
  y0 = newy - rect_y/2

  ; make sure rectangle fits into original image
  ;left edge from center
  x0 = x0 > 0
  ; limit right position
  x0 = x0 < (state.x_im_sz - rect_x)

  ;bottom
  y0 = y0 > 0
  y0 = y0 < (state.y_im_sz - rect_y)

  IF (state.scale EQ 1) THEN BEGIN
    ;Save window number
    save_win = !D.WINDOW
    WSET, state.zoom_win
    IF (rect_x GT state.x_im_sz OR rect_y GT state.y_im_sz) THEN BEGIN
      ERASE
      IF (rect_x GT state.x_im_sz) THEN x0 = 0 & rect_x = state.x_im_sz
      IF (rect_y GT state.x_im_sz) THEN y0 = 0 & rect_y = state.y_im_sz
    ENDIF

    x1=x0+rect_x-1 & y1=y0+rect_y-1
    (*state.zoom_image) = (*state.orig_image)(x0:x1,y0:y1)
    IF state.log_status THEN $
;     TVSCL, ALOG((*state.zoom_image)>1)
     TV, BYTSCL(ALOG(((*state.zoom_image)<main_state.det_par.satvalue)>1),MIN=ALOG(state.min>1),MAX=ALOG(main_state.det_par.satvalue>1),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue))) $
    ELSE $ 
     TV, BYTSCL((*state.zoom_image)<main_state.det_par.satvalue,MIN=state.min,MAX=main_state.det_par.satvalue,TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue)))
;    ELSE TVSCL, *state.zoom_image

   ;draw zoom rectangle on draw_win
    DEVICE, SET_GRAPHICS=6  
    col = 1
    WHILE col lt !d.table_size do col = col + col
    t1(0,*) = LONG([x0,y0]/FLOAT(state.bin_fac))
    t2(0,*) = LONG([x0,y1]/FLOAT(state.bin_fac))
    t3(0,*) = LONG([x1,y1]/FLOAT(state.bin_fac))
    t4(0,*) = LONG([x1,y0]/FLOAT(state.bin_fac))
    WSET,state.draw_win 
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win1
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win2
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    DEVICE, SET_GRAPHICS=3

    ;make a copy in zoom_back_win1
    WSET,state.zoom_back_win1
    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]  ; Put Original image in zoom_win1


    ;Restore window
    IF (save_win NE -1) THEN WSET, save_win

    ;Save the lower corner in original image
    state.x0 = x0
    state.y0 = y0
    state.x1 = x1
    state.y1 = y1

  ENDIF ELSE BEGIN
    ;Make integer rebin factors.  These may be larger than the zoom image
    dim_x = rect_x * state.scale
    dim_y = rect_y * state.scale

    x1 = x0 + rect_x - 1
    y1 = y0 + rect_y - 1

    temp_image = rebin((*state.orig_image)(x0:x1,y0:y1), $
                       dim_x, dim_y, $
                       sample=state.sample)

    ;Save the zoomed image
    *state.zoom_image = $
                     temp_image(0:state.x_zm_sz-1,0:state.y_zm_sz-1)

    ;Save the corners in original image
    state.x0 = x0
    state.y0 = y0
    state.x1 = x1
    state.y1 = y1

    ;Display the new zoomed image
    ;Save window number
    save_win = !D.WINDOW
    WSET, state.zoom_win
    ; don't use tvscl here, to preserve same range as in unzoomed image

    IF state.log_status THEN $
     TV, BYTSCL(ALOG(((*state.zoom_image))<main_state.det_par.satvalue>1),MIN=ALOG(state.min>1),MAX=ALOG(main_state.det_par.satvalue>1),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue))) $ 
    ELSE TV, BYTSCL((*state.zoom_image)<main_state.det_par.satvalue,MIN=state.min,MAX=main_state.det_par.satvalue,TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue)))

    ;Draw zoom rectangle on draw_win
    DEVICE, SET_GRAPHICS=6  
    col = 1
    WHILE col lt !d.table_size do col = col + col
    t1(0,*) = LONG([x0,y0]/FLOAT(state.bin_fac))
    t2(0,*) = LONG([x0,y1]/FLOAT(state.bin_fac))
    t3(0,*) = LONG([x1,y1]/FLOAT(state.bin_fac))
    t4(0,*) = LONG([x1,y0]/FLOAT(state.bin_fac))
    WSET,state.draw_win 
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win1
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    WSET,state.draw_back_win2
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    DEVICE, SET_GRAPHICS=3

    ;make a copy in zoom_back_win1
    WSET,state.zoom_back_win1
    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]  ; Put Original image in zoom_win1

    ;Restore window
    IF (save_win NE -1) THEN WSET, save_win

 ENDELSE

 ;Handle preds if present
 IF state.pred.loaded THEN BEGIN ; if preds loaded
  WSET,state.zoom_back_win2
  ;make a copy in zoom_back_win2
  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]
  ;redraw the preds
  dummy=DRAW_PRED(sel_pred,state.x_zm_sz,state.y_zm_sz,1./state.scale,par,state.x0,state.y0,main_state,DRAW=state.boxinteg.boxsize)  ;redraw it 
  IF state.pred.status THEN BEGIN
   WSET,state.zoom_win
   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win2]
  ENDIF
 ENDIF ; preds are loaded


END


;-----------------------------------------------------------------------------

FUNCTION zoom_event, event

  ; get the common variables about preds
  COMMON SHARE_PROW,pred,sel_pred,par

  ; Retrieve the structure from the childs that contains the states.

  parent=event.handler
  grand_parent = WIDGET_INFO(parent,/PARENT)
  child = WIDGET_INFO(parent, /CHILD)

  CATCH,error
  ;error=0
  IF error NE 0 THEN BEGIN
   CATCH,/CANCEL
   PRINT,'Error from PROW_DRAW !'
   ok = WIDGET_MESSAGE(['Screw up ! Sorry, something wrong happened.','Follows the error message : ',!Err_String],/ERROR)
   IF N_ELEMENTS(main_state) THEN $
    WIDGET_CONTROL, WIDGET_INFO(grand_parent, /CHILD), SET_UVALUE=main_state
   IF N_ELEMENTS(state) THEN BEGIN
    WIDGET_CONTROL,state.info,SET_VALUE='Error ! You can continue working ...'
    WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY 
   ENDIF ELSE BEGIN
    WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY 
    WIDGET_CONTROL,state.info,SET_VALUE='Error ! You can continue working ...'
    WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY 
   ENDELSE
   event.id=0
  ENDIF

  WIDGET_CONTROL, WIDGET_INFO(grand_parent, /CHILD), GET_UVALUE=main_state
  WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
  state.info=main_state.info

  CASE event.id OF
    state.draw: $
	BEGIN
	 x=state.bin_fac*event.x < (state.x_im_sz-1)
	 y=state.bin_fac*event.y < (state.y_im_sz-1)
	 z=(*state.orig_image)(x,y)
         r=main_state.diff_par.raster*0.001*SQRT((x-main_state.diff_par.cenx)^2+(y-main_state.diff_par.ceny)^2)>0.001
         res=main_state.diff_par.lambda/(2*SIN(0.5*ATAN(r/main_state.diff_par.distance)))
	 WIDGET_CONTROL, state.xyz_show, SET_VALUE=STRING(x,y,z,res, FORMAT='("X:",i5," Y:",i5," Z:",i7," res:",f7.2)')
         IF state.track GT 0 OR event.press EQ 1 THEN BEGIN
          state.oldx = x
          state.oldy = y
          IF state.draw_win NE -1 THEN draw_zoom, state, state.oldx, state.oldy,main_state
         ENDIF
	END
    state.zoom: $
	BEGIN
         x=(state.x0+ FIX(event.x/state.scale)) < (state.x_im_sz-1)
	 y=(state.y0+ FIX(event.y/state.scale)) < (state.y_im_sz-1)
	 z=(*state.orig_image)(x,y)
         r=main_state.diff_par.raster*0.001*SQRT((x-main_state.diff_par.cenx)^2+(y-main_state.diff_par.ceny)^2)>0.001
         res=main_state.diff_par.lambda/(2*SIN(0.5*ATAN(r/main_state.diff_par.distance)))
	 WIDGET_CONTROL, state.xyz_show, SET_VALUE=STRING(x,y,z,res, FORMAT='("X:",i5," Y:",i5," Z:",i7," res:",f7.2)')
         IF event.press EQ 1 THEN BEGIN
          state.oldx = x
          state.oldy = y
          IF state.draw_win NE -1 THEN draw_zoom, state, state.oldx, state.oldy,main_state
         ENDIF
	END
    state.slide: $
       BEGIN
          WIDGET_CONTROL, event.id, GET_VALUE = temp_scale
          IF (temp_scale LT 1) THEN temp_scale = 1
          state.scale = temp_scale
          IF state.draw_win NE -1 THEN draw_zoom, state, state.oldx, state.oldy,main_state
       END

    state.pull: $
       BEGIN
	DRAW_PULL_ANALYSIS,state,main_state,event
       END

    state.but_log: $
	IF state.draw_win NE -1 THEN BEGIN
	  WIDGET_CONTROL,state.info,SET_VALUE='Info : Changing Logarithmic scaling ...'
         IF state.log_status EQ 0 THEN BEGIN
	  PRINT,'Going to Logarithmic scaling...'

	  ;remove resolution circles if present
	  IF main_state.res_circles THEN BEGIN
	  DRAW_RES_CIRCLES,main_state,state ;erase
	  main_state.res_circles=1
	  ENDIF

	  ;display with log scale
	  WSET,state.draw_win
	  TVSCL, ALOG(REBIN((*state.orig_image)<main_state.det_par.satvalue,state.x_im_sz/state.bin_fac,state.y_im_sz/state.bin_fac)>1), TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue))

    ; redraw zoom rectangle on draw_win
    t1=LONARR(1,2) & t2=LONARR(1,2) & t3=LONARR(1,2) & t4=LONARR(1,2)
    WSET,state.draw_win
    DEVICE, SET_GRAPHICS=6  
    col = 1
    WHILE col lt !d.table_size do col = col + col
    t1(0,*) = LONG([state.x0,state.y0]/FLOAT(state.bin_fac))
    t2(0,*) = LONG([state.x0,state.y1]/FLOAT(state.bin_fac))
    t3(0,*) = LONG([state.x1,state.y1]/FLOAT(state.bin_fac))
    t4(0,*) = LONG([state.x1,state.y0]/FLOAT(state.bin_fac))
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    DEVICE, SET_GRAPHICS=3

	  ;put a copy in draw_back_win1
	  WSET,state.draw_back_win1
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]

	  WSET,state.zoom_win
	  TV, BYTSCL(ALOG((*state.zoom_image)<main_state.det_par.satvalue>1),MIN=ALOG(state.min>1),MAX=ALOG(main_state.det_par.satvalue>1),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue)))
	  ;put a copy in zoom_back_win1
	  WSET,state.zoom_back_win1
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]

	  ;Handle preds if present
	  IF state.pred.loaded THEN BEGIN ; if preds loaded
	   ;put a copy in draw_back_win2
	   WSET,state.draw_back_win2
	   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]
	   ;put a copy in zoom_back_win2
	   WSET,state.zoom_back_win2
	   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]
	   ;and redraw the preds
	   WSET,state.draw_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_im_sz/FLOAT(state.bin_fac),state.y_im_sz/FLOAT(state.bin_fac),state.bin_fac,par,0,0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	   WSET,state.zoom_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_zm_sz,state.y_zm_sz,1./state.scale,par,state.x0,state.y0,main_state,DRAW=state.boxinteg.boxsize)  ;redraw it 
 	   IF state.pred.status THEN BEGIN
	    WSET,state.draw_win
	    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win2]
	    WSET,state.zoom_win
	    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win2]
	   ENDIF
	  ENDIF ; preds are loaded

 
	  ;redraw resolution circles if present
	  IF main_state.res_circles THEN BEGIN
	   DRAW_RES_CIRCLES,main_state,state ;erase
	   main_state.res_circles=1
    	  ENDIF

	  ;display message
	  WIDGET_CONTROL,state.but_log,SET_VALUE='Toggle Logarithmic Display (Now On)'	 

	 ENDIF ELSE BEGIN
	  PRINT,'Going to Linear scaling ...'

	  ;remove resolution circles if present
	  IF main_state.res_circles THEN BEGIN
	  DRAW_RES_CIRCLES,main_state,state ;erase
	  main_state.res_circles=1
	  ENDIF

	  WSET,state.draw_win
	  TVSCL, REBIN((*state.orig_image)<main_state.det_par.satvalue,state.x_im_sz/state.bin_fac,state.y_im_sz/state.bin_fac),TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue))

  ; redraw zoom rectangle on draw_win
    t1=LONARR(1,2) & t2=LONARR(1,2) & t3=LONARR(1,2) & t4=LONARR(1,2)
    WSET,state.draw_win
    DEVICE, SET_GRAPHICS=6  
    col = 1
    WHILE col lt !d.table_size do col = col + col
    t1(0,*) = LONG([state.x0,state.y0]/FLOAT(state.bin_fac))
    t2(0,*) = LONG([state.x0,state.y1]/FLOAT(state.bin_fac))
    t3(0,*) = LONG([state.x1,state.y1]/FLOAT(state.bin_fac))
    t4(0,*) = LONG([state.x1,state.y0]/FLOAT(state.bin_fac))
    PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
    DEVICE, SET_GRAPHICS=3

	  ;put a copy in draw_back_win1
	  WSET,state.draw_back_win1
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]

	  WSET,state.zoom_win
	  TV, BYTSCL((*state.zoom_image)<main_state.det_par.satvalue,MIN=state.min,MAX=main_state.det_par.satvalue,TOP=(!D.N_COLORS - 3*(state.max LT main_state.det_par.satvalue)))
	  ;put a copy in zoom_back_win1
	  WSET,state.zoom_back_win1
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]
	 
	  ;Handle preds if present
	  IF state.pred.loaded THEN BEGIN ; if preds loaded
	   ;put a copy in draw_back_win2
	   WSET,state.draw_back_win2
	   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]
	   ;put a copy in zoom_back_win2
	   WSET,state.zoom_back_win2
	   DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]
	   ;and redraw the preds
	   WSET,state.draw_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_im_sz/FLOAT(state.bin_fac),state.y_im_sz/FLOAT(state.bin_fac),state.bin_fac,par,0,0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	   WSET,state.zoom_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_zm_sz,state.y_zm_sz,1./state.scale,par,state.x0,state.y0,main_state,DRAW=state.boxinteg.boxsize)  ;redraw it 
 	   IF state.pred.status THEN BEGIN
	    WSET,state.draw_win
	    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win2]
	    WSET,state.zoom_win
	    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win2]
	   ENDIF
	  ENDIF ; preds are loaded

	  ;redraw resolution circles if present
	  IF main_state.res_circles THEN BEGIN
	   DRAW_RES_CIRCLES,main_state,state ;erase
	   main_state.res_circles=1
    	  ENDIF

	  WIDGET_CONTROL,state.but_log,SET_VALUE='Toggle Logarithmic Display (Now Off)'
	 ENDELSE
	 state.log_status = 1-state.log_status
	 WIDGET_CONTROL,state.info,SET_VALUE='Info : '
	END

    state.sample_base: $
       CASE event.value OF
          state.nn_id: BEGIN
			  state.sample = 1
			  IF state.draw_win NE -1 THEN draw_zoom, state, state.oldx, state.oldy,main_state
		       END
          state.bilin_id: BEGIN
                             state.sample = 0
                             IF state.draw_win NE -1 THEN draw_zoom, state, state.oldx, state.oldy,main_state
                	  END
       ENDCASE

    state.track_base: $
       CASE event.value OF
          state.notrack_id:  state.track = 0
          state.track_id:    state.track = 1
       ENDCASE

    ELSE : 
ENDCASE

; Swallow events
WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
WIDGET_CONTROL, WIDGET_INFO(grand_parent, /CHILD), SET_UVALUE=main_state,/NO_COPY

RETURN, 0

END

;-----------------------------------------------------------------------------


FUNCTION PROW_DRAW, parent, $
		FRAME=frame, $
		MAX=max, $
		MIN=min, $
		RETAIN=retain, $
		SAMPLE=sample, $
		SCALE=scale, $
		TRACK=track, $
		UVALUE = uval, $
		XSIZE=xsize, $
		YSIZE=ysize, $
		BIN_FAC=bin_fac, $
		X_SCROLL_SIZE=x_scroll_size, $
		Y_SCROLL_SIZE=y_scroll_size, $
		X_ZSIZE=x_zsize, $
		Y_ZSIZE=y_zsize, $
		X_STSIZE=x_stsize, $
		Y_STSIZE=y_stsize

  IF (N_PARAMS() NE 1) THEN MESSAGE, 'Incorrect number of arguments'



  ON_ERROR, 2						;return to caller

  ; Defaults for keywords
  IF (N_ELEMENTS(frame) EQ 0) THEN frame = 0L
  IF (N_ELEMENTS(max) EQ 0) THEN max = 20L
  IF (N_ELEMENTS(min) EQ 0) THEN min = 1L
  IF (N_ELEMENTS(retain) EQ 0) THEN retain = 2L
  IF (N_ELEMENTS(sample) EQ 0) THEN sample = 0L
  IF (N_ELEMENTS(scale) EQ 0) THEN scale = 1L
  IF (N_ELEMENTS(track) EQ 0) THEN track = 0L
  IF (N_ELEMENTS(uval) EQ 0)  THEN uval = 0L
  IF (N_ELEMENTS(xsize) EQ 0) THEN xsize = 500L
  IF (N_ELEMENTS(ysize) EQ 0) THEN ysize = 500L
  IF (N_ELEMENTS(x_scroll_size) EQ 0) THEN x_scroll_size = 0L
  IF (N_ELEMENTS(y_scroll_size) EQ 0) THEN y_scroll_size = 0L
  IF (N_ELEMENTS(x_zsize) EQ 0) THEN x_zsize = 250L
  IF (N_ELEMENTS(y_zsize) EQ 0) THEN y_zsize = 250L
  IF (N_ELEMENTS(x_stsize) EQ 0) THEN x_stsize = 250L
  IF (N_ELEMENTS(y_stsize) EQ 0) THEN y_stsize = 250L

;Define the main base
  base = WIDGET_BASE(parent, $
			EVENT_FUNC = 'zoom_event', $
			FRAME = frame, $
			FUNC_GET_VALUE='ZOOM_GET_VALUE', $
			PRO_SET_VALUE='ZOOM_SET_VALUE', $
			/ROW, $
			UVALUE = uval)

;Define the left column
  lcol = WIDGET_BASE(base, /COLUMN)

;Define a subbase of lcol
  lr1col = WIDGET_BASE(lcol,/ROW)

 ;some analysis pulldown menu is created
junk={CW_PDMENU_S,flags:0,name:''}
desc1=[	{CW_PDMENU_S,1,'Analysis'}, $
	{CW_PDMENU_S,1,'Profile'}, $
	{CW_PDMENU_S,0,'Set_Fraction'}, $
	{CW_PDMENU_S,2,'Show'}, $
	{CW_PDMENU_S,0,'Zoom_Profile'}, $
	{CW_PDMENU_S,1,'Spot_Shape'}, $
	{CW_PDMENU_S,0,'Parameters'}, $
	{CW_PDMENU_S,2,'Show'}, $
	{CW_PDMENU_S,1,'Statistics'}, $
	{CW_PDMENU_S,0,'On_Zoom_Image'}, $
	{CW_PDMENU_S,2,'On_Full_Image'}, $
	{CW_PDMENU_S,1,'Box_integration'}, $
	{CW_PDMENU_S,0,'Parameters'}, $
	{CW_PDMENU_S,2,'Integrate'}, $
	{CW_PDMENU_S,1,'FWHM'}, $
	{CW_PDMENU_S,0,'Parameters'}, $
	{CW_PDMENU_S,0,'Contours'}, $
	{CW_PDMENU_S,2,'Calculate'}, $
	{CW_PDMENU_S,3,'Predictions'}, $
	{CW_PDMENU_S,0,'Parameters'}, $
	{CW_PDMENU_S,0,'Load'}, $
	{CW_PDMENU_S,0,'Toggle_On_Off'}, $
	{CW_PDMENU_S,2,'Analyse'} $
      ]

pull=CW_PDMENU(lr1col,desc1,/RETURN_FULL_NAME,uvalue=5)

;Define a button to switch between LOG/notLOG display
but_log=WIDGET_BUTTON(lr1col,value='Toggle Logarithmic Display (Now On)')

xyz_show = WIDGET_LABEL(lcol, VALUE='X:    0 Y:    0 Z:     0',/ALIGN_LEFT,XSIZE=500)

  ; A widget called 'draw' is created.
  draw = WIDGET_DRAW(lcol, $
	/BUTTON_EVENTS, $	;generate events when buttons pressed
	/MOTION_EVENTS, $
	/FRAME, $
	RETAIN = retain, $
	XSIZE = xsize, $
	YSIZE = ysize, $
	X_SCROLL_SIZE = x_scroll_size, $
	Y_SCROLL_SIZE = y_scroll_size)


  ;Define a subbase of the left column base
  lcolrow = WIDGET_BASE(lcol, /ROW)

  ; A widget handling the tracking mode is created
  ;make sure track is 0 or 1
  IF (track GT 0) THEN track = 1
  track_base = CW_BGROUP(lcolrow, ['Button Press Only', 'Track Cursor'], $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME, $
		IDS=track_ids, $
		LABEL_TOP = 'Cursor Input Style', $
		/NO_RELEASE, $
		/RETURN_ID, $
		SET_VALUE = track)


  ;make sure sample is 0 or 1
  IF (sample GT 0) THEN sample = 1
  sample_base = CW_BGROUP(lcolrow, ['Bilinear', 'Nearest Neighbor'], $
		/COLUMN, $
		/EXCLUSIVE, $
		/FRAME, $
		IDS=sample_ids, $
		LABEL_TOP = 'Interpolation Style', $
		/NO_RELEASE, $
		/RETURN_ID, $
		SET_VALUE = sample)


  ;Define the right column
  rcol = WIDGET_BASE(base, /COLUMN)

  ;Define a subbase of the right column base
  rcolcol1 = WIDGET_BASE(rcol, /COLUMN)

  ; A label containing a title
  wdrlabel = WIDGET_LABEL(rcolcol1, VALUE = 'STUDY WINDOW',/FRAME)

  ; A draw widget called 'study' is created.
  study = WIDGET_DRAW(rcolcol1, $
        /FRAME, $
	/BUTTON_EVENTS, $	;generate events when buttons pressed
	/MOTION_EVENTS, $	;generate events when mouse moved
        RETAIN = retain, $
        XSIZE = x_stsize, $
        YSIZE = y_stsize)

  ;Define a subbase of the right column base
  rcolcol2 = WIDGET_BASE(rcol, /COLUMN)

  ; A widget called 'zoom' is created.
  zoom = WIDGET_DRAW(rcolcol2, $
        /FRAME, $
	/BUTTON_EVENTS, $	;generate events when buttons pressed
	/MOTION_EVENTS, $	;generate events when mouse moved
        RETAIN = retain, $
        XSIZE = x_zsize, $
        YSIZE = y_zsize)


  IF (min LT 1) THEN min = 1
  IF (max LT 1) THEN max = 1
  slide = WIDGET_SLIDER(rcolcol2, $
                        MINIMUM = min, $
                        MAXIMUM = max, $
                        VALUE = scale, $
                        TITLE = 'Zoom Scale', $
                        /FRAME)

; NOW DEFINE THE STATE

  state = {	orig_image:	PTR_NEW(LONARR(bin_fac*xsize,bin_fac*ysize,/NOZERO)), $
		min:		0L, $
		max:		65535, $
		zoom_image:	PTR_NEW(LONARR(x_zsize,y_zsize,/NOZERO)), $
		base:		base, $
		draw:		draw, $
		study:		study, $
		but_log:	but_log,$
		log_status:	1,$
		info:		0L, $
		pop_info:	0L, $ ;a pop up info widget ID
		zoom:		zoom, $
		slide:		slide, $
		rcol:		rcol, $
		pull:		pull, $
		xyz_show:	xyz_show, $
		sample_base:	sample_base, $
		bilin_id:	sample_ids(0), $
		nn_id:		sample_ids(1), $
		track_base:	track_base, $
		notrack_id:	track_ids(0), $
		track_id:	track_ids(1), $
		draw_win:	-1L, $
		draw_back_win1:	-1L, $
		draw_back_win2:	-1L, $
		zoom_win:	-1L, $
		zoom_back_win1:	-1L, $
		zoom_back_win2:	-1L, $
		study_win:	-1L, $
		x_im_sz:	bin_fac*xsize, $
		y_im_sz:	bin_fac*ysize, $
		swap:		0, $
		n_bytes:	2, $
		offset:		1024L, $
		estimate_box:	{r1:0.,r2:50.,alpha1:0.,alpha2:360.,max_number_ref:50},$
		fwhm:		{fraction:50.,boxsize_x:17,boxsize_y:17},$
		profile:	{fraction:50.},$
		boxinteg:	{boxsize:{x:17,y:17}},$
		spot_shape:	{fraction:100.,boxsize_x:17,boxsize_y:17,bc_sub:0},$
		masking:	{file:STRCOMPRESS(GETENV('DATA')+'/'+'mask.idl',/REMOVE_ALL),regionfile:'region.idl'},$
		pred:		{show_sel:0,hkl_sel:'2h,2k,2l',bad_sel:0,type:0,loaded:0,path:GETENV('DATA'),status:0},$
		retain:		2L, $
		track:		track, $
		scale:		FLOAT(scale), $
		sample:		sample, $
		x_zm_sz:	x_zsize, $
		y_zm_sz:	y_zsize, $
		x_st_sz:	x_stsize, $
		y_st_sz:	y_stsize, $
		oldx:		bin_fac*xsize / 2L, $
		oldy:		bin_fac*ysize / 2L, $
		x0:		0L, $
		y0:		0L, $
		x1:		0L, $
		y1:		0L, $
		bin_fac:	bin_fac $
		}

 WIDGET_CONTROL, WIDGET_INFO(base, /CHILD), SET_UVALUE=state, /NO_COPY
  RETURN, base

END
