function FIND_LONGAXIS,spot,x_max,y_max,w,w1,w2,reb_spot,LEVEL=level,SHOW=show,CONTINUOUS=continuous
;+
; NAME:
;	FIND_LONGAXIS
;
; PURPOSE:
;	Tries to figure out the long axis of a spot
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	length = FIND_LONGAXIS(spot,x_max,y_max,w,w1,w2,LEVEL=level)
;
; INPUTS:
;	spot : the spot (a 2D array)
;	x_max : the x position where to start the search
;	y_max : the y position where to start the search
;	level : [optional] set this keyword to define at which contour
;		level [in %] the axis is to be found. Default = 50%
;	show :  [optional] set this keyword to show the result with 
;		xsurface.
;	continuous :  [optional] set this keyword to use SEARCH2d instead of
;			a simple WHERE command.
;
; OUTPUTS:
;	length : the long axis length [raster]
;	w  : [optional] the indices of the pixels within the contour
;	w1 : [optional] the indice of the first pixel defining the axis
;	w2 : [optional] the indice of the second pixel defining the axis
;	reb_spot : [optional] a (rebinned) version of spot which shows the axis.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, November 1994.
;-

IF NOT KEYWORD_SET(level) THEN level=50

;search for the maximum
IF (NOT N_ELEMENTS(x_max)) OR (NOT N_ELEMENTS(y_max)) THEN BEGIN
 w_max=WHERE(spot EQ MAX(spot))
 w_max=w_max(0)
 c_max=WHERESUB(w_max,spot)
 x_max=c_max(0)
 y_max=c_max(1)
ENDIF 

s=SIZE(spot)
sx=s(1) & sy=s(2)

maxval=spot(x_max,y_max)

;search for the pixels above the threshold

;search for sufficient sampling
reb_fac=0

REPEAT BEGIN
reb_fac=reb_fac+1
reb_spot=REBIN(spot,reb_fac*sx,reb_fac*sy)

IF KEYWORD_SET(continuous)THEN $
 w=SEARCH2D(reb_spot,reb_fac*x_max,reb_fac*y_max,((maxval<reb_spot(reb_fac*x_max,reb_fac*y_max))*level/100)<(maxval<reb_spot(reb_fac*x_max,reb_fac*y_max)),maxval<reb_spot(reb_fac*x_max,reb_fac*y_max)) $
			  ELSE BEGIN
 w=WHERE((reb_spot GE MAX(spot)/100.*level) AND (reb_spot LE MAX(spot)/100.*2*level),ct)
 IF ct EQ 0 THEN  w=WHERE((reb_spot GE MAX(spot)/100.*level),ct)
			  ENDELSE
print,'reb_fac',reb_fac
ENDREP UNTIL ((SIZE(w))(1) GT 25) OR (reb_fac GE 20)

IF (SIZE(w))(1) LE 1 THEN RETURN,0 ;can't do anything !

c=WHERESUB(w,reb_spot)
x=FLOAT(c)
y=IMAGINARY(c)

;compute the autocorrelation matrix of list for the distance :
dist_correl = ((x # REPLICATE(1,N_ELEMENTS(x))) - (REPLICATE(1,N_ELEMENTS(x)) # x))^2 + ((y # REPLICATE(1,N_ELEMENTS(y))) - (REPLICATE(1,N_ELEMENTS(y)) # y))^2

n_try = 0

REPEAT BEGIN
n_try = n_try+1
w_big = WHERE(dist_correl EQ MAX(dist_correl), ct_big)

;the pairs {i,j} are at long distances
i_big = FLOAT(WHERESUB(w_big,dist_correl))
j_big = IMAGINARY(WHERESUB(w_big,dist_correl))

w1=w(i_big(0))
w2=w(j_big(0))

xy=WHERESUB(w1,reb_spot)
x1=xy(0) & y1=xy(1)
xy=WHERESUB(w2,reb_spot)
x2=xy(0) & y2=xy(1)
;compute the distance between (x_max,y_max) and the line joining
;(x1,y1) and (x2,y2)
va=[x2-x1,y2-y1]
vb=[reb_fac*x_max-x1,reb_fac*y_max-y1] 

d=SQRT(TOTAL(vb^2)-TOTAL(va*vb)^2/TOTAL(va^2))

print,'distance : ',d
dist_correl(w_big(0))=0

ENDREP UNTIL (d LE 0.8) OR (n_try GE 20 AND d LE 2) OR (n_try GE 100 AND d LE 100)  



IF KEYWORD_SET(show) THEN BEGIN
 spot2=reb_spot
 spot2(*)=0
 spot2(w(i_big))=1
 spot2(w(j_big))=1
 XSURFACE,spot2
ENDIF

;PRINT,'Long axis length [raster] : ',SQRT(MAX(dist_correl))/reb_fac
RETURN,SQRT(MAX(dist_correl))/reb_fac

END








