function ELLIPSE, x0, y0,r1,r2,alpha, show=show
;+
; NAME:
;	ELLIPSE
;
; PURPOSE:
;	Draw a ellipse around (x0,y0) of short axis r1, longaxis r2, and tilted by alpha
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	ellipse = ELLIPSE(x0,y0,r1,r2,alpha,/show)
;
; INPUTS:
;	x0 : the x coordinate of the ellipse center [raster]
;	y0 : the y coordinate of the ellipse center [raster]
;	r1 : the short axis of the ellipse [raster]
;	r2 : the long axis of the ellipse [raster]
;	alpha : the angle [degree] of tilt relative to horizontal
;	show : set this keyword to plot the ellipse on a window
;
; OUTPUTS:
;	A LONARR(2,50) containing the x and y [raster] values of
;	the ellipse.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1994.
;-


n = 100   ;# of points
a = findgen(n) * (2 * !pi/(n-1))
c0 = TRANSPOSE([[r1 * cos(a)], [r2 * sin(a)]])

;transpose([[x0 + r1 * cos(a)], [y0 + r2 * sin(a)]])

ang=!PI/180.*alpha
rotmat=[[cos(ang),sin(ang)],[-sin(ang),cos(ang)]]
c1=rotmat#c0
c2=c1
c2(0,*)=c1(0,*)+x0
c2(1,*)=c1(1,*)+y0

col = 1
WHILE col lt !d.table_size do col = col + col
IF KEYWORD_SET(show) THEN PLOTS,c2,COLOR=col,/DEVICE

RETURN,c2
END








