pro DRAW_PULL_INTEG,state,image_state,event
;+
; NAME:
;	DRAW_PULL_INTEG
;
; PURPOSE:
;	Manages integration pull down menu.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PULL_INTEG,state,image_state,event
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;	event: the event related to the choice in the pull down menu
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par

IF state.diff_integ.integ_mode EQ 'mono' THEN  mode='mono' ELSE $
 IF state.diff_integ.integ_mode EQ 'laue_hard' THEN mode='laue_hard' ELSE $
  mode='laue_soft'

CASE event.value OF 
 2 : BEGIN ; Change the integration mode to Laue Hard Limits.
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Setting integration mode to Laue (Hard Limits)...'
	state.diff_integ.integ_mode='laue_hard'
	state.diff_denzox.integ_mode='laue_hard'
	state.prow_title=state.prow_version+STRCOMPRESS('('+state.diff_denzox.integ_mode+') ')+STRUPCASE(state.image_type)
	WIDGET_CONTROL,state.prow_base,TLB_SET_TITLE=state.prow_title
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 3 : BEGIN ; Change the integration mode to Laue Soft Limits.
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Setting integration mode to Laue (Soft Limits) ...'
	state.diff_integ.integ_mode='laue_soft'
	state.diff_denzox.integ_mode='laue_soft'
	state.prow_title=state.prow_version+STRCOMPRESS('('+state.diff_denzox.integ_mode+') ')+STRUPCASE(state.image_type)
	WIDGET_CONTROL,state.prow_base,TLB_SET_TITLE=state.prow_title
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 4 : BEGIN ; Change the integration mode to Monochromatic
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Setting integration mode to Monochromatic ...'
	state.diff_integ.integ_mode='mono'
	state.diff_denzox.integ_mode='mono'
	state.prow_title=state.prow_version+STRCOMPRESS('('+state.diff_denzox.integ_mode+') ')+STRUPCASE(state.image_type)
	WIDGET_CONTROL,state.prow_base,TLB_SET_TITLE=state.prow_title
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 6 : BEGIN ; Change the parameters
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Define the integration parameters ...'

	IF mode EQ 'mono' THEN BEGIN
	
 	 field = {						$
		logdir		: state.diff_integ.logdir , 	$
		logfile		: state.diff_integ.logfile , 	$
		denzo_format	: state.diff_integ.denzo_format,$
		xdir		: state.diff_integ.xdir , 	$
		xfile		: state.diff_integ.xfile , 	$
		prowdir		: state.diff_integ.prowdir , 	$
		prowfile	: state.diff_integ.prowfile , 	$
		reffile		: state.diff_integ.reffile , 	$
		datadir		: state.diff_integ.datadir , 	$
		datafile	: state.diff_integ.datafile , 	$
		first		: state.diff_integ.first , 	$
		last		: state.diff_integ.last , 	$
		skip		: state.diff_integ.skip , 	$
		data_skipped	: state.diff_integ.data_skipped,$
		res_lim		: state.diff_integ.res_lim , 	$
		detector	: state.diff_integ.detector , 	$
		satvalue	: state.diff_integ.satvalue , 	$
		det_offset	: state.diff_integ.det_offset , $
		det_gain	: state.diff_integ.det_gain , 	$
		xsize		: state.diff_integ.xsize , 	$
		ysize		: state.diff_integ.ysize , 	$
		raster		: state.diff_integ.raster , 	$
		boxsize_x	: state.diff_integ.boxsize.x , 	$
		boxsize_y	: state.diff_integ.boxsize.y , 	$
		set_region	: state.diff_integ.set_region , $
		regionfile	: state.diff_integ.regionfile , $
		set_bsmask	: state.diff_integ.set_bsmask , $
		bs_maskfile	: state.diff_integ.bs_maskfile , $
		set_mask	: state.diff_integ.set_mask , 	$
		maskfile	: state.diff_integ.maskfile , 	$
		ovlp_dist	: state.diff_integ.ovlp_dist , 	$
		ovlp_min_dist	: state.diff_integ.ovlp_min_dist,$
		ovlp_ref_dist	: state.diff_integ.ovlp_ref_dist,$
		max_osc_distance: state.diff_integ.max_osc_distance,$
		bc_extend	: state.diff_integ.bc_extend , $
 		use_old_ref	: state.diff_integ.use_old_ref , $
		loc_refine	: state.diff_integ.loc_refine , $
 		second_interp	: state.diff_integ.second_interp , $
		bg_percentage	: state.diff_integ.bg_percentage,$
		bg_max_slope	: state.diff_integ.bg_max_slope,$
		max_ref_spots	: state.diff_integ.max_ref_spots,$
		min_ref_spots	: state.diff_integ.min_ref_spots,$
		min_isigi	: state.diff_integ.min_isigi , 	$
		use_partials	: state.diff_integ.use_partials,$
		n_sectors	: state.diff_integ.n_sectors,$
		rad_distance	: state.diff_integ.rad_distance,$
		ang_width	: state.diff_integ.ang_width , 	$
		sym_search	: state.diff_integ.sym_search , $
		show_image	: state.diff_integ.show_image , $
		show_ref	: state.diff_integ.show_ref , 	$
		show_strong	: state.diff_integ.show_strong, $
		show_weak	: state.diff_integ.show_weak , 	$
		show_ovlp	: state.diff_integ.show_ovlp , 	$
		show_m		: state.diff_integ.show_m , 	$
		miller		: state.diff_integ.miller  	$
		}

	field_title=	[					 $
	'Directory for logfile : '				,$
	'Logfile : '						,$
	'Format of DENZO files [''YORK'',''NOYORK''] : '	,$
	'Directory of DENZO files : '				,$
	'Generic DENZO filename : '				,$
	'Directory of PROW files :  '				,$
	'Generic PROW filename : '				,$
	'Generic REF filename : '				,$
	'Directory of DATA files :  '				,$
	'Generic DATA filename : '				,$
	'First image to integrate : '				,$
	'Last image to integrate : '				,$
	'Skip images [1:YES,0:NO] : '				,$	
	'Numbers of skipped images : '				,$	
	'Resolution limits : '					,$	
	'Detector type [''mar18'', ''mar30'', ''mar345'', ''ccd'',''ccd4bytes'',''marccd'',''adscQ4'',''adscQ315'',''raxis'', ''edf''] : ',$	
	'Saturation value of the detector [ADU] : '		,$
	'Offset value of the detector [ADU] : '			,$
	'Gain of the detector [at 1.54 A] : '			,$
	'Xsize of image [raster] : '				,$	
	'Ysize of image [raster] : '				,$	
	'Raster size [microns] : '				,$	
	'Integration boxsize X [raster, odd number ] : '	,$
	'Integration boxsize Y [raster, odd number ] : '	,$
	'Restrain fitting area [1:YES,0:NO] : '	 	,$	
	'Region area filename : '				,$
	'Apply a beamstop mask [1:YES,0:NO] : '			,$	
	'Beamstop mask filename : '				,$
	'Apply a mask [1:YES,0:NO] : '	 			,$	
	'Mask filename : '					,$
	'Overlap distance [mm] : '				,$
	'Maximum distance for overlap deconvolution [mm] : '	,$
	'Overlap distance for selection of reference spots [mm] : ',$
	'Maximum oscillation distance for reference peak search [degree] : '	,$
	'Number of excluded pixels around spot area for background calculation [raster] : ',$
	'Reference spots files already existing ? [1:YES,0:NO] : ',$
	'Local refinement [1:YES,0:NO] : '			,$
	'Reinterpolate according to experimental spot position ? [1:YES,0:NO] : ',$
	'Initial percentage of background pixels in integration box [%] : ',$
	'Maximum acceptable slope for background [counts/pixel] : ',$
	'Maximum number of reference peaks : '			,$
	'Minimum number of reference peaks : '			,$
	'Minimum number I/SIGI for reference peaks : '		,$
	'Allow partials for reference peaks : '			,$
	'Number of sectors for reference peak search : '	,$
	'Radial distance for reference peak search [mm] : '	,$
	'Angular width for reference peak search [degree] : '	,$
	'Search reference peaks in symetrical sector if necessary [1:YES,0:NO] : ',$
	'Show image during integration [1:YES,0:NO] : '		,$
	'Show reference peaks during integration [1:YES,0:NO] : ',$
	'Show strong peaks during integration [1:YES,0:NO] : '	,$
	'Show weak peaks during integration [1:YES,0:NO] : '	,$
	'Show overlapped peaks during integration [1:YES,0:NO] : ',$
	'Show a defined [h,k,l] reflection during integration [1:YES,0:NO] : ',$
	'Reflection to be seen during integration [h,k,l] : ' $
			]


	XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	IF action EQ 'DO' THEN BEGIN

	 IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	  field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	  field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	  field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.datadir,'/') NE (STRLEN(field.datadir)-1) THEN $
	  field.datadir=STRCOMPRESS(field.datadir+'/',/REMOVE_ALL)


 	  state.diff_integ.logdir = field.logdir
	  state.diff_integ.logfile = field.logfile
	  state.diff_integ.denzo_format = field.denzo_format
	  state.diff_integ.xdir = field.xdir
	  state.diff_integ.xfile = field.xfile
	  state.diff_integ.prowdir = field.prowdir
	  state.diff_integ.prowfile = field.prowfile
	  state.diff_integ.reffile = field.reffile
	  state.diff_integ.datadir = field.datadir
	  state.diff_integ.datafile = field.datafile
	  state.diff_integ.first = field.first
	  state.diff_integ.last = field.last
	  state.diff_integ.skip = field.skip
	  state.diff_integ.data_skipped = field.data_skipped
	  state.diff_integ.res_lim = field.res_lim
	  state.diff_integ.detector = field.detector
	  state.diff_integ.satvalue = field.satvalue
	  state.diff_integ.det_offset = field.det_offset
	  state.diff_integ.det_gain = field.det_gain
 	  state.diff_integ.xsize = field.xsize
	  state.diff_integ.ysize = field.ysize 
	  state.diff_integ.raster = field.raster
	  state.diff_integ.boxsize.x = field.boxsize_x
	  state.diff_integ.boxsize.y = field.boxsize_y 
	  state.diff_integ.set_region = field.set_region
	  state.diff_integ.regionfile = field.regionfile
	  state.diff_integ.set_bsmask = field.set_bsmask
	  state.diff_integ.bs_maskfile = field.bs_maskfile
	  state.diff_integ.set_mask = field.set_mask
	  state.diff_integ.maskfile = field.maskfile
	  state.diff_integ.ovlp_dist = field.ovlp_dist
	  state.diff_integ.ovlp_min_dist = field.ovlp_min_dist
	  state.diff_integ.ovlp_ref_dist = field.ovlp_ref_dist
	  state.diff_integ.max_osc_distance = field.max_osc_distance 
	  state.diff_integ.bc_extend = field.bc_extend
	  state.diff_integ.use_old_ref = field.use_old_ref
	  state.diff_integ.loc_refine = field.loc_refine
	  state.diff_integ.second_interp = field.second_interp
	  state.diff_integ.bg_percentage = field.bg_percentage
	  state.diff_integ.bg_max_slope = field.bg_max_slope
	  state.diff_integ.max_ref_spots = field.max_ref_spots
	  state.diff_integ.min_ref_spots = field.min_ref_spots
	  state.diff_integ.min_isigi = field.min_isigi
	  state.diff_integ.use_partials = field.use_partials
	  state.diff_integ.n_sectors = field.n_sectors
	  state.diff_integ.rad_distance = field.rad_distance 
	  state.diff_integ.ang_width = field.ang_width 
	  state.diff_integ.sym_search = field.sym_search
	  state.diff_integ.show_image = field.show_image
	  state.diff_integ.show_ref = field.show_ref
	  state.diff_integ.show_strong = field.show_strong
	  state.diff_integ.show_weak = field.show_weak
	  state.diff_integ.show_ovlp = field.show_ovlp
	  state.diff_integ.show_m = field.show_m 
	  state.diff_integ.miller = field.miller
	 ENDIF
	ENDIF


	IF mode EQ 'laue_hard' THEN BEGIN
	
 	 field = {						$
		logdir		: state.diff_integ.logdir , 	$
		logfile		: state.diff_integ.logfile , 	$
		xdir		: state.diff_integ.xdir , 	$
		xfile		: state.diff_integ.xfile , 	$
		loc_refine	: state.diff_integ.loc_refine , $
		prowdir		: state.diff_integ.prowdir , 	$
		prowfile	: state.diff_integ.prowfile , 	$
		reffile		: state.diff_integ.reffile , 	$
		datadir		: state.diff_integ.datadir , 	$
		datafile	: state.diff_integ.datafile , 	$
		first		: state.diff_integ.first , 	$
		last		: state.diff_integ.last , 	$
		skip		: state.diff_integ.skip , 	$
		data_skipped	: state.diff_integ.data_skipped,$
		detector	: state.diff_integ.detector , 	$
		res_lim		: state.diff_integ.res_lim , 	$
		xsize		: state.diff_integ.xsize , 	$
		ysize		: state.diff_integ.ysize , 	$
		raster		: state.diff_integ.raster , 	$
		set_bsmask	: state.diff_integ.set_bsmask , $
		bs_maskfile	: state.diff_integ.bs_maskfile , $
		set_mask	: state.diff_integ.set_mask , 	$
		maskfile	: state.diff_integ.maskfile , 	$
		boxsize_x	: state.diff_integ.boxsize.x , 	$
		boxsize_y	: state.diff_integ.boxsize.y , 	$
		set_region	: state.diff_integ.set_region , $
		regionfile	: state.diff_integ.regionfile , $
		bc_extend	: state.diff_integ.bc_extend , $
 		use_old_ref	: state.diff_integ.use_old_ref , $
 		second_interp	: state.diff_integ.second_interp , $
		ovlp_dist	: state.diff_integ.ovlp_dist , 	$
		ovlp_min_dist	: state.diff_integ.ovlp_min_dist,$
		ovlp_ref_dist	: state.diff_integ.ovlp_ref_dist,$
		satvalue	: state.diff_integ.satvalue , 	$
		det_offset	: state.diff_integ.det_offset , $
		det_gain	: state.diff_integ.det_gain , 	$
		bg_percentage	: state.diff_integ.bg_percentage,$
		bg_max_slope	: state.diff_integ.bg_max_slope,$
		max_ref_spots	: state.diff_integ.max_ref_spots,$
		min_ref_spots	: state.diff_integ.min_ref_spots,$
		min_isigi	: state.diff_integ.min_isigi , 	$
		max_osc_distance: state.diff_integ.max_osc_distance,$
		n_sectors	: state.diff_integ.n_sectors,$
		rad_distance	: state.diff_integ.rad_distance,$
		ang_width	: state.diff_integ.ang_width , 	$
		sym_search	: state.diff_integ.sym_search , $
		show_image	: state.diff_integ.show_image , $
		show_ref	: state.diff_integ.show_ref , 	$
		show_strong	: state.diff_integ.show_strong, $
		show_weak	: state.diff_integ.show_weak , 	$
		show_ovlp	: state.diff_integ.show_ovlp , 	$
		show_m		: state.diff_integ.show_m , 	$
		miller		: state.diff_integ.miller  	$
		}

	field_title=	[					 $
	'Directory for logfile : '				,$
	'Logfile : '						,$
	'Directory of GEASC files : '				,$
	'Generic GEASC filename : '				,$
	'Local refinement [1:YES,0:NO] : '			,$
	'Directory of PROW files :  '				,$
	'Generic PROW filename : '				,$
	'Generic REF filename : '				,$
	'Directory of DATA files :  '				,$
	'Generic DATA filename : '				,$
	'First image to integrate : '				,$
	'Last image to integrate : '				,$
	'Skip images [1:YES,0:NO] : '				,$	
	'Numbers of skipped images : '				,$	
	'Detector type [''mar18'', ''mar30'', ''mar345'', ''ccd'',''ccd4bytes'',''marccd'',''adscQ4'',''adscQ315'',''raxis'',''edf''] : ',$	
	'Resolution limits : '					,$	
	'Xsize of image [raster] : '				,$	
	'Ysize of image [raster] : '				,$	
	'Raster size [microns] : '				,$	
	'Apply a beamstop mask [1:YES,0:NO] : '			,$	
	'Beamstop mask filename : '				,$
	'Apply a mask [1:YES,0:NO] : '	 			,$	
	'Mask filename : '					,$
	'Integration boxsize X [raster, odd number ] : '	,$
	'Integration boxsize Y [raster, odd number ] : '	,$
	'Restrain fitting area [1:YES,0:NO] : '	 	,$	
	'Region area filename : '				,$
	'Number of excluded pixels around spot area for background calculation [raster] : ',$
	'Reference spots files already existing ? [1:YES,0:NO] : ',$
	'Reinterpolate according to experimental spot position ? [1:YES,0:NO] : ',$
	'Overlap distance [mm] : '				,$
	'Maximum distance for overlap deconvolution [mm] : '	,$
	'Overlap distance for selection of reference spots [mm] : ',$
	'Saturation value of the detector [ADU] : '		,$
	'Offset value of the detector [ADU] : '			,$
	'Gain of the detector [at 1.54 A] : '			,$
	'Initial percentage of background pixels in integration box [%] : ',$
	'Maximum acceptable slope for background [counts/pixel] : ',$
	'Maximum number of reference peaks : '			,$
	'Minimum number of reference peaks : '			,$
	'Minimum number I/SIGI for reference peaks : '		,$
	'Maximum oscillation distance for reference peak search [degree] : '	,$
	'Number of sectors for reference peak search [mm] : '	,$
	'Radial distance for reference peak search [mm] : '	,$
	'Angular width for reference peak search [degree] : '	,$
	'Search reference peaks in symetrical sector if necessary [1:YES,0:NO] : ',$
	'Show image during integration [1:YES,0:NO] : '		,$
	'Show reference peaks during integration [1:YES,0:NO] : ',$
	'Show strong peaks during integration [1:YES,0:NO] : '	,$
	'Show weak peaks during integration [1:YES,0:NO] : '	,$
	'Show overlapped peaks during integration [1:YES,0:NO] : ',$
	'Show a defined [h,k,l] reflection during integration [1:YES,0:NO] : ',$
	'Reflection to be seen during integration [h,k,l] : ' $
			]


	XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	IF action EQ 'DO' THEN BEGIN

	 IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	  field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	  field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	  field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.datadir,'/') NE (STRLEN(field.datadir)-1) THEN $
	  field.datadir=STRCOMPRESS(field.datadir+'/',/REMOVE_ALL)


 	  state.diff_integ.logdir = field.logdir
	  state.diff_integ.logfile = field.logfile
	  state.diff_integ.xdir = field.xdir
	  state.diff_integ.xfile = field.xfile
	  state.diff_integ.loc_refine = field.loc_refine
	  state.diff_integ.prowdir = field.prowdir
	  state.diff_integ.prowfile = field.prowfile
	  state.diff_integ.reffile = field.reffile
	  state.diff_integ.datadir = field.datadir
	  state.diff_integ.datafile = field.datafile
	  state.diff_integ.first = field.first
	  state.diff_integ.last = field.last
	  state.diff_integ.skip = field.skip
	  state.diff_integ.data_skipped = field.data_skipped
	  state.diff_integ.detector = field.detector
	  state.diff_integ.res_lim = field.res_lim
 	  state.diff_integ.xsize = field.xsize
	  state.diff_integ.ysize = field.ysize 
	  state.diff_integ.raster = field.raster
	  state.diff_integ.set_bsmask = field.set_bsmask
	  state.diff_integ.bs_maskfile = field.bs_maskfile
	  state.diff_integ.set_mask = field.set_mask
	  state.diff_integ.maskfile = field.maskfile
	  state.diff_integ.boxsize.x = field.boxsize_x
	  state.diff_integ.boxsize.y = field.boxsize_y 
	  state.diff_integ.set_region = field.set_region
	  state.diff_integ.regionfile = field.regionfile
	  state.diff_integ.bc_extend = field.bc_extend
	  state.diff_integ.use_old_ref = field.use_old_ref
	  state.diff_integ.second_interp = field.second_interp
	  state.diff_integ.ovlp_dist = field.ovlp_dist
	  state.diff_integ.ovlp_min_dist = field.ovlp_min_dist
	  state.diff_integ.ovlp_ref_dist = field.ovlp_ref_dist
	  state.diff_integ.satvalue = field.satvalue
	  state.diff_integ.det_offset = field.det_offset
	  state.diff_integ.det_gain = field.det_gain
	  state.diff_integ.bg_percentage = field.bg_percentage
	  state.diff_integ.bg_max_slope = field.bg_max_slope
	  state.diff_integ.max_ref_spots = field.max_ref_spots
	  state.diff_integ.min_ref_spots = field.min_ref_spots
	  state.diff_integ.min_isigi = field.min_isigi
	  state.diff_integ.use_partials = 1
	  state.diff_integ.max_osc_distance = field.max_osc_distance 
	  state.diff_integ.n_sectors = field.n_sectors 
	  state.diff_integ.rad_distance = field.rad_distance 
	  state.diff_integ.ang_width = field.ang_width 
	  state.diff_integ.sym_search = field.sym_search
	  state.diff_integ.show_image = field.show_image
	  state.diff_integ.show_ref = field.show_ref
	  state.diff_integ.show_strong = field.show_strong
	  state.diff_integ.show_weak = field.show_weak
	  state.diff_integ.show_ovlp = field.show_ovlp
	  state.diff_integ.show_m = field.show_m 
	  state.diff_integ.miller = field.miller
	 ENDIF
	ENDIF

	IF mode EQ 'laue_soft' THEN BEGIN
	
 	 field = {						$
		logdir		: state.diff_integ.logdir , 	$
		logfile		: state.diff_integ.logfile , 	$
		xdir		: state.diff_integ.xdir , 	$
		xfile		: state.diff_integ.xfile , 	$
		loc_refine	: state.diff_integ.loc_refine , $
		prowdir		: state.diff_integ.prowdir , 	$
		prowfile	: state.diff_integ.prowfile , 	$
		reffile		: state.diff_integ.reffile , 	$
		datadir		: state.diff_integ.datadir , 	$
		datafile	: state.diff_integ.datafile , 	$
		first		: state.diff_integ.first , 	$
		last		: state.diff_integ.last , 	$
		skip		: state.diff_integ.skip , 	$
		data_skipped	: state.diff_integ.data_skipped,$
	  	exclude 	: state.diff_integ.exclude, $
	  	normalization_curve 	: state.diff_integ.normalization_curve, $
	  	complete_data_file 	: state.diff_integ.complete_data_file, $
	  	b_factor 	: state.diff_integ.b_factor, $
	  	exclude_threshold 	: state.diff_integ.exclude_threshold, $
		detector	: state.diff_integ.detector , 	$
		res_lim		: state.diff_integ.res_lim , 	$
		xsize		: state.diff_integ.xsize , 	$
		ysize		: state.diff_integ.ysize , 	$
		raster		: state.diff_integ.raster , 	$
		set_bsmask	: state.diff_integ.set_bsmask , $
		bs_maskfile	: state.diff_integ.bs_maskfile , $
		set_mask	: state.diff_integ.set_mask , 	$
		maskfile	: state.diff_integ.maskfile , 	$
		boxsize_x	: state.diff_integ.boxsize.x , 	$
		boxsize_y	: state.diff_integ.boxsize.y , 	$
		set_region	: state.diff_integ.set_region , $
		regionfile	: state.diff_integ.regionfile , $
		bc_extend	: state.diff_integ.bc_extend , $
 		use_old_ref	: state.diff_integ.use_old_ref , $
 		second_interp	: state.diff_integ.second_interp , $
		ovlp_dist	: state.diff_integ.ovlp_dist , 	$
		ovlp_min_dist	: state.diff_integ.ovlp_min_dist,$
		ovlp_ref_dist	: state.diff_integ.ovlp_ref_dist,$
		satvalue	: state.diff_integ.satvalue , 	$
		det_offset	: state.diff_integ.det_offset , $
		det_gain	: state.diff_integ.det_gain , 	$
		bg_percentage	: state.diff_integ.bg_percentage,$
		bg_max_slope	: state.diff_integ.bg_max_slope,$
		max_ref_spots	: state.diff_integ.max_ref_spots,$
		min_ref_spots	: state.diff_integ.min_ref_spots,$
		min_isigi	: state.diff_integ.min_isigi , 	$
		max_osc_distance: state.diff_integ.max_osc_distance,$
		n_sectors	: state.diff_integ.n_sectors,$
		rad_distance	: state.diff_integ.rad_distance,$
		ang_width	: state.diff_integ.ang_width , 	$
		sym_search	: state.diff_integ.sym_search , $
		show_image	: state.diff_integ.show_image , $
		show_ref	: state.diff_integ.show_ref , 	$
		show_strong	: state.diff_integ.show_strong, $
		show_weak	: state.diff_integ.show_weak , 	$
		show_ovlp	: state.diff_integ.show_ovlp , 	$
		show_m		: state.diff_integ.show_m , 	$
		miller		: state.diff_integ.miller  	$
		}

	field_title=	[					 $
	'Directory for logfile : '				,$
	'Logfile : '						,$
	'Directory of GEASC files : '				,$
	'Generic GEASC filename : '				,$
	'Local refinement [1:YES,0:NO] : '			,$
	'Directory of PROW files :  '				,$
	'Generic PROW filename : '				,$
	'Generic REF filename : '				,$
	'Directory of DATA files :  '				,$
	'Generic DATA filename : '				,$
	'First image to integrate : '				,$
	'Last image to integrate : '				,$
	'Skip images [1:YES,0:NO] : '				,$	
	'Numbers of skipped images : '				,$	

	'RDBW mode [0:NO, 1:LSCALE, 2:LAUENORM, 3:CALCULATED] : ',$
	'Normalization curve filename (IDL format) : '		,$
	'Monochromatic data file (IDL format) [leave empty if no mono. data used for RDBW] : '	,$
	'Estimated B factor [A^2] : '				,$
	'Exclusion threshold [%] : '				,$

	'Detector type [''mar18'', ''mar30'', ''mar345'', ''ccd'',''ccd4bytes'',''marccd'',''adscQ4'',''adscQ315'',''raxis'',''edf''] : ',$	
	'Resolution limits : '					,$	
	'Xsize of image [raster] : '				,$	
	'Ysize of image [raster] : '				,$	
	'Raster size [microns] : '				,$	
	'Apply a beamstop mask [1:YES,0:NO] : '			,$	
	'Beamstop mask filename : '				,$
	'Apply a mask [1:YES,0:NO] : '	 			,$	
	'Mask filename : '					,$
	'Integration boxsize X [raster, odd number ] : '	,$
	'Integration boxsize Y [raster, odd number ] : '	,$
	'Restrain fitting area [1:YES,0:NO] : '	 	,$	
	'Region area filename : '				,$
	'Number of excluded pixels around spot area for background calculation [raster] : ',$
	'Reference spots files already existing ? [1:YES,0:NO] : ',$
	'Reinterpolate according to experimental spot position ? [1:YES,0:NO] : ',$
	'Overlap distance [mm] : '				,$
	'Maximum distance for overlap deconvolution [mm] : '	,$
	'Overlap distance for selection of reference spots [mm] : ',$
	'Saturation value of the detector [ADU] : '		,$
	'Offset value of the detector [ADU] : '			,$
	'Gain of the detector [at 1.54 A] : '			,$
	'Initial percentage of background pixels in integration box [%] : ',$
	'Maximum acceptable slope for background [counts/pixel] : ',$
	'Maximum number of reference peaks : '			,$
	'Minimum number of reference peaks : '			,$
	'Minimum number I/SIGI for reference peaks : '		,$
	'Maximum oscillation distance for reference peak search [degree] : '	,$
	'Number of sectors for reference peak search : '	,$
	'Radial distance for reference peak search [mm] : '	,$
	'Angular width for reference peak search [degree] : '	,$
	'Search reference peaks in symetrical sector if necessary [1:YES,0:NO] : ',$
	'Show image during integration [1:YES,0:NO] : '		,$
	'Show reference peaks during integration [1:YES,0:NO] : ',$
	'Show strong peaks during integration [1:YES,0:NO] : '	,$
	'Show weak peaks during integration [1:YES,0:NO] : '	,$
	'Show overlapped peaks during integration [1:YES,0:NO] : ',$
	'Show a defined [h,k,l] reflection during integration [1:YES,0:NO] : ',$
	'Reflection to be seen during integration [h,k,l] : ' $
			]


	XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	IF action EQ 'DO' THEN BEGIN

	 IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	  field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	  field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	  field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)
	 IF RSTRPOS(field.datadir,'/') NE (STRLEN(field.datadir)-1) THEN $
	  field.datadir=STRCOMPRESS(field.datadir+'/',/REMOVE_ALL)


 	  state.diff_integ.logdir = field.logdir
	  state.diff_integ.logfile = field.logfile
	  state.diff_integ.xdir = field.xdir
	  state.diff_integ.xfile = field.xfile
	  state.diff_integ.loc_refine = field.loc_refine
	  state.diff_integ.prowdir = field.prowdir
	  state.diff_integ.prowfile = field.prowfile
	  state.diff_integ.reffile = field.reffile
	  state.diff_integ.datadir = field.datadir
	  state.diff_integ.datafile = field.datafile
	  state.diff_integ.first = field.first
	  state.diff_integ.last = field.last
	  state.diff_integ.skip = field.skip
	  state.diff_integ.data_skipped = field.data_skipped

	  state.diff_integ.exclude = field.exclude
	  state.diff_integ.normalization_curve = field.normalization_curve
	  state.diff_integ.complete_data_file = field.complete_data_file
	  state.diff_integ.b_factor = field.b_factor
	  state.diff_integ.exclude_threshold = field.exclude_threshold

	  state.diff_integ.detector = field.detector
	  state.diff_integ.res_lim = field.res_lim
 	  state.diff_integ.xsize = field.xsize
	  state.diff_integ.ysize = field.ysize 
	  state.diff_integ.raster = field.raster
	  state.diff_integ.set_bsmask = field.set_bsmask
	  state.diff_integ.bs_maskfile = field.bs_maskfile
	  state.diff_integ.set_mask = field.set_mask
	  state.diff_integ.maskfile = field.maskfile
	  state.diff_integ.boxsize.x = field.boxsize_x
	  state.diff_integ.boxsize.y = field.boxsize_y 
	  state.diff_integ.set_region = field.set_region
	  state.diff_integ.regionfile = field.regionfile
	  state.diff_integ.bc_extend = field.bc_extend
	  state.diff_integ.use_old_ref = field.use_old_ref
	  state.diff_integ.second_interp = field.second_interp
	  state.diff_integ.ovlp_dist = field.ovlp_dist
	  state.diff_integ.ovlp_min_dist = field.ovlp_min_dist
	  state.diff_integ.ovlp_ref_dist = field.ovlp_ref_dist
	  state.diff_integ.satvalue = field.satvalue
	  state.diff_integ.det_offset = field.det_offset
	  state.diff_integ.det_gain = field.det_gain
	  state.diff_integ.bg_percentage = field.bg_percentage
	  state.diff_integ.bg_max_slope = field.bg_max_slope
	  state.diff_integ.max_ref_spots = field.max_ref_spots
	  state.diff_integ.min_ref_spots = field.min_ref_spots
	  state.diff_integ.min_isigi = field.min_isigi
	  state.diff_integ.use_partials = 1
	  state.diff_integ.max_osc_distance = field.max_osc_distance 
	  state.diff_integ.n_sectors = field.n_sectors
	  state.diff_integ.rad_distance = field.rad_distance 
	  state.diff_integ.ang_width = field.ang_width 
	  state.diff_integ.sym_search = field.sym_search
	  state.diff_integ.show_image = field.show_image
	  state.diff_integ.show_ref = field.show_ref
	  state.diff_integ.show_strong = field.show_strong
	  state.diff_integ.show_weak = field.show_weak
	  state.diff_integ.show_ovlp = field.show_ovlp
	  state.diff_integ.show_m = field.show_m 
	  state.diff_integ.miller = field.miller
	 ENDIF
	ENDIF

 	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 7 : BEGIN ; Save integration state
	integ_state=state.diff_integ
	field={file:state.integ.file}
	field_title=['Enter integration parameters file : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action

	IF action EQ 'DO' THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Saving integ state ...'
		PRINT,'Saving integ state ...'
		state.integ.file=field.file
		SAVE,integ_state,FILE=field.file
	ENDIF
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
     END
	
 8 :BEGIN ; Restore integration state
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose an integration parameters file ...'
	IF RSTRPOS(state.integ.file,'/') EQ -1 THEN dir=GETENV('DATA') ELSE $
	 dir=STRMID(state.integ.file,0,RSTRPOS(state.integ.file,'/'))
	file=PICKFILE(/READ,PATH=dir,GET_PATH=dir,FILTER=['*'])
	IF file EQ '' THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		GOTO,give_up_int_restore
	ENDIF
	state.integ.file=file(0)
 	WIDGET_CONTROL,state.info,SET_VALUE='Info : Loading integration parameters file ...'
	RESTORE,file(0)

	PRINT,'Restoring integ state ...'
 	IF MAX(tag_names(integ_state) EQ 'LOGDIR') EQ 1 THEN state.diff_integ.logdir = integ_state.logdir
	IF MAX(tag_names(integ_state) EQ 'LOGFILE') EQ 1 THEN state.diff_integ.logfile = integ_state.logfile
	IF MAX(tag_names(integ_state) EQ 'DENZO_FORMAT') EQ 1 THEN state.diff_integ.denzo_format = integ_state.denzo_format
	IF MAX(tag_names(integ_state) EQ 'XDIR') EQ 1 THEN state.diff_integ.xdir = integ_state.xdir
	IF MAX(tag_names(integ_state) EQ 'XFILE') EQ 1 THEN state.diff_integ.xfile = integ_state.xfile
	IF MAX(tag_names(integ_state) EQ 'LOC_REFINE') EQ 1 THEN state.diff_integ.loc_refine = integ_state.loc_refine
	IF MAX(tag_names(integ_state) EQ 'PROWDIR') EQ 1 THEN state.diff_integ.prowdir = integ_state.prowdir
	IF MAX(tag_names(integ_state) EQ 'PROWFILE') EQ 1 THEN state.diff_integ.prowfile = integ_state.prowfile
	IF MAX(tag_names(integ_state) EQ 'REFFILE') EQ 1 THEN state.diff_integ.reffile = integ_state.reffile
	IF MAX(tag_names(integ_state) EQ 'DATADIR') EQ 1 THEN state.diff_integ.datadir = integ_state.datadir
	IF MAX(tag_names(integ_state) EQ 'DATAFILE') EQ 1 THEN state.diff_integ.datafile = integ_state.datafile
	IF MAX(tag_names(integ_state) EQ 'FIRST') EQ 1 THEN state.diff_integ.first = integ_state.first
	IF MAX(tag_names(integ_state) EQ 'LAST') EQ 1 THEN state.diff_integ.last = integ_state.last
	IF MAX(tag_names(integ_state) EQ 'SKIP') EQ 1 THEN state.diff_integ.skip = integ_state.skip
	IF MAX(tag_names(integ_state) EQ 'DATA_SKIPPED') EQ 1 THEN state.diff_integ.data_skipped = integ_state.data_skipped
	IF MAX(tag_names(integ_state) EQ 'EXCLUDE') EQ 1 THEN state.diff_integ.exclude = integ_state.exclude
	IF MAX(tag_names(integ_state) EQ 'NORMALIZATION_CURVE') EQ 1 THEN state.diff_integ.normalization_curve = integ_state.normalization_curve
	IF MAX(tag_names(integ_state) EQ 'COMPLETE_DATA_FILE') EQ 1 THEN state.diff_integ.complete_data_file = integ_state.complete_data_file
	IF MAX(tag_names(integ_state) EQ 'B_FACTOR') EQ 1 THEN state.diff_integ.b_factor = integ_state.b_factor
	IF MAX(tag_names(integ_state) EQ 'EXCLUDE_THRESHOLD') EQ 1 THEN state.diff_integ.exclude_threshold = integ_state.exclude_threshold
	IF MAX(tag_names(integ_state) EQ 'DETECTOR') EQ 1 THEN state.diff_integ.detector = integ_state.detector
	IF MAX(tag_names(integ_state) EQ 'RES_LIM') EQ 1 THEN state.diff_integ.res_lim = integ_state.res_lim
 	IF MAX(tag_names(integ_state) EQ 'XSIZE') EQ 1 THEN state.diff_integ.xsize = integ_state.xsize
	IF MAX(tag_names(integ_state) EQ 'YSIZE') EQ 1 THEN state.diff_integ.ysize = integ_state.ysize 
	IF MAX(tag_names(integ_state) EQ 'RASTER') EQ 1 THEN state.diff_integ.raster = integ_state.raster
	IF MAX(tag_names(integ_state) EQ 'SET_BSMASK') EQ 1 THEN state.diff_integ.set_bsmask = integ_state.set_bsmask
	IF MAX(tag_names(integ_state) EQ 'BS_MASKFILE') EQ 1 THEN state.diff_integ.bs_maskfile = integ_state.bs_maskfile
	IF MAX(tag_names(integ_state) EQ 'SET_MASK') EQ 1 THEN state.diff_integ.set_mask = integ_state.set_mask
	IF MAX(tag_names(integ_state) EQ 'MASKFILE') EQ 1 THEN state.diff_integ.maskfile = integ_state.maskfile
	IF MAX(tag_names(integ_state) EQ 'BOXSIZE') EQ 1 THEN state.diff_integ.boxsize.x = integ_state.boxsize.x
	IF MAX(tag_names(integ_state) EQ 'BOXSIZE') EQ 1 THEN state.diff_integ.boxsize.y = integ_state.boxsize.y
	IF MAX(tag_names(integ_state) EQ 'SET_REGION') EQ 1 THEN state.diff_integ.set_region = integ_state.set_region
	IF MAX(tag_names(integ_state) EQ 'REGIONFILE') EQ 1 THEN state.diff_integ.regionfile = integ_state.regionfile
	IF MAX(tag_names(integ_state) EQ 'BC_EXTEND') EQ 1 THEN state.diff_integ.bc_extend = integ_state.bc_extend
	IF MAX(tag_names(integ_state) EQ 'USE_OLD_REF') EQ 1 THEN state.diff_integ.use_old_ref = integ_state.use_old_ref
	IF MAX(tag_names(integ_state) EQ 'SECOND_INTERP') EQ 1 THEN state.diff_integ.second_interp = integ_state.second_interp
	IF MAX(tag_names(integ_state) EQ 'OVLP_DIST') EQ 1 THEN state.diff_integ.ovlp_dist = integ_state.ovlp_dist
	IF MAX(tag_names(integ_state) EQ 'OVLP_MIN_DIST') EQ 1 THEN state.diff_integ.ovlp_min_dist = integ_state.ovlp_min_dist
	IF MAX(tag_names(integ_state) EQ 'OVLP_REF_DIST') EQ 1 THEN state.diff_integ.ovlp_ref_dist = integ_state.ovlp_ref_dist
	IF MAX(tag_names(integ_state) EQ 'SATVALUE') EQ 1 THEN state.diff_integ.satvalue = integ_state.satvalue
	IF MAX(tag_names(integ_state) EQ 'DET_OFFSET') EQ 1 THEN state.diff_integ.det_offset = integ_state.det_offset
	IF MAX(tag_names(integ_state) EQ 'DET_GAIN') EQ 1 THEN state.diff_integ.det_gain = integ_state.det_gain
	IF MAX(tag_names(integ_state) EQ 'BG_PERCENTAGE') EQ 1 THEN state.diff_integ.bg_percentage = integ_state.bg_percentage
	IF MAX(tag_names(integ_state) EQ 'BG_MAX_SLOPE') EQ 1 THEN state.diff_integ.bg_max_slope = integ_state.bg_max_slope
	IF MAX(tag_names(integ_state) EQ 'MAX_REF_SPOTS') EQ 1 THEN state.diff_integ.max_ref_spots = integ_state.max_ref_spots
	IF MAX(tag_names(integ_state) EQ 'MIN_REF_SPOTS') EQ 1 THEN state.diff_integ.min_ref_spots = integ_state.min_ref_spots
	IF MAX(tag_names(integ_state) EQ 'MIN_ISIGI') EQ 1 THEN state.diff_integ.min_isigi = integ_state.min_isigi
	IF MAX(tag_names(integ_state) EQ 'USE_PARTIALS') EQ 1 THEN state.diff_integ.use_partials = integ_state.use_partials
	IF MAX(tag_names(integ_state) EQ 'MAX_OSC_DISTANCE') EQ 1 THEN state.diff_integ.max_osc_distance = integ_state.max_osc_distance 
	IF MAX(tag_names(integ_state) EQ 'N_SECTORS') EQ 1 THEN state.diff_integ.n_sectors = integ_state.n_sectors 
	IF MAX(tag_names(integ_state) EQ 'RAD_DISTANCE') EQ 1 THEN state.diff_integ.rad_distance = integ_state.rad_distance 
	IF MAX(tag_names(integ_state) EQ 'ANG_WIDTH') EQ 1 THEN state.diff_integ.ang_width = integ_state.ang_width 
	IF MAX(tag_names(integ_state) EQ 'SYM_SEARCH') EQ 1 THEN state.diff_integ.sym_search = integ_state.sym_search
	IF MAX(tag_names(integ_state) EQ 'SHOW_IMAGE') EQ 1 THEN state.diff_integ.show_image = integ_state.show_image
	IF MAX(tag_names(integ_state) EQ 'SHOW_REF') EQ 1 THEN state.diff_integ.show_ref = integ_state.show_ref
	IF MAX(tag_names(integ_state) EQ 'SHOW_STRONG') EQ 1 THEN state.diff_integ.show_strong = integ_state.show_strong
	IF MAX(tag_names(integ_state) EQ 'SHOW_WEAK') EQ 1 THEN state.diff_integ.show_weak = integ_state.show_weak
	IF MAX(tag_names(integ_state) EQ 'SHOW_OVLP') EQ 1 THEN state.diff_integ.show_ovlp = integ_state.show_ovlp
	IF MAX(tag_names(integ_state) EQ 'SHOW_M') EQ 1 THEN state.diff_integ.show_m = integ_state.show_m 
	IF MAX(tag_names(integ_state) EQ 'MILLER') EQ 1 THEN state.diff_integ.miller = integ_state.miller
 	IF MAX(tag_names(integ_state) EQ 'INTEG_MODE') EQ 1 THEN state.diff_integ.integ_mode = integ_state.integ_mode

	give_up_int_restore:
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
    END

 10 : BEGIN ; Change the conversion parameters
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Define the conversion parameters ...'
	IF state.diff_denzox.integ_mode EQ 'mono' THEN BEGIN
	 field = {						$
		logdir		: state.diff_denzox.logdir , 	$
		logfile		: state.diff_denzox.logfile , 	$
		xdir		: state.diff_denzox.xdir , 	$
		xfile		: state.diff_denzox.xfile , 	$
		outxdir		: state.diff_denzox.outxdir , 	$
		outxfile	: state.diff_denzox.outxfile , 	$
		denzo_format	: state.diff_denzox.denzo_format,$
		prowdir		: state.diff_denzox.prowdir , 	$
		prowfile	: state.diff_denzox.prowfile , 	$
		first		: state.diff_denzox.first , 	$
		last		: state.diff_denzox.last , 	$
		skip		: state.diff_denzox.skip , 	$
		data_skipped	: state.diff_denzox.data_skipped,$
		combine		: state.diff_denzox.combine , 	$
		rm_ovlp		: state.diff_denzox.rm_ovlp , 	$
		rm_largerms	: state.diff_denzox.rm_largerms , 	$
		rm_outliers	: state.diff_denzox.rm_outliers , 	$
		keep_lowres	: state.diff_denzox.keep_lowres , 	$
		scaledown	: state.diff_denzox.scaledown , $
		set_zero	: state.diff_denzox.set_zero , $
		set_neg_thres	: state.diff_denzox.set_neg_thres , 	$
		save_limited	: state.diff_denzox.save_limited , 	$
		rmin		: state.diff_denzox.rmin , 	$
		rmax		: state.diff_denzox.rmax 	$
		}

	 field_title=	[					 $
	 'Directory for logfile : '				,$
	 'Logfile : '						,$
	 'Directory of ORIGINAL DENZO files : '				,$
	 'Generic ORIGINAL DENZO filename : '				,$
	 'Directory of NEW DENZO files : '				,$
	 'Generic NEW DENZO filename : '				,$
	 'Format of DENZO files [''YORK'',''NOYORK''] : '	,$
	 'Directory of PROW files :  '				,$
	 'Generic PROW filename : '				,$
	 'First image to integrate : '				,$
	 'Last image to integrate : '				,$
	 'Skip images [1:YES,0:NO] : '				,$	
	 'Numbers of skipped images : '				,$	
	 'Combine profile fitted with box integrated intensities [1:YES,0:NO] : ',$	
	 'Remove overlapped spots [1:YES,0:NO] : '		,$	
	 'Remove spots with large RMS deviation [1:YES,0:NO] : '	,$	
	 'Remove outliers [1:YES,0:NO] : '			,$	
	 'Resolution limit to keep profile fitting outliers : '	,$	
	 'Scale down intensities to [0:DON''T,value:THE VALUE] : ',$
	 'Set negative intensities to zero [1:YES,0:NO] : '	,$	
	 'Remove too large negative intensities [0:NO,(neg) value:THE VALUE] : ',$
	 'Keep reflexions only in a limited region [1:YES,0:NO] : ',$
	 'Minimum distance to beam center to keep reflexions [mm] : ',$
	 'Maximum distance to beam center to keep reflexions [mm] : '$
			]


	 XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	 IF action EQ 'DO' THEN BEGIN

	  IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	   field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	   field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.outxdir,'/') NE (STRLEN(field.outxdir)-1) THEN $
	   field.outxdir=STRCOMPRESS(field.outxdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	   field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)

 	  state.diff_denzox.logdir = field.logdir
	  state.diff_denzox.logfile = field.logfile
	  state.diff_denzox.xdir = field.xdir
	  state.diff_denzox.xfile = field.xfile
	  state.diff_denzox.outxdir = field.outxdir
	  state.diff_denzox.outxfile = field.outxfile
	  state.diff_denzox.denzo_format = field.denzo_format
	  state.diff_denzox.prowdir = field.prowdir
	  state.diff_denzox.prowfile = field.prowfile
	  state.diff_denzox.first = field.first
	  state.diff_denzox.last = field.last
	  state.diff_denzox.skip = field.skip
	  state.diff_denzox.data_skipped = field.data_skipped
	  state.diff_denzox.combine = field.combine
	  state.diff_denzox.rm_ovlp = field.rm_ovlp
	  state.diff_denzox.rm_mult = 0
	  state.diff_denzox.rm_excluded = 0
 	  state.diff_denzox.rm_largerms = field.rm_largerms
	  state.diff_denzox.rm_outliers = field.rm_outliers 
	  state.diff_denzox.keep_lowres = field.keep_lowres
	  state.diff_denzox.scaledown = field.scaledown
	  state.diff_denzox.set_zero = field.set_zero
	  state.diff_denzox.set_neg_thres = field.set_neg_thres
	  state.diff_denzox.save_limited = field.save_limited
	  state.diff_denzox.rmin = field.rmin
	  state.diff_denzox.rmax = field.rmax
	 ENDIF
	ENDIF 

	IF state.diff_denzox.integ_mode EQ 'laue_hard' THEN BEGIN
	 field = {						$
		logdir		: state.diff_denzox.logdir , 	$
		logfile		: state.diff_denzox.logfile , 	$
		xdir		: state.diff_denzox.xdir , 	$
		xfile		: state.diff_denzox.xfile , 	$
		outxdir		: state.diff_denzox.outxdir , 	$
		outxfile	: state.diff_denzox.outxfile , 	$
		prowdir		: state.diff_denzox.prowdir , 	$
		prowfile	: state.diff_denzox.prowfile , 	$
		first		: state.diff_denzox.first , 	$
		last		: state.diff_denzox.last , 	$
		skip		: state.diff_denzox.skip , 	$
		data_skipped	: state.diff_denzox.data_skipped,$
		combine		: state.diff_denzox.combine , 	$
		rm_ovlp		: state.diff_denzox.rm_ovlp , 	$
		rm_mult		: state.diff_denzox.rm_mult , 	$
		rm_largerms	: state.diff_denzox.rm_largerms , 	$
		rm_outliers	: state.diff_denzox.rm_outliers , 	$
		keep_lowres	: state.diff_denzox.keep_lowres , 	$
		scaledown	: state.diff_denzox.scaledown , $
		set_zero	: state.diff_denzox.set_zero , $
		set_neg_thres	: state.diff_denzox.set_neg_thres , 	$
		save_limited	: state.diff_denzox.save_limited , 	$
		savegeasc	: state.diff_denzox.savegeasc , 	$
		rmin		: state.diff_denzox.rmin , 	$
		rmax		: state.diff_denzox.rmax 	$
		}

	 field_title=	[					 $
	 'Directory for logfile : '				,$
	 'Logfile : '						,$
	 'Directory of ORIGINAL GEASC files : '				,$
	 'Generic ORIGINAL GEASC filename : '				,$
	 'Directory of NEW GEASC files : '				,$
	 'Generic NEW GEASC filename : '				,$
	 'Directory of PROW files :  '				,$
	 'Generic PROW filename : '				,$
	 'First image to integrate : '				,$
	 'Last image to integrate : '				,$
	 'Skip images [1:YES,0:NO] : '				,$	
	 'Numbers of skipped images : '				,$	
	 'Combine profile fitted with box integrated intensities [1:YES,0:NO] : ',$	
	 'Remove overlapped spots [1:YES,0:NO] : '		,$	
	 'Remove multiple spots [1:YES,0:NO] : '		,$	
	 'Remove spots with large RMS deviation [1:YES,0:NO] : '	,$	
	 'Remove outliers [1:YES,0:NO] : '			,$	
	 'Resolution limit to keep profile fitting outliers : '	,$	
	 'Scale down intensities to [0:DON''T,value:THE VALUE] : ',$
	 'Set negative intensities to zero [1:YES,0:NO] : '	,$	
	 'Remove too large negative intensities [0:NO,(neg) value:THE VALUE] : ',$
	 'Keep reflexions only in a limited region [1:YES,0:NO] : ',$
	 'Save output .GEASC file [1:YES,0:NO] : ',$
	 'Minimum distance to beam center to keep reflexions [mm] : ',$
	 'Maximum distance to beam center to keep reflexions [mm] : '$
			]


	 XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	 IF action EQ 'DO' THEN BEGIN

	  IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	   field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	   field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.outxdir,'/') NE (STRLEN(field.outxdir)-1) THEN $
	   field.outxdir=STRCOMPRESS(field.outxdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	   field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)

 	  state.diff_denzox.logdir = field.logdir
	  state.diff_denzox.logfile = field.logfile
	  state.diff_denzox.xdir = field.xdir
	  state.diff_denzox.xfile = field.xfile
	  state.diff_denzox.outxdir = field.outxdir
	  state.diff_denzox.outxfile = field.outxfile
	  state.diff_denzox.prowdir = field.prowdir
	  state.diff_denzox.prowfile = field.prowfile
	  state.diff_denzox.first = field.first
	  state.diff_denzox.last = field.last
	  state.diff_denzox.skip = field.skip
	  state.diff_denzox.data_skipped = field.data_skipped
	  state.diff_denzox.combine = field.combine
	  state.diff_denzox.rm_ovlp = field.rm_ovlp
	  state.diff_denzox.rm_mult = field.rm_mult
	  state.diff_denzox.rm_excluded = 0
 	  state.diff_denzox.rm_largerms = field.rm_largerms
	  state.diff_denzox.rm_outliers = field.rm_outliers 
	  state.diff_denzox.keep_lowres = field.keep_lowres
	  state.diff_denzox.scaledown = field.scaledown
	  state.diff_denzox.set_zero = field.set_zero
	  state.diff_denzox.set_neg_thres = field.set_neg_thres
	  state.diff_denzox.save_limited = field.save_limited
	  state.diff_denzox.savegeasc = field.savegeasc
	  state.diff_denzox.rmin = field.rmin
	  state.diff_denzox.rmax = field.rmax
	 ENDIF
	ENDIF


	IF state.diff_denzox.integ_mode EQ 'laue_soft' THEN BEGIN
	 field = {						$
		logdir		: state.diff_denzox.logdir , 	$
		logfile		: state.diff_denzox.logfile , 	$
		xdir		: state.diff_denzox.xdir , 	$
		xfile		: state.diff_denzox.xfile , 	$
		outxdir		: state.diff_denzox.outxdir , 	$
		outxfile	: state.diff_denzox.outxfile , 	$
		prowdir		: state.diff_denzox.prowdir , 	$
		prowfile	: state.diff_denzox.prowfile , 	$
		first		: state.diff_denzox.first , 	$
		last		: state.diff_denzox.last , 	$
		skip		: state.diff_denzox.skip , 	$
		data_skipped	: state.diff_denzox.data_skipped,$
		combine		: state.diff_denzox.combine , 	$
		rm_ovlp		: state.diff_denzox.rm_ovlp , 	$
		rm_mult		: state.diff_denzox.rm_mult , 	$
		rm_excluded	: state.diff_denzox.rm_excluded , 	$
		rm_largerms	: state.diff_denzox.rm_largerms , 	$
		rm_outliers	: state.diff_denzox.rm_outliers , 	$
		keep_lowres	: state.diff_denzox.keep_lowres , 	$
		scaledown	: state.diff_denzox.scaledown , $
		set_zero	: state.diff_denzox.set_zero , $
		set_neg_thres	: state.diff_denzox.set_neg_thres , 	$
		save_limited	: state.diff_denzox.save_limited , 	$
		savegeasc	: state.diff_denzox.savegeasc , 	$
		rmin		: state.diff_denzox.rmin , 	$
		rmax		: state.diff_denzox.rmax 	$
		}

	 field_title=	[					 $
	 'Directory for logfile : '				,$
	 'Logfile : '						,$
	 'Directory of ORIGINAL GEASC files : '				,$
	 'Generic ORIGINAL GEASC filename : '				,$
	 'Directory of NEW GEASC files : '				,$
	 'Generic NEW GEASC filename : '				,$
	 'Directory of PROW files :  '				,$
	 'Generic PROW filename : '				,$
	 'First image to integrate : '				,$
	 'Last image to integrate : '				,$
	 'Skip images [1:YES,0:NO] : '				,$	
	 'Numbers of skipped images : '				,$	
	 'Combine profile fitted with box integrated intensities [1:YES,0:NO] : ',$	
	 'Remove overlapped spots [1:YES,0:NO] : '		,$	
	 'Remove multiple spots [1:YES,0:NO] : '		,$	
	 'Remove spots excluded during integration [1:YES,0:NO] : ' ,$	
	 'Remove spots with large RMS deviation [1:YES,0:NO] : '	,$	
	 'Remove outliers [1:YES,0:NO] : '			,$	
	 'Resolution limit to keep profile fitting outliers : '	,$	
	 'Scale down intensities to [0:DON''T,value:THE VALUE] : ',$
	 'Set negative intensities to zero [1:YES,0:NO] : '	,$	
	 'Remove too large negative intensities [0:NO,(neg) value:THE VALUE] : ',$
	 'Keep reflexions only in a limited region [1:YES,0:NO] : ',$
	 'Save output .GEASC file [1:YES,0:NO] : ',$
	 'Minimum distance to beam center to keep reflexions [mm] : ',$
	 'Maximum distance to beam center to keep reflexions [mm] : '$
			]


	 XSCRMENU,field,titles=field_title,/SCROLL,/NOTYPE,/INTERP,NCOLUMN=1,FIELDLEN=40,ACTION=action
	 IF action EQ 'DO' THEN BEGIN

	  IF RSTRPOS(field.logdir,'/') NE (STRLEN(field.logdir)-1) THEN $
	   field.logdir=STRCOMPRESS(field.logdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.xdir,'/') NE (STRLEN(field.xdir)-1) THEN $
	   field.xdir=STRCOMPRESS(field.xdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.outxdir,'/') NE (STRLEN(field.outxdir)-1) THEN $
	   field.outxdir=STRCOMPRESS(field.outxdir+'/',/REMOVE_ALL)
	  IF RSTRPOS(field.prowdir,'/') NE (STRLEN(field.prowdir)-1) THEN $
	   field.prowdir=STRCOMPRESS(field.prowdir+'/',/REMOVE_ALL)

 	  state.diff_denzox.logdir = field.logdir
	  state.diff_denzox.logfile = field.logfile
	  state.diff_denzox.xdir = field.xdir
	  state.diff_denzox.xfile = field.xfile
	  state.diff_denzox.outxdir = field.outxdir
	  state.diff_denzox.outxfile = field.outxfile
	  state.diff_denzox.prowdir = field.prowdir
	  state.diff_denzox.prowfile = field.prowfile
	  state.diff_denzox.first = field.first
	  state.diff_denzox.last = field.last
	  state.diff_denzox.skip = field.skip
	  state.diff_denzox.data_skipped = field.data_skipped
	  state.diff_denzox.combine = field.combine
	  state.diff_denzox.rm_ovlp = field.rm_ovlp
	  state.diff_denzox.rm_mult = field.rm_mult
	  state.diff_denzox.rm_excluded = field.rm_excluded
 	  state.diff_denzox.rm_largerms = field.rm_largerms
	  state.diff_denzox.rm_outliers = field.rm_outliers 
	  state.diff_denzox.keep_lowres = field.keep_lowres
	  state.diff_denzox.scaledown = field.scaledown
	  state.diff_denzox.set_zero = field.set_zero
	  state.diff_denzox.set_neg_thres = field.set_neg_thres
	  state.diff_denzox.save_limited = field.save_limited
	  state.diff_denzox.savegeasc = field.savegeasc
	  state.diff_denzox.rmin = field.rmin
	  state.diff_denzox.rmax = field.rmax
	 ENDIF
	ENDIF

	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 11 : BEGIN ; Save conversion state
	denzox_state=state.diff_denzox
	field={file:state.denzox.file}
	field_title=['Enter conversion parameters file : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action

	IF action EQ 'DO' THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Saving denzox state ...'
		PRINT,'Saving denzox state ...'
		state.denzox.file=field.file
		SAVE,denzox_state,FILE=field.file
	ENDIF
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
     END
	
 12 :BEGIN ; Restore conversion state
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose a conversion parameters file ...'
	IF RSTRPOS(state.denzox.file,'/') EQ -1 THEN dir=GETENV('DATA') ELSE $
	 dir=STRMID(state.denzox.file,0,RSTRPOS(state.denzox.file,'/'))
	file=PICKFILE(/READ,PATH=dir,GET_PATH=dir,FILTER=['*'])
	IF file EQ '' THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		GOTO,give_up_conv_restore
	ENDIF
	state.denzox.file=file(0)
 	WIDGET_CONTROL,state.info,SET_VALUE='Info : Loading conversion parameters file ...'
	RESTORE,file(0)

	PRINT,'Restoring conversion state ...'
 	state.diff_denzox.logdir = denzox_state.logdir
	state.diff_denzox.logfile = denzox_state.logfile
	state.diff_denzox.xdir = denzox_state.xdir
	state.diff_denzox.xfile = denzox_state.xfile
	state.diff_denzox.outxdir = denzox_state.outxdir
	state.diff_denzox.outxfile = denzox_state.outxfile
	state.diff_denzox.denzo_format = denzox_state.denzo_format
	state.diff_denzox.prowdir = denzox_state.prowdir
	state.diff_denzox.prowfile = denzox_state.prowfile
	state.diff_denzox.first = denzox_state.first
	state.diff_denzox.last = denzox_state.last
	state.diff_denzox.skip = denzox_state.skip
	state.diff_denzox.data_skipped = denzox_state.data_skipped
	state.diff_denzox.combine = denzox_state.combine
	state.diff_denzox.rm_ovlp = denzox_state.rm_ovlp
	state.diff_denzox.rm_mult = denzox_state.rm_mult
	state.diff_denzox.rm_excluded = denzox_state.rm_excluded
 	state.diff_denzox.rm_largerms = denzox_state.rm_largerms
	state.diff_denzox.rm_outliers = denzox_state.rm_outliers
	state.diff_denzox.keep_lowres = denzox_state.keep_lowres
	state.diff_denzox.scaledown = denzox_state.scaledown
	state.diff_denzox.set_zero = denzox_state.set_zero
	state.diff_denzox.set_neg_thres = denzox_state.set_neg_thres
	state.diff_denzox.save_limited = denzox_state.save_limited
	state.diff_denzox.savegeasc = denzox_state.savegeasc
	state.diff_denzox.rmin = denzox_state.rmin
	state.diff_denzox.rmax = denzox_state.rmax
 	IF MAX(tag_names(denzox_state) EQ 'INTEG_MODE') EQ 1 THEN state.diff_denzox.integ_mode = denzox_state.integ_mode
	give_up_conv_restore:
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
    END

 13 :BEGIN ; Estimation of boxsize
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Estimating boxsize ...'
	DRAW_ESTIMATE_BOXSIZE,state,image_state
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
    END

 14 :BEGIN ; Restrain fitting area
	DRAW_RESTRAIN_FITTING_AREA,state,image_state
    END



 16 :BEGIN ; Define masks on main
 	mask = DRAW_DEFROI(image_state.draw,/RESTORE,ZOOM=[image_state.bin_fac,image_state.bin_fac])
	field={file:image_state.masking.file}
	field_title=['Enter mask file : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL)

	IF action EQ 'DO' THEN BEGIN
		image_state.masking.file=field.file
		sx=image_state.x_im_sz
		sy=image_state.y_im_sz
		SAVE,mask,sx,sy,FILE=field.file
	ENDIF
    END

 17 :BEGIN ; Define masks on zoom
	WIDGET_CONTROL,state.info,SET_VALUE='Resetting zoom scale to 1 ...'
	image_state.scale=1
	WIDGET_CONTROL,image_state.slide,SET_VALUE=image_state.scale 
        draw_zoom, image_state, image_state.oldx, image_state.oldy,state
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
	mask = DRAW_DEFROI(image_state.zoom,/RESTORE,ZOOM=[1,1])

	IF (SIZE(mask))(0) NE 0 THEN BEGIN
	 xy_mask = WHERESUB(mask,*image_state.zoom_image)
	 x_mask = FLOAT(xy_mask)
	 y_mask = IMAGINARY(xy_mask)

	 ; compute location of origin of rect (user specified center)
	 x0 = image_state.oldx - LONG(image_state.x_zm_sz)/2
	 y0 = image_state.oldy - LONG(image_state.y_zm_sz)/2

	 x_mask = x_mask + x0
	 y_mask = y_mask + y0

	 mask = x_mask + image_state.x_im_sz*y_mask


	 field={file:image_state.masking.file}
	 field_title=['Enter mask file : ']
	 XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action

	 IF action EQ 'DO' THEN BEGIN
			image_state.masking.file=field.file
			sx=image_state.x_im_sz
			sy=image_state.y_im_sz
			SAVE,mask,sx,sy,FILE=field.file
	 ENDIF

		END
    END

 18 :BEGIN ; Define masks apply
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose a mask file ...'
	 dir=STRMID(image_state.masking.file,0,RSTRPOS(image_state.masking.file,'/'))
	file=PICKFILE(/READ,PATH=dir,GET_PATH=dir,FILTER=['*'])
	IF file EQ '' THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		GOTO,give_up_mask
	ENDIF
	image_state.masking.file=file(0)
 	WIDGET_CONTROL,state.info,SET_VALUE='Info : Loading mask file ...'
	RESTORE,file(0)
	IF (sx NE image_state.x_im_sz) OR (sy NE image_state.y_im_sz) THEN BEGIN
	 WIDGET_CONTROL,state.info,SET_VALUE='Mask not compatible with image size !'
	 GOTO,give_up_mask
	ENDIF ELSE BEGIN
	 (*image_state.orig_image)(mask)=0
	 ;remove resolution circles if present
	 IF state.res_circles THEN BEGIN
	  DRAW_RES_CIRCLES,state,image_state ;erase
	  state.res_circles=1
	 ENDIF

	 WIDGET_CONTROL,state.info,SET_VALUE='Displaying masked image ... '
	 draw_image=state.draw_image
	 child=WIDGET_INFO(state.prow_base, /CHILD)
	 ;give back the state to PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
	 WIDGET_CONTROL,draw_image,SET_VALUE=0
	 WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
	 ;get back the state from PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL,state.info,SET_VALUE='Info ... '

	 ;redraw resolution circles if present
	 IF state.res_circles THEN BEGIN
	  DRAW_RES_CIRCLES,state,image_state ;erase
	  state.res_circles=1
	 ENDIF
	ENDELSE
	give_up_mask :
    END


 19 :BEGIN ;Integrate
        ;change the format of Prow
	state.prow_title=state.diff_integ.detector + ' INTEGRATING MODE'
	image_state.x_im_sz=state.diff_integ.xsize
	image_state.y_im_sz=state.diff_integ.ysize

;	tmp_bin_fac = 1 + (state.diff_integ.xsize > state.diff_integ.ysize) / 500
	tmp_bin_fac = 0 + (state.diff_integ.xsize > state.diff_integ.ysize) / 500

        WHILE (FIX(state.diff_integ.xsize )/FIX(tmp_bin_fac) NE FIX(state.diff_integ.xsize )/FLOAT(tmp_bin_fac)) OR (FIX(state.diff_integ.ysize)/FIX(tmp_bin_fac) NE FIX(state.diff_integ.ysize)/FLOAT(tmp_bin_fac)) $
		DO BEGIN
  			tmp_bin_fac=tmp_bin_fac-1
    	ENDWHILE 

	image_state.bin_fac = tmp_bin_fac
        DRAW_CHANGE_FORMAT,state,image_state
	DRAW_INTEG,state,image_state
	state.prow_title=state.diff_integ.detector
        DRAW_CHANGE_FORMAT,state,image_state
    END

 20 :BEGIN ;Convert
	DRAW_DENZOX,state,image_state
    END

 ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
ENDCASE



END










