pro DRAW_NEXT_IMAGE,state,image_state,PREVIOUS=previous
;+
; NAME:
;	DRAW_NEXT_IMAGE
;
; PURPOSE:
;	Load next or previous image relative to the one already loaded
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_NEXT_IMAGE,state,image_state,[/PREVIOUS]
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW.
;	previous : set this keyword to load the previous image, instead of next
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par

;is an image already loaded ?
IF state.file.current EQ '' THEN BEGIN
 WIDGET_CONTROL,state.info,SET_VALUE='Error : No image loaded ...'
 WAIT,0.5
 GOTO,cut_next
ENDIF

;load next (or previous image)
file=STRCOMPRESS(STRMID(state.file.current,RSTRPOS(state.file.current,'/')+1,STRLEN(state.file.current)))
dir=STRMID(state.file.current,0,RSTRPOS(state.file.current,'/')+1)
;search a serie of three numbers starting from the end

n_steps=1
tmp_file=file

again_next:
FOR i=0,n_steps-1 DO BEGIN
 p1=	RSTRPOS(tmp_file,'0')> $
	RSTRPOS(tmp_file,'1')> $
	RSTRPOS(tmp_file,'2')> $
	RSTRPOS(tmp_file,'3')> $
	RSTRPOS(tmp_file,'4')> $
	RSTRPOS(tmp_file,'5')> $
	RSTRPOS(tmp_file,'6')> $
	RSTRPOS(tmp_file,'7')> $
	RSTRPOS(tmp_file,'8')> $
	RSTRPOS(tmp_file,'9')

 IF p1 EQ -1 THEN BEGIN
  tmp=WIDGET_MESSAGE('Image not found ...')
  GOTO,cut_next
 ENDIF
 tmp_file = STRMID(file,0,p1)
ENDFOR

n2=STRMID(file,p1-1,1)
IF n2 EQ '0' OR $
   n2 EQ '1' OR $
   n2 EQ '2' OR $
   n2 EQ '3' OR $
   n2 EQ '4' OR $
   n2 EQ '5' OR $
   n2 EQ '6' OR $
   n2 EQ '7' OR $
   n2 EQ '8' OR $
   n2 EQ '9' THEN BEGIN ;OK two numbers found

 n3=STRMID(file,p1-2,1)
 IF n3 EQ '0' OR $
    n3 EQ '1' OR $
    n3 EQ '2' OR $
    n3 EQ '3' OR $
    n3 EQ '4' OR $
    n3 EQ '5' OR $
    n3 EQ '6' OR $
    n3 EQ '7' OR $
    n3 EQ '8' OR $
    n3 EQ '9' THEN BEGIN ;OK 3 numbers found 

 n=STRMID(file,p1-2,3)
 froot=STRMID(file,0,p1-2)
 fend=STRMID(file,p1+1,STRLEN(file))
 IF NOT KEYWORD_SET(previous) THEN n=FIX(n)+1 ELSE n=FIX(n)-1
 IF n LT 10 THEN ns=STRCOMPRESS('00'+STRING(n),/REMOVE_ALL)
 IF n GE 10 AND n LT 100 THEN ns=STRCOMPRESS('0'+STRING(n),/REMOVE_ALL)
 IF n GE 100 THEN ns=STRCOMPRESS(STRING(n),/REMOVE_ALL)
 ;replace the old string by the new one
 nfile=STRCOMPRESS(dir+froot+ns+fend,/REMOVE_ALL)
 gfile=STRCOMPRESS(dir+froot+'###'+fend,/REMOVE_ALL)
 ;look if this file exists
 tmp=FINDFILE(nfile,COUNT=count)
 IF count EQ 0 THEN BEGIN 
  WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
  tmp=WIDGET_MESSAGE('Image not found ...')
  GOTO,cut_next
 ENDIF
 ;if yes, load the file
 state.file.current=nfile
 state.file.generic=gfile
 DRAW_LOAD,state,image_state

 ENDIF ELSE BEGIN ; 3 numbers found
  n_steps=n_steps+1
  GOTO,again_next
 ENDELSE
ENDIF ELSE BEGIN ; 2 numbers found
  n_steps=n_steps+1
  GOTO,again_next
ENDELSE

cut_next:
WIDGET_CONTROL,state.info,SET_VALUE='Info : '

END








