pro DRAW_ESTIMATE_BOXSIZE,state,image_state
;+
; NAME:
;	DRAW_ESTIMATE_BOXSIZE
;
; PURPOSE:
;	Get parameters for estimatation of boxsize and overlap distance before starting a Prow 
;		integration session.
;
; CATEGORY:
;	Prow.
;
; CALLING SEQUENCE:
;	DRAW_ESTIMATE_BOXSIZE,state,image_state
;
; INPUTS:
;	state: the state as defined in the widget program PROW.
;	image_state: the state as defined in the widget program PROW_DRAW
;
; OUTPUTS:
;	None.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August 2000.
;-

COMMON SHARE_PROW,pred,sel_pred,par

;this will have to be define with the XSCRMENU


IF N_ELEMENTS(pred) EQ 0 THEN BEGIN
 ok=DIALOG_MESSAGE('You must first load predictions !',/ERROR)
 GOTO,end_of_routine
ENDIF ELSE BEGIN
 ref=pred
ENDELSE

study_win=image_state.study_win
main_win=image_state.draw_win
image=*image_state.orig_image
bin_fac=image_state.bin_fac
satvalue=state.det_par.satvalue

r1=image_state.estimate_box.r1
r2=image_state.estimate_box.r2
alpha1=image_state.estimate_box.alpha1
alpha2=image_state.estimate_box.alpha2
max_number_ref=image_state.estimate_box.max_number_ref

field={lower_r:r1,upper_r:r2,lower_alpha:alpha1,upper_alpha:alpha2,max_number_ref:max_number_ref}
field_title=[	'Lower radius [mm] : ',$
		'Upper radius [mm] : ',$
		'Lower angle [degree]',$
		'Upper angle [degree]',$
		'Maximum number of spots'$
	    ]
XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL),ACTION=action
IF action EQ 'DO' THEN BEGIN
 r1=field.lower_r
 r2=field.upper_r
 alpha1=field.lower_alpha
 alpha2=field.upper_alpha
 max_number_ref=field.max_number_ref
 image_state.estimate_box.r1=r1
 image_state.estimate_box.r2=r2
 image_state.estimate_box.alpha1=alpha1
 image_state.estimate_box.alpha2=alpha2
 image_state.estimate_box.max_number_ref=max_number_ref

 mode = state.diff_integ.integ_mode

 boxsize=ESTIMATE_BOXSIZE(image,ref,par,ovlp_dist=ovlp_dist,max_number_ref=max_number_ref,r1=r1,r2=r2,$
	alpha1=alpha1,alpha2=alpha2,satvalue=satvalue,study_win=study_win,main_win=main_win,$
	bin_fac=bin_fac,/SHOW,mode=mode)

 text1=STRCOMPRESS('Suggested boxsize [raster]:'+STRING(boxsize)+' x '+STRING(boxsize))
 text2=STRCOMPRESS('Suggested overlap distance [mm]: '+STRING(ovlp_dist))
 text3='Update boxsize and overlap distance ?'
 text=[text1,text2,text3]
 ok=DIALOG_MESSAGE(text,/QUESTION)
 IF ok EQ 'Yes' THEN BEGIN
  image_state.boxinteg.boxsize.x = boxsize 
  image_state.boxinteg.boxsize.y = boxsize 
  image_state.spot_shape.boxsize_x = boxsize
  image_state.spot_shape.boxsize_y=boxsize 
  image_state.fwhm.boxsize_x = boxsize
  image_state.fwhm.boxsize_y = boxsize
  state.diff_integ.boxsize.x = boxsize
  state.diff_integ.boxsize.y = boxsize 
  state.diff_integ.ovlp_dist = ovlp_dist
  state.diff_integ.ovlp_min_dist = ovlp_dist/4.
  state.diff_integ.ovlp_ref_dist = ovlp_dist/4.
 ENDIF
ENDIF

end_of_routine:
END




