PRO REMOVE_OUTLIERS,files=files,newfiles=newfiles,outlierfile=outlierfile,start_batch=start_batch,n_batches=n_batches
;+
; NAME:
;	REMOVE_OUTLIERS
;
; PURPOSE:
;	Remove outliers in Prow files, from an LSCALE outliers list.
;
; CATEGORY:
;	Input
;
; CALLING SEQUENCE:
;   Result = REMOVE_OUTLIERS(files=files,newfiles=newfiles,outlierfile=outlierfile,[start_batch=start_batch,n_batches=n_batches])
;
; INPUTS:
;	files: String containing the name of prow files (with wild cards)
;	newfiles: String containing the extension of new prow files : the output files will look like files_newfiles.prow
;	outlierfile: String containing the name of outlier list file.
;	start_batch : starting batch number. Default = 1. In fact, should 
;		always be on. Forced to one anyway.
;	n_batches : number of batches to process. Default = all that will come out of 'ls files'
;
; OUTPUTS:
;	None
;
; SIDE EFFECTS:
;	A files are read.
;
; COMMENTS:
;
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois December 98.
;-

on_error,2                      ;Return to caller if an error occurs


IF N_ELEMENTS(files) EQ 0 THEN MESSAGE,'Need to input files !'
IF STRPOS(files,'.prow') EQ -1 THEN MESSAGE,'Input files need to end by .prow !'
IF N_ELEMENTS(newfiles) EQ 0 THEN PRINT,'Will assume newfiles=files_rej !'
IF N_ELEMENTS(newfiles) NE 0 THEN PRINT,'Output files will be called : ',STR_REPLACE(files,'.prow',STRCOMPRESS('_'+newfiles+'.prow',/REMOVE_ALL))
IF N_ELEMENTS(outlierfile) EQ 0 THEN MESSAGE,'Need to input outlier file (from LSCALE) !'
IF N_ELEMENTS(start_batch) EQ 0 THEN start_batch=1
start_image=start_batch
start_batch=1
IF N_ELEMENTS(n_batches) EQ 0 THEN n_batches=10000L

filenames=FINDFILE(files,count=count)
IF count EQ 0 THEN MESSAGE,'No file found !'

dum=FINDFILE(outlierfile,count=ct_dum)
IF ct_dum EQ 0 THEN MESSAGE,'No outlier file found !'

PRINT,'Opening outlier file ...'
outliers=read_outliers(outlierfile)

batch_number=start_batch


FOR i=0,(count-1)<(n_batches-1) DO BEGIN
; f=filenames(i+start_image-1) 
 f=filenames(i) ; TO BE CHANGED 
 newf=STR_REPLACE(f,'.prow',STRCOMPRESS('_'+newfiles+'.prow',/REMOVE_ALL))
 PRINT,''
 PRINT,'*****************************'
 PRINT,'Restoring PROW file : ',f
 PRINT,'Batch # : ', batch_number
 RESTORE,f
 w=WHERE(outliers.batch EQ batch_number,ct_batch)
 IF ct_batch EQ 0 THEN BEGIN
  PRINT,'No outliers in this batch !'
  SAVE,integ,par,FILE=newf
 ENDIF ELSE BEGIN
  PRINT,'Number of outliers in this batch : ',ct_batch
  dum=INTERSEC_TU(outliers(w),integ,un1=un1,un2=un2,/SEP_UNIQUE)
  integ=un2
  SAVE,integ,par,FILE=newf
 ENDELSE
 batch_number=batch_number+1
ENDFOR
PRINT,'Done !'
END 



