FUNCTION READ_LSQ_EX,file
;+
; NAME:
;	READ_LSQ_EX
;
; PURPOSE:
;	Read in the output from O of an LSQ_EXPLICIT operation.
;
; CATEGORY:
;	Input/Output
;
; CALLING SEQUENCE:
;   Result = READ_LSQ_EX(file)
;
; INPUTS:
;	file: String containing the name of the ASCII LSQ_EX file
;
; OUTPUTS:
;	An FLTARR(3,4) where result(*,0:2) contains the rotation and 
;			     result(*,3) contains the translation
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	None
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois February 98.
;-

on_error,2                      ;Return to caller if an error occurs

dum=FINDFILE(file,count=count)
IF count EQ 0 THEN MESSAGE,STRCOMPRESS('File not found : '+file,/REMOVE_ALL)

mat = FLTARR(3,4)
OPENR, unit, file, /GET_LUN
line = STRING(90)
READF, unit, line
 FOR i=0,3 DO BEGIN
 READF, unit, line
 READS,line,FORMAT='(3(x,f8.3))',a,b,c
 mat(*,i)=[a,b,c]
ENDFOR
FREE_LUN,unit
return, mat
END 



