function PSF_GAUSS1, N1, N2 ;Point spread function window function, 1 or 2 d.
;+
; NAME:
;	PSF_GAUSS1
;
; PURPOSE:
;	Gaussian Window function for Fourier Transform filtering.
;
; CATEGORY:
;	Signal, image processing.
;
; CALLING SEQUENCE:
;	Result = PSF_GAUSS1(N1) ;For 1 dimension.
;
;	Result = PSF_GAUSS1(N1, N2) ;For 2 dimensions.
;
; INPUTS:
;	N1:	The number of columns of the result.
;
;	N2:	The number of rows of the result.
;
; OUTPUTS:
;	Returns an array (1 or 2D) containing the Gaussian function
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, Mars 1993.
;-

on_error,2                              ;Return to caller if an error occurs
print,"Enter FWHM (in pixels) "
read,FWHM1

If n_params(0) eq 1 then begin		;1d?
	a=EXP(-(findgen(N1)-N1/2)^2/(2*(FWHM1/2.35)^2))
	;we devide by the integral (which is the first point of the FT)
	b=float(fft(a,1))
	return,a/b(0)
   endif else begin			;2d case
        print,"Enter FWHM (in pixels) second dimension "
        read,FWHM2
	row = EXP(-(findgen(N1)-N1/2)^2/(2*(FWHM1/2.35)^2))  ; one row
	col = EXP(-(findgen(N2)-N2/2)^2/(2*(FWHM2/2.35)^2))  ; one column
	a=row # col
	;we devide by the integral (which is the first point of the FT)
	b=float(fft(a,1))
	RETURN,a/b(0,0)
   endelse
end
