function CHI_SQR1,x,df
;+
; NAME:
;	CHI_SQR1
;
; PURPOSE:
;	Background removal by plane (polynomial) fitting
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	back = CHI_SQR1,x,df
;
; INPUTS:
;	x: the value to test
;	df: the degree of freedom
;
; OUTPUTS:
;	The result of the chi square test.
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	Recoded in C from the IDL routine : /usr/local/idl/lib/obsolete/chi_sqr1.pro
;	Julien Bourgeoi, August 97
;-

res = 0.0

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'chi_sqr.so'),'ext_chi_sqr',FLOAT(x), FLOAT(df), res)
RETURN,res
END




