#include "Export.h"
#include <math.h>
#include "Manip.h"

double gammaln(xx)
     double xx;
{
  double x, tmp, ser;
  static double cof[6]={76.18009173,
			  -86.50532033,
			  24.01409822,
			  -1.231739516,
			  0.120858003e-2,
			  -0.536382e-5};

  int j;
  
  x = xx-1.0;
  tmp=x+5.5;

  tmp -= (x+0.5)*log(tmp);
  ser=1.0;
  for(j = 0; j <= 5; j++)
    {
      x += 1.0;
      ser += cof[j] / x;
    }

  return (-tmp+log(2.50662827465*ser));
}

double g_series(x,a)
     double x;
     double a;
{
  FArray resarray;
  int i,k=0;
  double glog = gammaln(a);
  double sum = 0.0;
  double result;
  IDL_LONG nsample;

  nsample = (IDL_LONG) max((IDL_LONG)(x/50.0),1000);

  resarray = CreateFArray((int)nsample,1);
  for(i = 0; i < nsample; i++)
    {
      resarray.e[0][i] = 1.0/(k+a);
      if (i >= 1)
	resarray.e[0][i] = x*resarray.e[0][i];
      k++;
    }
  sum = 1.0/a;

  for(i = 1; i < nsample; i++)
    {

      resarray.e[0][0] = resarray.e[0][0]*resarray.e[0][i];

      sum = sum + resarray.e[0][0];
      if (fabs(resarray.e[0][0]) < (fabs(sum) * 3.0e-7))
	{
	  result = sum * exp(-x+a*log(x) - glog);
	  FDelete(resarray);
	  return result;
      	}
    }
  result = -1;
  FDelete(resarray);
  return result;
}


double g_fract(x,a)
double x,a;
{
  double glog = gammaln(a);
  double gd = 0.0;
  double fc = 1.0;
  double a1, ana;
  double b1 = 1.0;
  double bo = 0.0;
  double ao = 1.0;
  double an,g,anf;
  double result;
  int n;

  a1 = x;
  for(n = 1; n <= 100; n++)
    {
      an = (double) n;
      ana = an - a;
      ao = (a1 + ao*ana) * fc;
      bo = (b1 + bo*ana) * fc;
      anf = an * fc;
      a1 = x * ao + anf * a1;
      b1 = x * bo + anf * b1;
      if (a1 != 0)
	{
	  fc = 1.0 / a1;
	  g = b1 * fc;
	  if (fabs((g-gd)/g) < 3.0e-7)
	    {
	      result = exp(-x  + a*log(x) - glog) * g;
	      return result;
	    }
	  gd = g;
	}
    }
  result = -1;
  return result;
}

double igamma_pdf(a,x)
double a,x;
{
  double r;

  if (x < (a+1.0))
    {

      return (g_series(x,a));

    }
  else
    {

      r = g_fract(x,a);
      if (r != -1)
	{
	  return (1.0-r);
	}
      else
	{
	  return -1;
	}

    }
}

double chi_sqr(x,df)
    double x,df;
{
  double gres;

  if (x <= 0.0)
    return 0.0;

  else
    {
      gres = igamma_pdf(df/2.0, x/2,0);
      if (gres != -1)
	{
	  return gres;
	}
    }
}

void ext_chi_sqr(argc,argv)
int argc;
char *argv[];
{
  float x  = *(float *) argv[0];
  float df = *(float *) argv[1];
  float *res;
  res = (float *) argv[2];
  *res = (float) chi_sqr(x,df);
}








