;batch file to integrate DENZO data
;+
;LATEST VERSION : 04/07/96
;batch file for integration:
; 
;
;******************************************************************;
;PARAMETERS TO BE DEFINED BY USER;
;******************************************************************;

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& PARAMETERS FOR LOG FILE &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for log file
logdir = '/data/opid09/external/ls519/integ/' ; <--- HERE
logfile = 'integ_w3_1.log' ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&& PARAMETERS FOR LAUEGEN PATTERN PREDICTION &&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;Input the geascdir and geasc_root:
; File name: 'geascdir+geasc_root+image_no+geasc_ext
; set extension to nothing.
geascdir= '/data/opid09/external/ls519/lauegen/' ; <--- HERE
geasc_root= 'w3_' ; <--- HERE
geasc_ext= '' ; <--- HERE

; Set to 1 if you want to refine the predictions locally
; to maximum pixel intensity, 0 if no local prediction change.
; (Set to 0 if the pattern is weak or streaky)

change_pred= 1 ; [] ; <--- HERE


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&    OUTPUT IDL FILES    &&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& CONTAINING INTEGRATED INTENSITIES &&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for output files containing integrated intensities and parameters
integdir = '/data/opid09/external/ls519/integ/' ; <--- HERE
integfile_root = 'w3_' ; <--- HERE
integfile_ext = '.integ' ; <--- HERE
parfile_ext = '.par' ; <--- HERE


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&& IMAGES TO BE PROCESSED &&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for input image files containing data
; File name:
; 'image_dir+imagefile_root+image_no+imagefile_ext'

imagedir = '/data/opid09/external/ls519/corrected/w1to15/' ; <--- HERE
imagefile_root = 'w3_' ; <--- HERE
imagefile_ext = '.sfc' ; <--- HERE

; input the number of the first and last images to integrate
min_image_no = 1 ; <--- HERE
max_image_no = 1 ; <--- HERE

;Do you want to skip integration of some images ?
skip_images = 0 ; [0 : No ; 1 : Yes] <--- HERE
;If yes input here the numbers of the images to skip
images_skipped = [ $
	4 ] ; <--- HERE 

; Image size [raster] and raster [um] 
xsize=1440 ; <--- HERE
ysize=1520 ; <--- HERE
raster = 100 ; <--- HERE

;In order to suppress predicted spots falling behind the beamstop, the
;pixels in the images standing  behind the beamstop shadow should be 
;set to zero.
;Do you want to apply a beamstop mask ?
set_beamstop_mask = 1 ; [0:No ; 1:Yes] <-- HERE
;To create the beamstop mask use the IDL routine "look_lauegen"
;load the image, expand ('e' command) the region where the mask is to be
;defined and use 'Define a mask' ('m' command).
;Input the full pathname of the relevant file.
beamstop_mask_file = '/data/opid09/external/ls519/integ/w3_001_beamstop.idl' ; <--- HERE

;Do you want to set an additionnal mask (bad area in the detector ...,
;problems due to shadowing of some sort ...) ?
set_mask = 1 ; [0:No ; 1:Yes] <-- HERE
;To create the beamstop mask use the IDL routine "look_lauegen"
;load the image, expand ('e' command) the region where the mask is to be
;defined and use 'Define a mask' ('m' command).
;Input the full pathname of the relevant file.
mask_file= '/data/opid09/external/ls519/integ/w3_001_mask.idl' ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&& PARAMETERS FOR INTEGRATION &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;chosen boxsize for integration [more than 4*spotsizeFWHM is advisable]
boxsize_x = 14 ;[raster] ; <--- HERE
boxsize_y = 14 ;[raster] ; <--- HERE

;do you want to define a region in box for the reference spots ?
;This is useful only if the program has trouble to find a sufficient
;number of reference spots, especially if too few strong spots
;are not well isolated in the images.
set_region = 0 ; [1 : Yes, 0 : No] <--- HERE
;To create the spot region use the IDL routine "look_lauegen"
;load the image, expand ('e' command) a portion of the image
;and use 'Define a spot region for integration' ('g' command).
region_file= '/data/opid09/external/ls519/integ/w3_003_region.idl' ; <--- HERE

;distance below which spots are considered as overlapped (i.e. they 
;will be deconvoluted)  [about 2*spotsizeFWHM is advisable]
ovlp_dist = 0.6 ; [mm] ; <--- HERE

;distance below which it is considered that spots can not be deconcoluted 
;[half of spot FWHM is a good choice]
ovlp_min_dist = 0.14 ; [mm] ; <--- HERE

;distance below which spots are considered as overlapped for
;reference peaks. [in general, OK to use 120% of ovlp_dist]
ovlp_dist_ref = 0.7 ; [mm] ; <--- HERE

;saturation value of the detector
satvalue = 65534 ;[detector counts] ; <--- HERE

;offset of the detector (0 for MAR IP detectors)
det_offset = 0 ;[detector counts] ; <--- HERE

;gain of the detector at 20 keV (1.8 for XRII F/11 detectors)
gain = 1.8 ;[at 20 KeV, no unit] ; <--- HERE

;percentage of pixels in box initially considered as noise for
;background evaluation. Example : if noise_percentage = 10, then the 10%
;lower value pixels will be taken. The correct and final value will be 
;adjusted by the program.
noise_percentage = 25 ;[%] ; <--- HERE

;maximum,minimum number of reference peaks (1000 and 100 are 
;good starting choices)
ref_peaks = 1000 ; <--- HERE
min_ref_peaks = 100 ; <--- HERE

;minimum I/Sig(I) for initial selection as reference peak.
min_sob = 2.0 ; <--- HERE

;radial distance to look around for getting the reference peak when 
;integrating a weak or overlapped peak by profile fitting method.
ref_distance = 50 ; [mm] ; <--- HERE

;angular distance to look around for getting the reference peak when 
;integrating a weak or overlapped peak by profile fitting method.
ref_ang_width = 40 ; [degrees] ; <--- HERE

;in case reference peaks are missing, do you want to extend the search 
;to symmetrical regions of the image (normally : No)
sym_rad = 1 ; [1 : Yes, 0 : No] ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&& PARAMETERS FOR "DEBUGGING" &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

; Set SHOW_IMAGE to 0 to avoid using graphics or 1 to get image displayed
; (with predictions etc). (Set to 1 if any of the SHOW parameters
; below is set to 1.)
show_image = 1  ; <--- HERE

;debug parameter
show_ref_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_strong_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_weak_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_ovlp_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_m = 0; [0: no debug, 1: debug] ; <--- HERE
miller_h = -4 ; <--- HERE
miller_k = 6 ; <--- HERE
miller_l = 0 ; <--- HERE

;info for user about the .flag field
;flag = 0 --> correctly integrated
;flag = 1 --> bad background (spot should be rejected)
;flag = 2 --> bad integrated intensity (spot should be rejected)
;flag = 3 --> spot predicted overlapped but treated as single
;flag = 4 --> weak spot (integrated intensity = 0, variance = 1 arbitrary)
;flag = 5 --> cholewsky method failed (usually means problem with indexing)

;info for user about the .close field
;close = 0 --> non saturated
;close = 1 --> saturated
;close = 1 --> overlapped spot too close to be deconvoluted 
;			 (integrated intensity = 0, variance = 1 arbitrary)

;******************************************************************;
;END OF USUAL INPUT BY USER.
;******************************************************************;
;for safety
CLOSE,1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& CREATE LOG FILE &&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

start_time = SYSTIME(1)
;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdir+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
rem=''
READ,'Log file exists. Remove it [y/n] ? ',rem
IF rem EQ 'y' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL)ELSE GOTO,escape
ENDIF

JOURNAL,STRCOMPRESS(logdir+logfile,/REMOVE_ALL)
PRINT,SYSTIME()

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&& DELETE ALL WINDOWS &&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

FOR i=0,!D.WINDOW+10 DO WDELETE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&& CHOOSE IMAGES TO PROCESS &&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

image_names = FINDFILE(STRCOMPRESS(imagedir+imagefile_root+ $
	'*'+imagefile_ext,/REMOVE_ALL),count=count)
IF (count EQ 0) THEN MESSAGE, 'No images found ...'
image_numbers = FIX(STRMID(image_names,STRLEN(imagedir+imagefile_root),3))
s = WHERE(image_numbers GE min_image_no AND image_numbers LE max_image_no)
image_names = image_names(s)
image_numbers = image_numbers(s)

IF skip_images THEN BEGIN
FOR j=0,(SIZE(images_skipped))(1)-1 DO BEGIN
sk = WHERE(image_numbers NE images_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	image_numbers = image_numbers(sk)
	image_names = image_names(sk)
ENDIF
ENDFOR
ENDIF

PRINT,'Number of images to process : ',(SIZE(image_names))(1)

;s= WHERE(integrate ne 0, count)
;IF count EQ 0 THEN MESSAGE,'No image to process !'
;image_no= image_no(s) 

images= (SIZE(image_names))(1)

frame_start=INTARR(images)
frames=INTARR(images)+1
;frame_start= frame_start(s)
;frames= frames(s)

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&& PRINT INFORMATION &&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
@batch_info_laue

;suppress nasty messages for arithmetic errors
junk = CHECK_MATH(trap = 0)

IF show_image THEN BEGIN
	WIN,xsize/2,ysize/2
	LOADCT,0
	blue_col=[255,0,0]
	green_col=[0,255,0]
	red_col=[0,0,255]
	TVLCT,red_col,green_col,blue_col,!D.N_COLORS-3
ENDIF

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& PREDICT AND INTEGRATE EACH IMAGE &&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

FOR i=0,(images-1) DO BEGIN
    CATCH, error_status
    IF (error_status ne 0) THEN BEGIN
      BATCH_ERROR, image_name
      error_status=0
      GOTO, end_of_image
    ENDIF
      image_name=image_names(i)
;STRCOMPRESS(imagedir+imagefile_root+ $
;	STRING(image_no(i))+imagefile_ext,/REMOVE_ALL)
start_image_time = SYSTIME(1)
PRINT, 'Time from beginning of session [s] : ',start_image_time-start_time
    PRINT, 'Image name : ',image_name

;&&&&&&&&& GET PREDICTED REFLECTIONS &&&&&&&&&&&&&

	   geasc_name=STRCOMPRESS(geascdir+geasc_root+ $
		STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+geasc_ext,/REMOVE_ALL)
	  dummy=FINDFILE(geasc_name+'.gen', count=count)
	  IF (count eq 0) THEN MESSAGE, "Couldn't find .gen file."
	  dummy=FINDFILE(geasc_name+'.geasc', count=count)
	  IF (count eq 0) THEN SPAWN, $
		'source ' + STRTRIM(GETENV('PROW_SCR')+'get_geasc.scr') + ' ' + geasc_name
	  dummy=FINDFILE(geasc_name+'.geasc', count=count)
	  IF (count eq 0) THEN MESSAGE, "Couldn't find GEASC- or GE1/GE2-files."

	refl = READ_GEASC2(geasc_name, par)

	IF set_region EQ 1 THEN BEGIN
		    RESTORE,region_file
		IF (boxsize_x NE boxsize_x2) OR (boxsize_y NE boxsize_y2) THEN MESSAGE,'Spot region incompatible with chosen boxsize !'
	    	    par = CREATE_STRUCT(par,'region',region)
	ENDIF ELSE  par = CREATE_STRUCT(par,'region',0)
 
	WRITEPAR_LAUE2,par,beamsize=0,sample_depth=0,$
	   	dark_current=det_offset,boxsize={x:boxsize_x,y:boxsize_y},gain=gain,$
	  	noise_percentage=noise_percentage,satvalue=satvalue,$
	   	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist

;&&&&&&&&& OPEN IMAGE AND DISPLAY IT &&&&&&&&&&&&&
 
    ;check the image file :
    PRINT,'Checking image file.'
    SPAWN,'date', date & PRINT, date
    SPAWN,'file ' + image_name
    SPAWN,'date', date & PRINT, date
    image=READ_BIN(image_name,ysize,xsize,0)
    image=ROTATE(image,1)

    IF (SIZE(image))(0) EQ 2 THEN BEGIN  ; file exists
   
      ; Set image behind beamstop to zero so that ROILAUE2 removes 
      ; predictions in this region:
    IF set_beamstop_mask EQ 1 THEN BEGIN
      RESTORE, beamstop_mask_file
      image(mask) = 0
    ENDIF
    IF set_mask EQ 1 THEN BEGIN
      RESTORE, mask_file
      image(mask) = 0
    ENDIF

      red=REBIN(image,xsize/2,ysize/2)
    
      ;display the image
      IF show_image THEN BEGIN
	  index_sat=WHERE(red GE satvalue, count_sat)
	  red_displayed = (!D.N_COLORS-2)*ALOG(red>1)/ALOG(satvalue)
	  ; Set the marked pixels to such a high value so that after rebinning
	  ; it is still above !D.N_COLORS-1 :
  	  IF (count_sat gt 0) THEN  red_displayed(index_sat)= 10.0^20
	  TV, red_displayed < (!D.N_COLORS-1)
      ENDIF

read_image_time = SYSTIME(1)
PRINT, 'Time to read image and prediction [s] : ',read_image_time-start_image_time

      ;take only the spots inside image and where the image is not empty
      refl2 = ROILAUE3(refl,image,par,0,0,xsize-1,ysize-1)

;&&&&&&&&& ADDITIONAL REFINEMENT IF WANTED &&&&&&&&&&&&&

IF change_pred EQ 1 THEN BEGIN
      PRINT,'Searching for overlaps ...[for refinement]'
      ; Find overlaps to avoid that refinement brings two spots at the 
;same position
      FIND_QUICKOVLP,refl2,par,3*SQRT(2)*raster*0.001
ENDIF

  ;run the matchlaue5 routine 1 times with changing positions
      refl_obs=MATCHLAUE5(refl2,image,par,0,weak,sigma,back, $
	change_pred=change_pred)

match_image_time = SYSTIME(1)
PRINT, 'Time for internal refinement [s] : ',match_image_time-read_image_time

      ;overplot predicted positions on image
      IF show_image THEN dummy = PIXLAUE2(refl_obs,red,image,par,draw=4,color=2)

;&&&&&&&&& SEARCH FOR OVERLAPS &&&&&&&&&&&&&
      PRINT,'Searching for overlaps ...[reference spots]'
      ; Find overlaps when selecting reference peaks; severe criteria!
      FIND_QUICKOVLP,refl_obs,par, ovlp_dist_ref
      refl_obs.ovlp2=refl_obs.ovlp
      ;get the overlapping pattern
      PRINT,'Searching for overlaps ...[all spots]'
      FIND_OVLP2,refl_obs,par,par.ovlp_dist,par.ovlp_min_dist

      ;print statistics on overlapping spots
      dum = WHERE(refl_obs.ovlp GT 0,number_ovlp)
      PRINT,'Number of overlapping peaks : ',number_ovlp
      PRINT,'Percentage of overlapped peaks : ', $
	100*number_ovlp/FLOAT((SIZE(refl_obs))(1))


ovlp_image_time = SYSTIME(1)
PRINT, 'Time for finding overlaps [s] : ',ovlp_image_time-match_image_time

;&&&&&&&&& INTEGRATION &&&&&&&&&&&&&

    PRINT,'Integrating :',image_name

      miller = [miller_h,miller_k,miller_l]

;integrate the data with profile fitting and overlap deconvolution

    
      integ = INTEGRATE_LAUE8(image,red,refl_obs,par,ref_peaks=ref_peaks, $
	min_ref_peaks=min_ref_peaks, $
	min_sob=min_sob, ref_distance=ref_distance, $
	ref_ang_width=ref_ang_width, $
	show_image=show_image, show_ref_peaks=show_ref_peaks, $
	show_strong_peaks=show_strong_peaks, show_weak_peaks=show_weak_peaks, $
	show_ovlp_peaks=show_ovlp_peaks, show_m=show_m, miller=miller, $
	sym_rad=sym_rad)

integ_image_time = SYSTIME(1)
PRINT, 'Time for integration [s] : ',integ_image_time-ovlp_image_time

      ;statistics on singles
      PRINT,'Percentage of single reflexions : ', $
	100*(SIZE(WHERE(refl_obs.mul EQ 1)))(1)/FLOAT((SIZE(refl_obs))(1))

      ;remove saturated spots and spots too close to integrate !
      integ = integ(WHERE(integ.close EQ 0))

      ;add weak spots if necessary
	IF (SIZE(weak))(0) GE 1 THEN integ = MERGE_INTEG(integ,weak)

	;get some statistics
     w=WHERE(integ.flag eq 2,ct)
PRINT,''
PRINT,'&&&&&& SOME STATISTICS &&&&&'
     w=WHERE(integ.flag eq 2,ct)
PRINT,STRCOMPRESS('Number of spots with bad integrated intensities : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 1,ct)
PRINT,STRCOMPRESS('Number of spots with bad background : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 5,ct)
PRINT,STRCOMPRESS('Number of spots with bad deconvolution : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')


        file_save1 = STRCOMPRESS(integdir+integfile_root+ $
	  STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+integfile_ext,/REMOVE_ALL)
        file_save2 = STRCOMPRESS(integdir+integfile_root+ $
 	  STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+parfile_ext,/REMOVE_ALL)

      SAVE,file=file_save1,integ,par
      SAVE,file=file_save2,par

      PRINT,''
    ENDIF ELSE BATCH_ERROR, image_name
    end_of_image:

end_image_time = SYSTIME(1)
PRINT, 'Total time for this image [s] : ',end_image_time-start_image_time

ENDFOR ; Image loop

JOURNAL

;remove garbage in the logfile
SPAWN,'/bin/cp ' + STRCOMPRESS(logdir+logfile,/REMOVE_ALL) + ' temp'
;SPAWN,'awk '' $1 !~ /;o./ && $1 !~ /;\*/ && $1 !~ /;b/ {print}'' temp'+' > '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL)
SPAWN,'awk '' $1 !~ /;o./ && $1 !~ /;\*/ && $1 !~ /;b/ && $1 !~ /;i/ && $1 !~ /;s/ {print}'' temp'+' > '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL)

escape :
;***********************************
END
;***********************************
;-





