;+
; NAME:
;	IDLCHECK_BATCH
;
; PURPOSE:
;
;	Batch file exemple for checking integration with IDL.
;	Modify this file for your own purpose.
;	To do that type :
;	"cp /users/o/ursby/idl/pub/integ/batch/idlcheck_batch.pro ./mybatch.pro"
;	This brings the file into your directory.
;	Then edit and modify the file with emacs, vi ...
;	Start idl and type ".run mybatch"
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	.run IDLCHECK_BATCH
;
;
; MODIFICATION HISTORY : LAST VERSION IS : JUNE 8th, 1995
;
; HERE FOLLOWS THE EXEMPLE :
;
;;batch file to check integration of files CUTIN22_4_1.SFC --> CUTIN22_4_18.SFC;
;
;;******************************************************************;
;;PARAMETERS TO BE DEFINED BY USER;
;;******************************************************************;
;
;;info for intput files containing integrated intensities
;integdir = '/users/o/bourgeoi/laue/cut_may/' ; <--- HERE
;integfile_root = 'cut22_4_' ; <--- HERE
;integfile_ext = '.integ' ; <--- HERE
;integnumber_start = 1 ; <--- HERE
;integnumber_end = 18 ; <--- HERE
;
;;info for input files containing data
;imagedir = '/data/i/opid09/data/xrii/cut_may/SFC/' ; <--- HERE
;imagefile_root = 'cut22_4_' ; <--- HERE
;imagefile_ext = '.sfc' ; <--- HERE
;imagenumber_start = 1 ; <--- HERE
;imagenumber_end = 18 ; <--- HERE
;
;;image size
;xsize=1152 ; <--- HERE
;ysize=1242 ; <--- HERE
;
;;rebin factor
;reb = 2 ; <--- HERE
;
;;overlay prediction ?
;plot_pred = 1 ; [0 : No, 1 : Yes] <--- HERE
;
;;******************************************************************;
;;END
;;******************************************************************;
;
;WIN,xsize/reb,ysize/reb
;i = 0
;
;REPEAT BEGIN
;READ,'Which image to inspec [-1 to quit] : ',i
;IF i NE -1 THEN BEGIN
;integnumber = integnumber_start + i - imagenumber_start
;
;image_name=STRCOMPRESS(imagedir+imagefile_root+STRING(i)+imagefile_ext,/REMOVE_ALL)
;
;integ_name=STRCOMPRESS(integdir+integfile_root+STRING(integnumber)+integfile_ext,/REMOVE_ALL)
;
;PRINT,'Inspecting :',image_name
;
;;getting the integrated intensities and the parameters
;PRINT,'Getting integrated intensities ...'
;RESTORE,integ_name
;
;PRINT,'Opening image ...'
;image=READ_BIN(image_name,ysize,xsize,0)
;
;IF (SIZE(image))(0) EQ 2 THEN BEGIN  ; file exists
;image=ROTATE(image,4)
;red = DISP_RED(image,reb)
;
;;overplot predicted positions on image
;IF plot_pred EQ 1 THEN dummy = PIXLAUE2(integ,red,image,par,draw=4,color=30)
;
;SPOTLAUE3,integ,image,par,reb,/show
;
;ENDIF ; image exists
;ENDIF
;ENDREP UNTIL i EQ -1
;WDELETE
;END
;
;
;
;-

