function WHERE_BGCORREL, struc1,struc2,j
;+
; NAME:
;	WHERE_BGCORREL
;
; PURPOSE:
;	Returns the location of the common pixel values between
;	struc1.bg_indices and struc2.peak_indices. The structures
;	must contain the fields .bg_indices and .peak_indices, respectively.
;	The returned location is
;	relevant to the field struc1.bg_indices: ie struc1.bg_indices(w) will be 
;	the indices in common with struc2.peak_indices, where w is what is
;	returned by the routine
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	w = WHERE_BGCORREL(struc1,struc2,j) ;
;
; INPUTS:
;	struc1,2 : the structures to process. These are structures, not array
;		of structures.
;
; OUTPUTS:
;	w : The indices of struc1 common to struc2.
;	j : [optionnal] returns the number of common pixels
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 95.
;-

;on_error,2                              ;Return to caller if an error occurs

;number of pixels to process
w1 = WHERE(struc1.bg_indices GT 0,num_pixel1)
w2 = WHERE(struc2.peak_indices GT 0,num_pixel2)

j = 0
IF num_pixel1 EQ 0 THEN RETURN,0 ;in this case the spot is already empty !

w = INTARR(num_pixel1)

;Check the intersection between struc1.bg_indices and struc2.peak_indices

FOR i=0,num_pixel1-1 DO BEGIN
;IF i/100 EQ i/100.0 THEN PRINT,i,' ie :',100.*i/FLOAT(num_pixel1),'%'
 index = WHERE(struc2.peak_indices(w2) EQ (struc1.bg_indices(w1))(i), count)

 IF count GT 0 THEN BEGIN
    w(j) = i
    j = j + 1
 ENDIF
ENDFOR

;PRINT,'Number of common pixels : ',j
;PRINT,'Percentage : ', 100*j/FLOAT(num_pixel1)

IF j NE 0 THEN RETURN,w(0:j-1) ELSE RETURN,-1
END






