
;****************************************

PRO GET_CONNECT,index,spot_list,index_in_index_list,index_list

spot_list(index).ovlp = -1

;set a counter for the field "connect"
i=0

;get the connecting spots
WHILE (spot_list(index).connect(i) GT 0) DO BEGIN
;print,'index :',index
;print,'i:', i
id = spot_list(index).connect(i)
;print,'connecting to :',id
;is the spot with id_number "id" in the list spot_list ?
;and has it been already selected ?
j = WHERE(spot_list.id EQ id)
;print,'found spot :',j
IF (SIZE(j))(0) NE 0 THEN BEGIN
IF spot_list(j).ovlp GE 0 THEN BEGIN
;add the spot to the ovlp_spots list
;print,'carrying on'
index_list(index_in_index_list)=j
;print,'ovlp_index',index_in_index_list
index_in_index_list = index_in_index_list + 1
GET_CONNECT,j,spot_list,index_in_index_list,index_list

ENDIF
ENDIF
IF i LT 23 THEN i=i+1 ELSE GOTO, out
ENDWHILE
out :
END

;******************************************


FUNCTION GET_OVLP_REG,spot_list,index,index_list
;+
; NAME:
;	GET_OVLP_REG
;
; PURPOSE:
;	From a certain spot, whose index is "index" in the list of spots
;	spot_list, the routine will find out which spots from spot_list
;	are connected to the overlapping region containing that spot.
;
; CATEGORY:
;	Laue processing.
;
; CALLING SEQUENCE:
;	ovlp_spots = GET_OVLP_REG(spot_list,index,index_list)
;
; INPUTS:
;	spot_list : a structure containing the spot information
;	index : the index of the spot being overlapped with other spots
;		which are searched for in this routine.
;
; OUTPUTS:
;	ovlp_spots : a part of spot_list containing the overlapped spots
;	index_list : optionnal output: contains the indices in spot_list 
;		involved into the overlap.
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	Spot_list.ovlp is changed to -1 for the spots involved in the 
;	overlapping.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	It employs a nested procedure called GET_CONNECT.
;	From the spot index, the connecting
;	spots are looked for and added to the list ovlp_spots. Each of the 
;	connecting spots are again searched for other connecting spots, until
;	the overlapping region is fully searched. (This is a sort of
;	arborescence)
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, November 94
;-

;ON_ERROR,2                              ;Return to caller if an error occurs

;***************************************


;get the dimension and size of the spot_list
number_spots=(SIZE(spot_list))(1)
;the maximum number of overlapping spots is set to 200
max_ovlp = 200 > 0.1*number_spots
ovlp_spots = REPLICATE(spot_list(index),max_ovlp)
;make a list of the indices of the overlapped peaks
index_list=LONARR(max_ovlp)
index_list(0)=index
index_in_index_list=1
;search for the connexions
GET_CONNECT,index,spot_list,index_in_index_list,index_list

;get the interesting part of index_list
;print,'Number of connecting spots : ',index_in_index_list
index_list=index_list(0:index_in_index_list-1)
;print,'Indices of connecting spots : ',index_list
ovlp_spots(0:index_in_index_list-1)=spot_list(index_list)
RETURN,ovlp_spots(0:index_in_index_list-1)
END


