FUNCTION GET_INTERP_PROFILE,adapted_profile,x,y,SHOW=SHOW,REVERSE=REVERSE,CUBIC=CUBIC
;+
; NAME:
;	GET_INTERP_PROFILE
;
; PURPOSE:
;	Interpolates a profile in order to shift it towards a position
;	defined by x,y.
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	adapted_profile2=GET_INTERP_PROFILE(adapted_profile,x,y,SHOW=SHOW,REVERSE=REVERSE,CUBIC=CUBIC)	
;
; INPUTS:
;	adapted_profile : a 2D array
;	x		: predicted x spot position [raster]
;	y		: predicted y spot position [raster]
;	show : keyword set to look at what happens
;	reverse : keyword set if the shift is done in opposite direction : this is used if
;		a non centered profile is to be brought back to the center of the box. 
;	cubic : set this parameter to the value given to the CUBIC keyword of the IDL routine
;		INTERPOLATE. Set to -0.5 for IDL vsn 5.0. Default=-0.5. Set to 1 for vsn 4.0 ?
;
; OUTPUTS:
;	adapted_profile2 : the shifted profile
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Based on cubic interpolation.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 97.
;-

sx=(SIZE(adapted_profile))(1) & sy=(SIZE(adapted_profile))(2)

x2 = (x MOD 1) - 0.5
y2 = (y MOD 1) - 0.5

IF KEYWORD_SET(reverse) THEN BEGIN
 x2=-x2
 y2=-y2
ENDIF

IF N_ELEMENTS(cubic) EQ 0 THEN cubic = -0.5

adapted_profile2 = INTERPOLATE(adapted_profile,INDGEN(sx) - x2, INDGEN(sy) - y2, CUBIC=cubic,/GRID)

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'REFERENCE PROFILE :'
 PRINT,'Original reference profile + New reference profile : '
 PRINT,'X/Y values [pixels] : ',x,y
 temp = adapted_profile
 temp2 = adapted_profile2
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 1
 CONTOUR,temp2,LEVELS=[(INDGEN(10)+1)*MAX(temp2)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 2

 OK=''
 READ,'OK ? [Y/N]',OK

ENDIF

RETURN,adapted_profile2
END


