function GET_BOXVAR,ii,n_peak,back,n_back,gain,bg_gain,dark_current,show=show
;+
; NAME:
;	GET_BOXVAR
;
; PURPOSE
;	For box integration, returns the variance (sigma^2) of an integrated peak
;	according to Poisson statistics
;
; CATEGORY:
;	Laue processing
;
; CALLING SEQUENCE:
;	variance = GET_BOXVAR(ii,n_peak,back,n_back,gain,bg_gain,dark_current,/show)
;
; INPUTS:
;	ii : the integrated intensity.
;	n_peak : the number of pixels used to calculate the integrated intensity
;	back : the constant level background value.
;	n_back : the number of pixels used to calculate the background
;	gain : the gain of the detector at the peak energy
;	bg_gain : the mean gain of the detector for background
;	dark_current : the dark_current (offset) of the detector
;	show : set this keyword to show information
;
; OUTPUTS:
;	variance : the variance of the integrated intensity.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The formula is adapted from A.G.W Leslie.
;	Molecular Data Processing, Chapter 4
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1995.
;-

variance = gain*ii + bg_gain*n_peak*(1 + n_peak/FLOAT(n_back))*(back - dark_current)

IF KEYWORD_SET(show) THEN BEGIN
PRINT,'Variance (sigma^2) [counts] :',variance
ENDIF

RETURN,variance
END








