FUNCTION GET_BEST_PROFILE3,adapted_profile,area,peak_area,w_max_corr,SHOW=SHOW

sx=(SIZE(adapted_profile))(1) & sy=(SIZE(adapted_profile))(2)

p = CONGRID(adapted_profile,4*sx,4*sy,/CUBIC)

orig_xind = REPLICATE(1,sx) # INDGEN(sy)*16*sx
orig_yind = INDGEN(sx)*4 # REPLICATE(1,sy)
orig_ind=orig_xind + orig_yind 

n=0

REPEAT BEGIN

corr_array = [ $

CORRELATE((p(orig_ind))(peak_area), area(peak_area)) , $ ; move x 0 y 0
CORRELATE((p(orig_ind+4*sx))(peak_area), area(peak_area)) , $  ; move x 0 y -0.25
CORRELATE((SHIFT(p(orig_ind+12*sx),0,1))(peak_area), area(peak_area)) , $  ; move x 0 y 0.25

CORRELATE((p(orig_ind+1))(peak_area), area(peak_area)) , $  ; move x -0.25 y 0
CORRELATE((p(orig_ind+4*sx+1))(peak_area), area(peak_area)) , $  ; move x  -0.25 y -0.25
CORRELATE((SHIFT(p(orig_ind+12*sx+1),0,1))(peak_area), area(peak_area)) , $  ; move x -0.25 y 0.25

CORRELATE((SHIFT(p(orig_ind+3),1,0))(peak_area), area(peak_area)) , $  ; move x 0.25 y 0
CORRELATE((SHIFT(p(orig_ind+4*sx+3),1,0))(peak_area), area(peak_area)) , $  ; move x 0.25 y -.25
CORRELATE((SHIFT(p(orig_ind+12*sx+3),1,1))(peak_area), area(peak_area))  $  ; move x 0.25 y 0.25
	 ]


;find the maximum
w_max_corr=(WHERE(corr_array EQ MAX(corr_array)))(0)


CASE w_max_corr OF 

 0 : BEGIN
	adapted_profile2 = p(orig_ind)
	GOTO,got_it
     END

 1 : BEGIN
	i=0 & j=-1
     END

 2 : BEGIN
	i=0 & j= 1
     END

 3 : BEGIN
	i=-1 & j= 0
     END

 4 : BEGIN
	i=-1 & j=-1
     END

 5 : BEGIN
	i=-1 & j= 1
     END

 6 : BEGIN
	i= 1 & j= 0
     END

 7 : BEGIN
	i= 1 & j=-1
     END

 8 : BEGIN
	i= 1 & j= 1
     END

ENDCASE

p=SHIFT(p,i,j)
n=n+1

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'Initial correlation : ',corr_array(0)
 PRINT,'Final correlation : ',corr_array(w_max_corr)

ENDIF


ENDREP UNTIL n EQ 4

CASE w_max_corr OF 

 1 : BEGIN
	adapted_profile2 = p(orig_ind+4*sx) ; move x 0 y -0.25
	GOTO,got_it
     END

 2 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx),0,1) ; move x 0 y 0.25
	GOTO,got_it
     END


 3 : BEGIN
	adapted_profile2 = p(orig_ind+1) ; move x -0.25 y 0
	GOTO,got_it
     END

 4 : BEGIN
	adapted_profile2 = p(orig_ind+4*sx+1) ; move x  -0.25 y -0.25
	GOTO,got_it
     END


 5 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx+1),0,1) ; move x -0.25 y 0.25
	GOTO,got_it
     END


 6 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+3),1,0) ; move x 0.25 y 0
	GOTO,got_it
     END

 7 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+4*sx+3),1,0) ; move x 0.25 y -.25
	GOTO,got_it
     END

 8 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx+3),1,1) ; move x 0.25 y 0.25
	GOTO,got_it
     END

ENDCASE

got_it:

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'Original adapted profile + original profile : '
 temp = adapted_profile
 temp(*) = 0
 temp(peak_area) = adapted_profile(peak_area)
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,area,LEVELS=[(INDGEN(10)+1)*MAX(area)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 OK=''
 READ,'OK ? [Y/N]',OK

 PRINT,'New adapted profile + original profile : '
 temp = adapted_profile2
 temp(*) = 0
 temp(peak_area) = adapted_profile2(peak_area)
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,area,LEVELS=[(INDGEN(10)+1)*MAX(area)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 READ,'OK ? [Y/N]',OK

ENDIF

RETURN,adapted_profile2
END





